/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.ConstExpr;
import jacorb.idl.ConstType;
import jacorb.idl.Declaration;
import jacorb.idl.FixedPointConstType;
import jacorb.idl.FloatType;
import jacorb.idl.IdlSymbol;
import jacorb.idl.IntType;
import jacorb.idl.NameAlreadyDefined;
import jacorb.idl.NameTable;
import jacorb.idl.OctetType;
import jacorb.idl.ScopedName;
import jacorb.idl.ShortType;
import jacorb.idl.parser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

class ConstDecl
extends Declaration {
    private static Hashtable values = new Hashtable();
    private ScopedName t = new ScopedName(IdlSymbol.new_num());
    private int pos_int_const;
    private boolean int_const_set = false;
    public ConstExpr const_expr;
    public ConstType const_type;

    public ConstDecl(int n) {
        super(n);
    }

    public static String namedValue(ScopedName scopedName) {
        String string = scopedName.resolvedName();
        if (values.containsKey(string)) {
            return (String)values.get(string);
        }
        System.out.println(String.valueOf(string) + " not a defined constant");
        return string;
    }

    public void setPackage(String string, boolean bl) {
        string = parser.pack_replace(string);
        super.setPackage(string, bl);
        this.const_type.setPackage(string, bl);
        this.const_expr.setPackage(string, bl);
        this.t.typeName = this.name;
        this.t.setPackage(string, bl);
    }

    public void parse() {
        try {
            NameTable.define(this.full_name(), "constant");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.error("Constant " + this.full_name() + " already defined", this.token);
        }
        this.const_type.parse();
        this.const_expr.parse();
        this.t.typeName = this.name;
        values.put(this.t.resolvedName(), this.const_expr.value());
    }

    int pos_int_const() {
        if (!this.int_const_set) {
            this.pos_int_const = this.const_expr.pos_int_const();
            this.int_const_set = true;
        }
        return this.pos_int_const;
    }

    public void printContained(PrintWriter printWriter) {
        printWriter.print("\t" + this.const_type + " " + this.name + " = ");
        if (this.const_type.symbol instanceof IntType && ((IntType)this.const_type.symbol).type_spec instanceof ShortType) {
            printWriter.print("(short)(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
            return;
        }
        if (this.const_type.symbol instanceof FloatType) {
            printWriter.print("(float)(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
            return;
        }
        if (this.const_type.symbol instanceof FixedPointConstType) {
            printWriter.print("new java.math.BigDecimal(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
            return;
        }
        if (this.const_type.symbol instanceof OctetType) {
            printWriter.print("(byte)(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
            return;
        }
        this.const_expr.print(printWriter);
        printWriter.println(";");
    }

    public void print(PrintWriter printWriter) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        try {
            String string;
            String string2 = ScopedName.unPseudoName(this.full_name());
            if (string2.indexOf(46) > 0) {
                this.pack_name = string2.substring(0, string2.lastIndexOf(46));
                string = string2.substring(string2.lastIndexOf(46) + 1);
            } else {
                this.pack_name = "";
                string = string2;
            }
            String string3 = String.valueOf(parser.out_dir) + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File file = new File(string3);
            if (!file.exists() && !file.mkdirs()) {
                System.err.println("Unable to create " + string3);
                System.exit(1);
            }
            String string4 = String.valueOf(string) + ".java";
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string4)));
            if (!this.pack_name.equals("")) {
                printWriter2.println("package " + this.pack_name + ";");
            }
            printWriter2.println("public interface " + string);
            printWriter2.println("{");
            printWriter2.print("\t" + this.const_type.toString() + " value = ");
            if (this.const_type.symbol.typeSpec() instanceof ShortType) {
                printWriter2.print("(short)(" + this.const_expr.toString() + ");");
            } else if (this.const_type.symbol.typeSpec() instanceof FloatType) {
                printWriter2.println("(float)(" + this.const_expr.toString() + ");");
            } else if (this.const_type.symbol.typeSpec() instanceof OctetType) {
                printWriter2.println("(byte)(" + this.const_expr.toString() + ");");
            } else if (this.const_type.symbol.typeSpec() instanceof FixedPointConstType) {
                printWriter2.println("new java.math.BigDecimal(" + this.const_expr.toString() + ");");
            } else {
                printWriter2.println(String.valueOf(this.const_expr.toString()) + ";");
            }
            printWriter2.println("}");
            printWriter2.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
            return;
        }
    }
}

