/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.Declaration;
import jacorb.idl.Definitions;
import jacorb.idl.IdlSymbol;
import jacorb.idl.lexer;
import jacorb.idl.parser;
import java.io.PrintWriter;

class Module
extends Declaration {
    public Definitions spec;
    private String versionPrefix = "";

    public Module(int n) {
        super(n);
        this.pack_name = "";
    }

    public void setPackage(String string, boolean bl) {
        string = parser.pack_replace(string);
        if (this.pack_name.length() > 0) {
            this.pack_name = new String(String.valueOf(string) + "." + this.pack_name);
            this.spec.setPackage(string, bl);
            return;
        }
        this.pack_name = string;
        if (lexer.needsJavaEscape(this)) {
            this.pack_name = "_" + string;
        }
        this.name = this.pack_name;
        this.spec.setPackage(this.pack_name, bl);
    }

    String full_name() {
        return this.pack_name;
    }

    public void set_included(boolean bl) {
        this.included = bl;
        this.spec.set_included(bl);
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
        this.spec.setEnclosingSymbol(this);
    }

    public void parse() {
        this.spec.parse();
    }

    public void print(PrintWriter printWriter) {
        this.spec.print(printWriter);
    }
}

