/*
 * Decompiled with CFR 0.152.
 */
package jacorb.idl;

import jacorb.idl.Entry;
import jacorb.idl.Environment;
import jacorb.idl.parser;
import jacorb.idl.str_token;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java_cup.runtime.symbol;

class IdlSymbol
extends symbol
implements Serializable {
    private static int num = 10000;
    public String pack_name = "";
    String name = "";
    protected boolean is_pseudo = false;
    protected boolean included = false;
    protected boolean inhibitionFlag = parser.getInhibitionState();
    str_token token;
    private String _id;
    protected IdlSymbol enclosing_symbol;
    protected String omg_package_prefix = "";
    protected static final char fileSeparator = System.getProperty("file.separator").charAt(0);

    public IdlSymbol(int n) {
        super(n);
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public boolean is_included() {
        return this.included;
    }

    public void set_pseudo() {
        this.is_pseudo = true;
    }

    public boolean is_pseudo() {
        return this.is_pseudo;
    }

    public void set_token(str_token str_token2) {
        this.token = str_token2;
        if (this.token != null) {
            if (this.token.pragma_prefix.equals("omg.org")) {
                this.omg_package_prefix = "org.omg.";
            }
            this.set_name(this.token.str_val);
        }
    }

    public str_token get_token() {
        return this.token;
    }

    public void setPackage(String string, boolean bl) {
        string = parser.pack_replace(string);
        if (this.pack_name.length() > 0) {
            this.pack_name = String.valueOf(string) + "." + this.pack_name;
            return;
        }
        this.pack_name = string;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        if (this.pack_name.length() > 0) {
            this.pack_name = String.valueOf(string) + "." + this.pack_name;
            return;
        }
        this.pack_name = string;
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        Environment.output(5, "Symbol " + this.name + " of type " + this.getClass().getName() + " enclosed by symbol " + idlSymbol.getClass().getName());
        this.enclosing_symbol = idlSymbol;
    }

    public IdlSymbol getEnclosingSymbol() {
        return this.enclosing_symbol;
    }

    public static int new_num() {
        return num++;
    }

    public void set_name(String string) {
        this.name = string;
    }

    String full_name() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            return String.valueOf(this.pack_name) + "." + this.name;
        }
        return this.name;
    }

    String javaName() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            if (!this.pack_name.startsWith("org.omg")) {
                return String.valueOf(this.omg_package_prefix) + this.pack_name + "." + this.name;
            }
            return String.valueOf(this.pack_name) + "." + this.name;
        }
        return this.name;
    }

    public String omgPrefix() {
        return this.omg_package_prefix;
    }

    public void parse() {
    }

    public void print(PrintWriter printWriter) {
        throw new RuntimeException("--abstract--!");
    }

    public void printImport(PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            Enumeration enumeration = parser.import_list.elements();
            while (enumeration.hasMoreElements()) {
                printWriter.println("import " + (String)enumeration.nextElement() + ";");
            }
        }
    }

    public void printIdMethod(PrintWriter printWriter) {
        printWriter.println("\tpublic static String id()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn \"" + this.id() + "\";");
        printWriter.println("\t}");
    }

    String id() {
        IdlSymbol idlSymbol = this.enclosing_symbol;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._id == null) {
            while (idlSymbol != null) {
                str_token str_token2 = idlSymbol.get_token();
                if (str_token2 == null) {
                    idlSymbol = idlSymbol.getEnclosingSymbol();
                    continue;
                }
                if (str_token2.pragma_prefix == null || this.token == null || !str_token2.pragma_prefix.equals(this.token.pragma_prefix)) break;
                stringBuffer.insert(0, String.valueOf(idlSymbol.name) + "/");
                idlSymbol = idlSymbol.getEnclosingSymbol();
            }
            stringBuffer.append(this.name);
            this._id = this.token != null && this.token.pragma_prefix.length() > 0 ? "IDL:" + this.token.pragma_prefix + "/" + stringBuffer.toString().replace('.', '/') + ":1.0" : "IDL:" + stringBuffer.toString().replace('.', '/') + ":1.0";
        }
        return this._id;
    }

    protected boolean generateIncluded() {
        return parser.generateIncluded() && !this.inhibitionFlag;
    }

    public Entry getEntry() {
        return null;
    }
}

