/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.ValueDeclaration;
import org.jacorb.idl.parser;

class ValueBoxDecl
extends ValueDeclaration {
    private boolean written = false;
    private boolean parsed = false;
    TypeSpec typeSpec;

    public ValueBoxDecl(int n) {
        super(n);
        this.pack_name = "";
    }

    public Object clone() {
        return null;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public String signature() {
        return "L" + this.typeName() + ";";
    }

    public boolean basic() {
        return false;
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(string + "." + this.pack_name) : string;
        this.typeSpec.setPackage(string);
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            System.err.println("was " + this.enclosing_symbol.getClass().getName() + " now: " + idlSymbol.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public String toString() {
        return this.typeName();
    }

    public void parse() {
        if (this.parsed) {
            throw new RuntimeException("Compiler error: Struct already parsed!");
        }
        this.escapeName();
        this.typeSpec.parse();
        try {
            ConstrTypeSpec constrTypeSpec = new ConstrTypeSpec(IdlSymbol.new_num());
            constrTypeSpec.c_type_spec = this;
            NameTable.define(this.full_name(), "type");
            TypeMap.typedef(this.full_name(), constrTypeSpec);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            Environment.output(4, nameAlreadyDefined);
            parser.error("Struct " + this.typeName() + " already defined", this.token);
        }
        this.parsed = true;
    }

    public String className() {
        String string = this.typeName();
        if (string.indexOf(46) > 0) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return string;
    }

    public String printReadExpression(String string) {
        return this.toString() + "Helper.read(" + string + ")";
    }

    public String printWriteStatement(String string, String string2) {
        return this.toString() + "Helper.write(" + string2 + "," + string + ");";
    }

    public String holderName() {
        return this.typeName() + "Holder";
    }

    public String getTypeCodeExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("org.omg.CORBA.ORB.init().create_value_box_tc(" + this.typeName() + "Helper.id(),\"" + this.className() + "\"," + this.typeSpec.typeSpec().getTypeCodeExpression() + ")");
        return stringBuffer.toString();
    }

    private void printHolderClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("final public class " + string + "Holder");
        printWriter.println("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\tpublic " + this.typeName() + " value;\n");
        printWriter.println("\tpublic " + string + "Holder ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder (" + this.typeName() + " initial)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.typeName() + "Helper.type();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _read(org.omg.CORBA.portable.InputStream _in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + this.typeName() + "Helper.read(_in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(org.omg.CORBA.portable.OutputStream _out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + this.typeName() + "Helper.write(_out,value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        String string2 = this.typeName();
        printWriter.println("\tpublic " + string + "Helper ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        TypeSpec.printHelperClassMethods(string, printWriter, string2);
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + string2 + " read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + string2 + " result = new " + string2 + "(" + this.typeSpec.typeSpec().printReadExpression("in") + ");");
        printWriter.println("\t\treturn result;");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream out, " + string2 + " s)");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printValueClass(String string, PrintWriter printWriter) {
        String string2 = string;
        if (!this.pack_name.equals("")) {
            string2 = this.pack_name + "." + string;
            printWriter.println("package " + this.pack_name + ";");
        }
        printWriter.println("public class " + string);
        printWriter.println("\timplements org.omg.CORBA.portable.ValueBase");
        printWriter.println("{");
        printWriter.println("\tpublic " + this.typeSpec.typeName() + " value;");
        printWriter.println("\tprivate static String[] _ids = { " + string + "Helper.id() };");
        printWriter.println("\tpublic " + string + "(" + this.typeSpec.typeName() + " initial )");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic String[] _truncatable_ids()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn _ids;");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    public void print(PrintWriter printWriter) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.written) {
            return;
        }
        this.written = true;
        try {
            PrintWriter printWriter2;
            String string = this.className();
            String string2 = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File file = new File(string2);
            if (!file.exists() && !file.mkdirs()) {
                parser.fatal_error("Unable to create " + string2, null);
            }
            String string3 = string + ".java";
            if (this.typeSpec.typeSpec() instanceof BaseType) {
                printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
                this.printValueClass(string, printWriter2);
                printWriter2.close();
            }
            string3 = string + "Holder.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHolderClass(string, printWriter2);
            printWriter2.close();
            string3 = string + "Helper.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHelperClass(string, printWriter2);
            printWriter2.close();
            this.written = true;
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }
}

