/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SimpleTypeSpec;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class SequenceType
extends TemplateTypeSpec {
    private boolean written = false;
    private static int idxNum = 0;
    private boolean recursive = false;
    public ConstExpr max = null;
    public TypeSpec type_spec;
    public int length = 0;

    public SequenceType(int n) {
        super(n);
        this.name = null;
        this.typedefd = false;
    }

    public Object clone() {
        SequenceType sequenceType = new SequenceType(IdlSymbol.new_num());
        sequenceType.type_spec = this.type_spec;
        sequenceType.max = this.max;
        sequenceType.length = this.length;
        sequenceType.name = this.name;
        sequenceType.pack_name = this.pack_name;
        sequenceType.included = this.included;
        sequenceType.typedefd = this.typedefd;
        sequenceType.recursive = this.recursive;
        sequenceType.set_token(this.get_token());
        sequenceType.setEnclosingSymbol(this.getEnclosingSymbol());
        return sequenceType;
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public TypeSpec elementTypeSpec() {
        TypeSpec typeSpec = this.type_spec.typeSpec();
        if (typeSpec instanceof ScopedName) {
            typeSpec = ((ScopedName)typeSpec).resolvedTypeSpec().typeSpec();
        }
        return typeSpec;
    }

    public void setTypeSpec(SimpleTypeSpec simpleTypeSpec) {
        this.type_spec = simpleTypeSpec;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(string + "." + this.pack_name) : string;
        this.type_spec.setPackage(string);
        if (this.max != null) {
            this.max.setPackage(string);
        }
    }

    public boolean typedefd() {
        return this.typedefd;
    }

    public String typeName() {
        return this.elementTypeName() + "[]";
    }

    public void setRecursive() {
        Environment.output(2, "Sequence " + this.typeName + " set recursive ------- this: " + this);
        this.recursive = true;
    }

    public String getTypeCodeExpression() {
        String string = null;
        string = this.recursive ? "org.omg.CORBA.ORB.init().create_sequence_tc(" + this.length + ", org.omg.CORBA.ORB.init().create_recursive_tc(\"" + this.elementTypeSpec().id() + "\"))" : "org.omg.CORBA.ORB.init().create_sequence_tc(" + this.length + ", " + this.elementTypeSpec().getTypeCodeExpression() + ")";
        return string;
    }

    public static int getNumber() {
        return idxNum++;
    }

    public String printReadStatement(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.typeName();
        String string4 = "_l" + string.replace('.', '_');
        if (string4.indexOf("[") > 0) {
            string4 = string4.substring(0, string4.indexOf("[")) + "_";
        }
        string4 = string4 + SequenceType.getNumber();
        stringBuffer.append("int " + string4 + " = " + string2 + ".read_long();\n");
        if (this.length != 0) {
            stringBuffer.append("\t\tif(" + string4 + " > " + this.length + ")\n");
            stringBuffer.append("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Sequence length incorrect!\");\n");
        }
        stringBuffer.append("\t\t" + string + " = new " + string3.substring(0, string3.indexOf("[")) + "[" + string4 + "]" + string3.substring(string3.indexOf("]") + 1) + ";\n");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String string5 = this.elementTypeSpec().printReadExpression(string2);
            stringBuffer.append("\t" + string5.substring(0, string5.indexOf("(")) + "_array(" + string + ",0," + string4 + ");");
        } else {
            char c = 'i';
            String string6 = "";
            if (string.endsWith("]")) {
                c = (char)(string.charAt(string.length() - 2) + '\u0001');
                string6 = "    ";
            }
            stringBuffer.append("\t\t" + string6 + "for(int " + c + "=0;" + c + "<" + string + ".length;" + c + "++)\n\t\t" + string6 + "{\n");
            stringBuffer.append("\t\t\t" + string6 + this.elementTypeSpec().printReadStatement(string + "[" + c + "]", string2) + "\n");
            stringBuffer.append("\t\t" + string6 + "}\n");
        }
        return stringBuffer.toString();
    }

    public String printReadExpression(String string) {
        return this.helperName() + ".read(" + string + ")";
    }

    public String printWriteStatement(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.typeName();
        if (this.length != 0) {
            stringBuffer.append("\t\tif( " + string + ".length > " + this.length + ")\n");
            stringBuffer.append("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect sequence length\");");
        }
        stringBuffer.append("\n\t\t" + string2 + ".write_long(" + string + ".length);\n");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String string4 = this.elementTypeSpec().printWriteStatement(string, string2);
            stringBuffer.append("\t\t" + string4.substring(0, string4.indexOf("(")) + "_array(" + string + ",0," + string + ".length);");
        } else {
            char c = 'i';
            String string5 = "";
            if (string.endsWith("]")) {
                c = (char)(string.charAt(string.length() - 2) + '\u0001');
                string5 = "    ";
            }
            stringBuffer.append("\t\t" + string5 + "for( int " + c + "=0; " + c + "<" + string + ".length;" + c + "++)\n\t\t" + string5 + "{\n");
            stringBuffer.append("\t\t\t" + string5 + this.elementTypeSpec().printWriteStatement(string + "[" + c + "]", string2) + "\n");
            stringBuffer.append("\t\t" + string5 + "}\n");
        }
        return stringBuffer.toString();
    }

    public String elementTypeName() {
        if (this.type_spec.typeSpec() instanceof ScopedName) {
            return ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec().typeName();
        }
        return this.type_spec.typeName();
    }

    public String holderName() {
        if (!this.typedefd) {
            throw new RuntimeException("Compiler Error: should not be called (helpername on not typedef'd SequenceType " + this.name + ")");
        }
        String string = this.full_name();
        if (this.pack_name.length() > 0 && !string.startsWith("org.omg")) {
            string = this.omg_package_prefix + string;
        }
        return string + "Holder";
    }

    public String helperName() {
        if (!this.typedefd) {
            throw new RuntimeException("Compiler Error: should not be called (helperName() on not typedef'd SequenceType)");
        }
        String string = this.full_name();
        if (this.pack_name.length() > 0 && !string.startsWith("org.omg")) {
            string = this.omg_package_prefix + string;
        }
        return string + "Helper";
    }

    public String className() {
        String string;
        String string2 = this.full_name();
        if (string2.indexOf(46) > 0) {
            this.pack_name = string2.substring(0, string2.lastIndexOf(46));
            string = string2.substring(string2.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            string = string2;
        }
        return string;
    }

    public void parse() {
        TypeSpec typeSpec;
        if (this.max != null) {
            this.max.parse();
            this.length = Integer.parseInt(this.max.value());
        }
        if (this.type_spec.typeSpec() instanceof ScopedName && (typeSpec = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec()) != null) {
            this.type_spec = typeSpec;
        }
        try {
            NameTable.define(this.full_name(), "type");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            // empty catch block
        }
    }

    public String full_name() {
        if (this.name == null) {
            return "<" + this.pack_name + ".anon>";
        }
        if (this.pack_name.length() > 0) {
            return ScopedName.unPseudoName(this.pack_name + "." + this.name);
        }
        return ScopedName.unPseudoName(this.name);
    }

    public String toString() {
        String string = this.type_spec.typeSpec() instanceof ScopedName ? ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec().toString() : this.type_spec.toString();
        return string + "[]";
    }

    private void printClassComment(String string, PrintWriter printWriter) {
        printWriter.println("/**");
        printWriter.println(" *\tGenerated from IDL definition of sequence\"" + string + "\"");
        printWriter.println(" *\t@author JacORB IDL compiler ");
        printWriter.println(" */\n");
    }

    private void printHolderClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        String string2 = this.typeName();
        this.printClassComment(string, printWriter);
        printWriter.println("public class " + string + "Holder");
        printWriter.println("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\tpublic " + string2 + " value;");
        printWriter.println("\tpublic " + string + "Holder()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder(" + string2 + " initial)\n\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + string + "Helper.type();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _read(org.omg.CORBA.portable.InputStream _in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + string + "Helper.read(_in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(org.omg.CORBA.portable.OutputStream _out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + string + "Helper.write(_out,value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        String string2;
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        String string3 = this.typeName();
        this.printClassComment(string, printWriter);
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        printWriter.println("\tpublic " + string + "Helper ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        TypeSpec.printHelperClassMethods(string, printWriter, string3);
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + string3 + " read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\tint l = in.read_long();");
        if (this.length != 0) {
            printWriter.println("\t\tif( l > " + this.length + ")");
            printWriter.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
        }
        printWriter.println("\t\t" + string3 + " result = new " + string3.substring(0, string3.indexOf("[")) + "[l]" + string3.substring(string3.indexOf("]") + 1) + ";");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            string2 = this.elementTypeSpec().printReadExpression("in");
            printWriter.println("\t\t" + string2.substring(0, string2.indexOf("(")) + "_array(result,0,result.length);");
        } else {
            printWriter.println("\t\tfor( int i = 0; i < l; i++ )");
            printWriter.println("\t\t{");
            printWriter.println("\t\t\t" + this.elementTypeSpec().printReadStatement("result[i]", "in"));
            printWriter.println("\t\t}");
        }
        printWriter.println("\t\treturn result;");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream out, " + string3 + " s)");
        printWriter.println("\t{");
        if (this.length != 0) {
            printWriter.println("\t\tif( s.length > " + this.length + ")");
            printWriter.println("\t\t\tthrow new org.omg.CORBA.MARSHAL();");
        }
        printWriter.println("\t\tout.write_long(s.length);");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            string2 = this.elementTypeSpec().printWriteStatement("s", "out");
            printWriter.println(string2.substring(0, string2.indexOf("(")) + "_array(s,0,s.length);");
        } else {
            printWriter.println("\t\tfor( int i = 0; i < s.length; i++ )");
            printWriter.println("\t\t\t" + this.elementTypeSpec().printWriteStatement("s[i]", "out"));
        }
        printWriter.println("\t}");
        printWriter.println("}");
    }

    public void print(PrintWriter printWriter) {
        try {
            if (!this.written && this.typedefd) {
                String string;
                String string2 = this.full_name();
                if (string2.indexOf(46) > 0) {
                    this.pack_name = string2.substring(0, string2.lastIndexOf(46));
                    string = string2.substring(string2.lastIndexOf(46) + 1);
                } else {
                    this.pack_name = "";
                    string = string2;
                }
                String string3 = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
                File file = new File(string3);
                if (!file.exists() && !file.mkdirs()) {
                    parser.fatal_error("Unable to create " + string3, null);
                }
                String string4 = string + "Holder.java";
                PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string4)));
                this.printHolderClass(string, printWriter2);
                printWriter2.close();
                string4 = string + "Helper.java";
                printWriter2 = new PrintWriter(new FileWriter(new File(file, string4)));
                this.printHelperClass(string, printWriter2);
                printWriter2.close();
                this.written = true;
            }
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }
}

