/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.typemgr;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.client.typemgr.Parser;
import org.jacorb.trading.client.typemgr.ParserException;
import org.jacorb.trading.client.util.Constrain;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.DuplicateServiceTypeName;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.InterfaceTypeMismatch;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ServiceTypeExists;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ValueTypeRedefinition;

public class AddTypeDialog
extends Dialog
implements ActionListener {
    private TextArea m_description;
    private Button m_ok;
    private Button m_clear;
    private Button m_cancel;
    private Label m_status;
    private ServiceTypeRepository m_repos;
    private Vector m_listeners = new Vector();
    private String m_actionCommand;

    public AddTypeDialog(Frame frame, ServiceTypeRepository serviceTypeRepository) {
        super(frame, "Add Service Type", false);
        this.m_repos = serviceTypeRepository;
        this.createContents();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddTypeDialog.this.cancel();
            }
        });
        Point point = this.getParent().getLocation();
        ((Component)this).setLocation(point.x + 30, point.y + 30);
        this.m_description.setText("service YourService : BaseService {\n  interface YourInterface;\n  mandatory readonly property sequence<string> myprop;\n};\n");
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Constrain.constrain(panel, new Label("Description", 0), 0, 0, 3, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_description = new TextArea(10, 50);
        this.m_description.setEditable(true);
        Constrain.constrain(panel, this.m_description, 0, 1, 3, 1, 1, 18, 1.0, 1.0, 0, 10, 0, 10);
        this.m_ok = new Button("OK");
        this.m_ok.setActionCommand("ok");
        this.m_ok.addActionListener(this);
        Constrain.constrain(panel, this.m_ok, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0, 30, 3);
        this.m_clear = new Button("Clear");
        this.m_clear.setActionCommand("clear");
        this.m_clear.addActionListener(this);
        Constrain.constrain(panel, this.m_clear, 1, 2, 1, 1, 0, 10, 0.0, 0.0, 10, 0, 0, 0, 20, 3);
        this.m_cancel = new Button("Cancel");
        this.m_cancel.setActionCommand("cancel");
        this.m_cancel.addActionListener(this);
        Constrain.constrain(panel, this.m_cancel, 2, 2, 1, 1, 0, 12, 0.0, 0.0, 10, 0, 0, 10, 10, 3);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 3, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 5, 10);
        this.add(panel);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_listeners.removeElement(actionListener);
    }

    public void setActionCommand(String string) {
        this.m_actionCommand = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok")) {
            this.ok();
        } else if (actionEvent.getActionCommand().equals("clear")) {
            this.m_description.setText("");
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            this.cancel();
        }
    }

    protected void ok() {
        try {
            String string = this.m_description.getText();
            StringReader stringReader = new StringReader(string);
            Parser parser = new Parser();
            parser.parse(stringReader);
            this.m_repos.add_type(parser.getName(), parser.getInterface(), parser.getProperties(), parser.getSuperTypes());
            ((Component)this).setVisible(false);
            this.notifyListeners();
        }
        catch (ParserException parserException) {
            this.showStatus("Line " + parserException.getLine() + ": " + parserException.getMessage());
        }
        catch (IllegalServiceType illegalServiceType) {
            this.showStatus("Illegal service type '" + illegalServiceType.type + "'");
        }
        catch (UnknownServiceType unknownServiceType) {
            this.showStatus("Unknown service type '" + unknownServiceType.type + "'");
        }
        catch (IllegalPropertyName illegalPropertyName) {
            this.showStatus("Illegal property name '" + illegalPropertyName.name + "'");
        }
        catch (DuplicatePropertyName duplicatePropertyName) {
            this.showStatus("Duplicate property name '" + duplicatePropertyName.name + "'");
        }
        catch (ServiceTypeExists serviceTypeExists) {
            this.showStatus("Service type '" + serviceTypeExists.name + "' already exists");
        }
        catch (DuplicateServiceTypeName duplicateServiceTypeName) {
            this.showStatus("Duplicate super type '" + duplicateServiceTypeName.name + "'");
        }
        catch (InterfaceTypeMismatch interfaceTypeMismatch) {
            this.showStatus("Interface type mismatch between " + interfaceTypeMismatch.derived_service + " and " + interfaceTypeMismatch.base_service);
        }
        catch (ValueTypeRedefinition valueTypeRedefinition) {
            this.showStatus("Value type redefinition in " + valueTypeRedefinition.type_1 + " for property '" + valueTypeRedefinition.definition_1.name + "'");
        }
    }

    protected void cancel() {
        ((Component)this).setVisible(false);
    }

    protected void notifyListeners() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.m_actionCommand);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    protected void showStatus(String string) {
        this.m_status.setText(string);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }
}

