/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import org.jacorb.orb.ORB;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagersListHelper;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;

public class ServantDelegate
implements Delegate {
    private transient org.omg.CORBA.ORB orb = null;
    private transient Repository ir = null;
    private transient Current _current = null;
    private transient POA poa = null;
    private transient POA selfPOA = null;
    private static Domain _domainService = null;

    ServantDelegate(ORB oRB) {
        this.orb = oRB;
    }

    public void setPOA(POA pOA) {
        if (this.selfPOA != null) {
            throw new BAD_INV_ORDER("The Servant has already been associated with a POA");
        }
        this.selfPOA = pOA;
    }

    private final void check() {
        if (this.orb == null) {
            throw new BAD_INV_ORDER("The Servant has not been associated with an ORB instance");
        }
    }

    public final Object this_object(Servant servant) {
        this.check();
        try {
            this.poa = this.poa(servant);
        }
        catch (OBJ_ADAPTER oBJ_ADAPTER) {
            this.poa = this.default_POA(servant);
        }
        if (this.poa == null) {
            throw new OBJ_ADAPTER("null value returned by  _default_POA() on Servant " + servant);
        }
        try {
            return this.poa.servant_to_reference(servant);
        }
        catch (ServantNotActive servantNotActive) {
            throw new OBJ_ADAPTER(servantNotActive.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            throw new OBJ_ADAPTER(wrongPolicy.toString());
        }
    }

    public final org.omg.CORBA.ORB orb(Servant servant) {
        this.check();
        return this.orb;
    }

    public final POA poa(Servant servant) {
        this.check();
        if (this._current == null) {
            this._getPOACurrent();
        }
        try {
            return this._current.get_POA();
        }
        catch (NoContext noContext) {
            throw new OBJ_ADAPTER(noContext.toString());
        }
    }

    public final byte[] object_id(Servant servant) {
        this.check();
        if (this._current == null) {
            this._getPOACurrent();
        }
        try {
            return this._current.get_object_id();
        }
        catch (NoContext noContext) {
            throw new OBJ_ADAPTER(noContext.toString());
        }
    }

    private synchronized void _getPOACurrent() {
        if (this._current == null) {
            try {
                this._current = CurrentHelper.narrow(this.orb.resolve_initial_references("POACurrent"));
            }
            catch (Exception exception) {
                throw new INITIALIZE(exception.toString());
            }
        }
    }

    public POA default_POA(Servant servant) {
        this.check();
        try {
            if (this.selfPOA != null) {
                return this.selfPOA;
            }
            return POAHelper.narrow(this.orb(servant).resolve_initial_references("RootPOA"));
        }
        catch (InvalidName invalidName) {
            throw new INITIALIZE(invalidName.toString());
        }
    }

    public boolean non_existent(Servant servant) {
        this.check();
        Debug.output(2, "ServantDelegate: non_existent: return false");
        return false;
    }

    public InterfaceDef get_interface(Servant servant) {
        this.check();
        if (this.ir == null) {
            try {
                this.ir = RepositoryHelper.narrow(this.orb.resolve_initial_references("InterfaceRepository"));
            }
            catch (Exception exception) {
                throw new INITIALIZE(exception.toString());
            }
        }
        return InterfaceDefHelper.narrow(this.ir.lookup_id(((ObjectImpl)servant._this_object())._ids()[0]));
    }

    public boolean is_a(Servant servant, String string) {
        Debug.output(3, "ServantDelegate: is a " + string + " ?");
        String[] stringArray = servant._all_interfaces(null, null);
        int n = 0;
        while (n < stringArray.length) {
            Debug.output(3, "ServantDelegate: is a compares with " + stringArray[n]);
            if (stringArray[n].equals(string)) {
                Debug.output(3, "ServantDelegate: ! is a " + stringArray[n] + "!");
                return true;
            }
            ++n;
        }
        return string.equals("IDL:omg.org/CORBA/Object:1.0");
    }

    private Domain _domainService() {
        if (_domainService == null) {
            try {
                Debug.output(32771, "ServantDelegate._domainService: fetching local domain service reference from orb");
                this.check();
                _domainService = DomainHelper.narrow(this.orb.resolve_initial_references("LocalDomainService"));
            }
            catch (Exception exception) {
                Debug.output(32769, exception);
            }
        }
        return _domainService;
    }

    public Policy _get_policy(Object object, int n) {
        return this._domainService().getPolicy(object, n);
    }

    public DomainManager[] _get_domain_managers(Object object) {
        return this._domainService().getDomains(object);
    }

    public OutputStream _invoke(Servant servant, String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        if (string.equals("_get_domain_managers")) {
            outputStream = responseHandler.createReply();
            DomainManagersListHelper.write(outputStream, this._get_domain_managers(inputStream.read_Object()));
        } else if (string.equals("_get_policy")) {
            outputStream = responseHandler.createReply();
            outputStream.write_Object(this._get_policy(inputStream.read_Object(), inputStream.read_long()));
        } else if (string.equals("_is_a")) {
            outputStream = responseHandler.createReply();
            outputStream.write_boolean(servant._is_a(inputStream.read_string()));
        } else if (string.equals("_interface")) {
            outputStream = responseHandler.createReply();
            outputStream.write_Object(servant._get_interface());
        } else if (string.equals("_non_existent")) {
            outputStream = responseHandler.createReply();
            outputStream.write_boolean(servant._non_existent());
        } else {
            throw new Error("Unknown operation: " + string);
        }
        return outputStream;
    }
}

