/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Stack;
import org.jacorb.orb.Any;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.util.Debug;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.portable.InputStream;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;

public class CDRInputStream
extends InputStream {
    int read_index;
    private Stack encaps_stack = new Stack();
    private Hashtable TCTable = new Hashtable();
    private int marked_pos;
    private int marked_index;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    private int minorGIOPVersion = 1;
    private boolean closed = false;
    public boolean littleEndian = false;
    protected byte[] buffer = null;
    protected int pos = 0;
    protected int index = 0;
    public org.omg.CORBA.ORB orb = null;

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray) {
        this.orb = oRB;
        this.buffer = byArray;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, byte[] byArray, boolean bl) {
        this(oRB, byArray);
        this.littleEndian = bl;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        this.encaps_stack.removeAllElements();
        BufferManager.getInstance().returnBuffer(this.buffer);
        this.closed = true;
    }

    public void setCodeSet(int n, int n2) {
        this.codeSet = n;
        this.codeSetW = n2;
    }

    private static final int _read4int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return ((byArray[n + 3] & 0xFF) << 24) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0);
        }
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
    }

    private static final short _read2int(boolean bl, byte[] byArray, int n) {
        if (bl) {
            return (short)(((byArray[n + 1] & 0xFF) << 8) + ((byArray[n] & 0xFF) << 0));
        }
        return (short)(((byArray[n] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 0));
    }

    protected final void skip(int n) {
        this.pos += n;
        this.index += n;
    }

    public final void closeEncapsulation() {
        EncapsInfo encapsInfo = (EncapsInfo)this.encaps_stack.pop();
        this.littleEndian = encapsInfo.littleEndian;
        int n = encapsInfo.start;
        int n2 = encapsInfo.size;
        if (this.pos < n + n2) {
            this.pos = n + n2;
        }
        this.index = encapsInfo.index + n2;
        Debug.output(8, "Closing Encapsulation at pos: " + this.pos + " littleEndian now: " + this.littleEndian + ",  index now " + this.index);
    }

    public final void openEncapsulation() {
        boolean bl = this.littleEndian;
        int n = this.pos;
        int n2 = this.read_long();
        this.encaps_stack.push(new EncapsInfo(bl, this.index, this.pos, n2));
        Debug.output(8, "Opening Encapsulation at pos: " + n + " size: " + n2);
        this.openEncapsulatedArray();
    }

    public final void openEncapsulatedArray() {
        this.resetIndex();
        this.littleEndian = this.read_boolean();
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        if (this.available() < 1) {
            return -1;
        }
        return this.buffer[this.read_index++];
    }

    public int available() {
        return this.pos - this.read_index;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.available() < 1) {
            return -1;
        }
        if (this.closed) {
            throw new IOException("Stream already closed!");
        }
        int n3 = n2 < this.available() ? n2 : this.available();
        System.arraycopy(this.buffer, 0, byArray, n, n3);
        return n3;
    }

    public final org.omg.CORBA.Any read_any() {
        org.omg.CORBA.TypeCode typeCode = this.read_TypeCode();
        org.omg.CORBA.Any any = this.orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public final boolean read_boolean() {
        byte by;
        ++this.index;
        if ((by = this.buffer[this.pos++]) == 1) {
            return true;
        }
        if (by == 0) {
            return false;
        }
        throw new Error("Unexpected boolean value: " + by + " pos: " + this.pos + " index: " + this.index);
    }

    public final void read_boolean_array(boolean[] blArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            blArray[n3] = this.read_boolean();
            ++n3;
        }
    }

    public final char read_char(int n) {
        switch (n) {
            case 0: 
            case 65537: {
                ++this.index;
                return (char)(0xFF & this.buffer[this.pos++]);
            }
            case 0x5010001: {
                short s = (short)(0xFF & this.buffer[this.pos++]);
                ++this.index;
                if ((s & 0x80) == 0) {
                    return (char)s;
                }
                if ((s & 0xE0) == 192) {
                    ++this.index;
                    return (char)((s & 0x1F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
                }
                this.index += 2;
                short s2 = (short)(0xFF & this.buffer[this.pos++]);
                return (char)((s & 0xF) << 12 | (s2 & 0x3F) << 6 | (short)this.buffer[this.pos++] & 0x3F);
            }
            case 65801: {
                this.index += 2;
                this.pos += 2;
                if (this.littleEndian) {
                    return (char)(this.buffer[this.pos - 1] << 8 | this.buffer[this.pos - 2] & 0xFF);
                }
                return (char)(this.buffer[this.pos - 2] << 8 | this.buffer[this.pos - 1] & 0xFF);
            }
        }
        throw new Error("Bad CodeSet: " + n);
    }

    public final char read_char() {
        return this.read_char(this.codeSet);
    }

    public final void read_char_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            cArray[n3] = this.read_char(this.codeSet);
            ++n3;
        }
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public final void read_double_array(double[] dArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            dArray[n3] = this.read_double();
            ++n3;
        }
    }

    public final BigDecimal read_fixed() {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.buffer[this.pos++];
        int n = by & 0xF;
        ++this.index;
        while (true) {
            n = (by & 0xF0) >>> 4;
            stringBuffer.append(n);
            n = by & 0xF;
            if (n == 12 || n == 13) break;
            stringBuffer.append(n);
            by = this.buffer[this.pos++];
            ++this.index;
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(stringBuffer.toString()));
        if (n == 13) {
            return bigDecimal.negate();
        }
        return bigDecimal;
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final void read_float_array(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            fArray[n3] = this.read_float();
            ++n3;
        }
    }

    public final int read_long() {
        int n = 4 - this.index % 4;
        if (n != 4) {
            this.index += n;
            this.pos += n;
        }
        int n2 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        return n2;
    }

    public final void read_long_array(int[] nArray, int n, int n2) {
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        int n4 = n;
        while (n4 < n + n2) {
            nArray[n4] = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
            this.pos += 4;
            ++n4;
        }
        this.index += 4 * n2;
    }

    public final long read_longlong() {
        int n = 8 - this.index % 8;
        if (n != 8) {
            this.index += n;
            this.pos += n;
        }
        if (this.littleEndian) {
            return ((long)this.read_long() & 0xFFFFFFFFL) + ((long)this.read_long() << 32);
        }
        return ((long)this.read_long() << 32) + ((long)this.read_long() & 0xFFFFFFFFL);
    }

    public final void read_longlong_array(long[] lArray, int n, int n2) {
        int n3 = 8 - this.index % 8;
        if (n3 != 8) {
            this.index += n3;
            this.pos += n3;
        }
        if (this.littleEndian) {
            int n4 = n;
            while (n4 < n + n2) {
                lArray[n4] = ((long)CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos) & 0xFFFFFFFFL) + ((long)CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos + 4) << 32);
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 < n + n2) {
                lArray[n5] = ((long)CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos) << 32) + ((long)CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos + 4) & 0xFFFFFFFFL);
                ++n5;
            }
        }
        this.pos += 8 * n2;
        this.index += 8 * n2;
    }

    public final Object read_Object() {
        IOR iOR = IORHelper.read(this);
        ParsedIOR parsedIOR = new ParsedIOR(iOR);
        if (parsedIOR.isNull()) {
            return null;
        }
        if (!(this.orb instanceof ORB)) {
            throw new RuntimeException("Can not use the singleton ORB to receive object references, please initialize a full ORB instead.");
        }
        return ((ORB)this.orb)._getObject(parsedIOR);
    }

    public final byte read_octet() {
        ++this.index;
        return this.buffer[this.pos++];
    }

    public final void read_octet_array(byte[] byArray, int n, int n2) {
        System.arraycopy(this.buffer, this.pos, byArray, n, n2);
        this.index += n2;
        this.pos += n2;
    }

    public final Principal read_Principal() {
        throw new NO_IMPLEMENT();
    }

    public final short read_short() {
        int n = 2 - this.index % 2;
        if (n != 2) {
            this.index += n;
            this.pos += n;
        }
        short s = CDRInputStream._read2int(this.littleEndian, this.buffer, this.pos);
        this.pos += 2;
        this.index += 2;
        return s;
    }

    public final void read_short_array(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            sArray[n3] = this.read_short();
            ++n3;
        }
    }

    public final String read_string() {
        return this.read_string(this.codeSet);
    }

    public final String read_string(int n) {
        int n2 = 4 - this.index % 4;
        if (n2 != 4) {
            this.index += n2;
            this.pos += n2;
        }
        int n3 = CDRInputStream._read4int(this.littleEndian, this.buffer, this.pos);
        this.index += 4;
        this.pos += 4;
        if (n3 <= 0) {
            return "";
        }
        char[] cArray = new char[n3];
        int n4 = this.pos + (n == 65801 && this.minorGIOPVersion < 2 ? n3 * 2 : n3);
        int n5 = 0;
        while (this.pos < n4) {
            cArray[n5] = this.read_char(n);
            ++n5;
        }
        if (cArray[n5 - 1] == '\u0000') {
            --n5;
        }
        return new String(cArray, 0, n5);
    }

    protected final void unread_string(String string) {
        int n = 4 + string.length() + 1;
        this.pos -= n;
        this.index -= n;
    }

    public final org.omg.CORBA.TypeCode read_TypeCode() {
        return this.read_TypeCode(new Hashtable());
    }

    public final org.omg.CORBA.TypeCode read_TypeCode(Hashtable hashtable) {
        int n = this.pos;
        int n2 = this.read_long();
        Debug.output(4, "Read Type code of kind " + n2 + " at pos: " + n);
        boolean bl = false;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: {
                return this.orb.get_primitive_tc(TCKind.from_int(n2));
            }
            case 14: {
                this.openEncapsulation();
                String string = this.read_string();
                String string2 = this.read_string();
                this.closeEncapsulation();
                return this.orb.create_interface_tc(string, string2);
            }
            case 15: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n), string);
                String string3 = this.read_string();
                int n3 = this.read_long();
                StructMember[] structMemberArray = new StructMember[n3];
                int n4 = 0;
                while (n4 < n3) {
                    structMemberArray[n4] = new StructMember(this.read_string(), this.read_TypeCode(hashtable), null);
                    ++n4;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.orb.create_struct_tc(string, string3, structMemberArray);
                return typeCode;
            }
            case 22: {
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n), string);
                String string4 = this.read_string();
                int n5 = this.read_long();
                StructMember[] structMemberArray = new StructMember[n5];
                int n6 = 0;
                while (n6 < n5) {
                    structMemberArray[n6] = new StructMember(this.read_string(), this.read_TypeCode(), null);
                    ++n6;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.orb.create_struct_tc(string, string4, structMemberArray);
                return typeCode;
            }
            case 17: {
                this.openEncapsulation();
                String string = this.read_string();
                String string5 = this.read_string();
                int n7 = this.read_long();
                String[] stringArray = new String[n7];
                int n8 = 0;
                while (n8 < n7) {
                    stringArray[n8] = this.read_string();
                    ++n8;
                }
                this.closeEncapsulation();
                return this.orb.create_enum_tc(string, string5, stringArray);
            }
            case 16: {
                Debug.output(4, "TC Union at pos" + this.pos, this.buffer, this.pos, this.buffer.length);
                this.openEncapsulation();
                String string = this.read_string();
                hashtable.put(new Integer(n), string);
                String string6 = this.read_string();
                Debug.output(4, "TC Union has name " + string6 + " at pos" + this.pos);
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                int n9 = this.read_long();
                Debug.output(4, "TC Union has default idx: " + n9 + "  (at pos " + this.pos);
                int n10 = this.read_long();
                Debug.output(4, "TC Union has " + n10 + " members at pos " + this.pos);
                UnionMember[] unionMemberArray = new UnionMember[n10];
                int n11 = 0;
                while (n11 < n10) {
                    Debug.output(4, "Member " + n11 + "in  union " + string + " , " + string6 + ", start reading TC at pos " + this.pos);
                    org.omg.CORBA.Any any = this.orb.create_any();
                    if (n11 == n9) {
                        any.insert_octet(this.read_octet());
                    } else {
                        any.read_value(this, typeCode);
                        Debug.output(4, "non-default discr.: " + ((Any)any).type().kind().value() + " " + ((Any)any).value());
                    }
                    Debug.output(4, "Member " + n11 + "  start to read name at pos " + this.pos);
                    String string7 = this.read_string();
                    Debug.output(4, "Member " + n11 + " , read name at pos " + this.pos + " : " + string7);
                    unionMemberArray[n11] = new UnionMember(string7, any, this.read_TypeCode(hashtable), null);
                    Debug.output(4, "Member " + n11 + " created ");
                    ++n11;
                }
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode2 = this.orb.create_union_tc(string, string6, typeCode, unionMemberArray);
                Debug.output(4, "Done with union " + string + " at pos " + this.pos);
                return typeCode2;
            }
            case 18: {
                return this.orb.create_string_tc(this.read_long());
            }
            case 27: {
                return this.orb.create_wstring_tc(this.read_long());
            }
            case 28: {
                return this.orb.create_fixed_tc(this.read_ushort(), this.read_short());
            }
            case 20: {
                this.openEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                int n12 = this.read_long();
                this.closeEncapsulation();
                return this.orb.create_array_tc(n12, typeCode);
            }
            case 19: {
                this.openEncapsulation();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                int n13 = this.read_long();
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode3 = this.orb.create_sequence_tc(0, typeCode);
                return typeCode3;
            }
            case 21: {
                this.openEncapsulation();
                String string = this.read_string();
                String string8 = this.read_string();
                org.omg.CORBA.TypeCode typeCode = this.read_TypeCode(hashtable);
                this.closeEncapsulation();
                org.omg.CORBA.TypeCode typeCode4 = this.orb.create_alias_tc(string, string8, typeCode);
                return typeCode4;
            }
            case -1: {
                int n14 = this.pos + this.read_long();
                String string = (String)hashtable.get(new Integer(n14));
                Debug.assert(string != null, "Could not resolve for recursive TypeCode!");
                org.omg.CORBA.TypeCode typeCode = this.orb.create_recursive_tc(string);
                return typeCode;
            }
        }
        Debug.output(2, "CDRInputStream Buffer Content", this.buffer);
        Debug.output(2, "Pos : " + this.pos);
        throw new MARSHAL("Cannot handle TypeCode with kind " + n2);
    }

    public final int read_ulong() {
        return this.read_long();
    }

    public final void read_ulong_array(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            nArray[n3] = this.read_ulong();
            ++n3;
        }
    }

    public final long read_ulonglong() {
        return this.read_longlong();
    }

    public final void read_ulonglong_array(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            lArray[n3] = this.read_ulonglong();
            ++n3;
        }
    }

    public final short read_ushort() {
        return this.read_short();
    }

    public final void read_ushort_array(short[] sArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            sArray[n3] = this.read_ushort();
            ++n3;
        }
    }

    public final char read_wchar() {
        return this.read_char(this.codeSetW);
    }

    public final void read_wchar_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            cArray[n3] = this.read_char(this.codeSetW);
            ++n3;
        }
    }

    public final String read_wstring() {
        return this.read_string(this.codeSetW);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.marked_pos = this.pos;
        this.marked_index = this.index;
    }

    public void reset() throws IOException {
        if (this.pos < 0) {
            throw new IOException("Mark has not been set!");
        }
        this.pos = this.marked_pos;
        this.index = this.marked_index;
    }

    private final void resetIndex() {
        this.index = 0;
    }

    public final void setLittleEndian(boolean bl) {
        this.littleEndian = bl;
    }

    final void read_value(org.omg.CORBA.TypeCode typeCode, CDROutputStream cDROutputStream) {
        int n = ((TypeCode)typeCode)._kind();
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 8: {
                cDROutputStream.write_boolean(this.read_boolean());
                break;
            }
            case 9: {
                cDROutputStream.write_char(this.read_char());
                break;
            }
            case 26: {
                cDROutputStream.write_wchar(this.read_wchar());
                break;
            }
            case 10: {
                cDROutputStream.write_octet(this.read_octet());
                break;
            }
            case 4: {
                cDROutputStream.write_ushort(this.read_ushort());
                break;
            }
            case 2: {
                cDROutputStream.write_short(this.read_short());
                break;
            }
            case 3: {
                cDROutputStream.write_long(this.read_long());
                break;
            }
            case 5: {
                cDROutputStream.write_ulong(this.read_ulong());
                break;
            }
            case 6: {
                cDROutputStream.write_float(this.read_float());
                break;
            }
            case 7: {
                cDROutputStream.write_double(this.read_double());
                break;
            }
            case 23: {
                cDROutputStream.write_longlong(this.read_longlong());
                break;
            }
            case 24: {
                cDROutputStream.write_ulonglong(this.read_ulonglong());
                break;
            }
            case 11: {
                cDROutputStream.write_any(this.read_any());
                break;
            }
            case 12: {
                cDROutputStream.write_TypeCode(this.read_TypeCode());
                break;
            }
            case 13: {
                cDROutputStream.write_Principal(this.read_Principal());
                break;
            }
            case 14: {
                cDROutputStream.write_Object(this.read_Object());
                break;
            }
            case 18: {
                cDROutputStream.write_string(this.read_string());
                break;
            }
            case 27: {
                cDROutputStream.write_wstring(this.read_wstring());
                break;
            }
            case 20: {
                try {
                    int n2 = typeCode.length();
                    int n3 = 0;
                    while (n3 < n2) {
                        this.read_value(typeCode.content_type(), cDROutputStream);
                        ++n3;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 19: {
                try {
                    int n4 = this.read_long();
                    cDROutputStream.write_long(n4);
                    int n5 = 0;
                    while (n5 < n4) {
                        this.read_value(typeCode.content_type(), cDROutputStream);
                        ++n5;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 22: {
                cDROutputStream.write_string(this.read_string());
            }
            case 15: {
                try {
                    int n6 = 0;
                    while (n6 < typeCode.member_count()) {
                        this.read_value(typeCode.member_type(n6), cDROutputStream);
                        ++n6;
                    }
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case 17: {
                cDROutputStream.write_long(this.read_long());
                break;
            }
            case 21: {
                try {
                    cDROutputStream.write_value(typeCode.content_type(), this);
                }
                catch (BadKind badKind) {}
                break;
            }
            case 16: {
                try {
                    org.omg.CORBA.TypeCode typeCode2 = typeCode.discriminator_type();
                    int n7 = typeCode.default_index();
                    Debug.output(4, "Union Default index " + n7);
                    int n8 = -1;
                    block34 : switch (typeCode2.kind().value()) {
                        case 2: {
                            short s = this.read_short();
                            cDROutputStream.write_short(s);
                            int n9 = 0;
                            while (n9 < typeCode.member_count()) {
                                if (n9 != n7 && s == typeCode.member_label(n9).extract_short()) {
                                    n8 = n9;
                                    break block34;
                                }
                                ++n9;
                            }
                            break;
                        }
                        case 3: {
                            int n10 = this.read_long();
                            cDROutputStream.write_long(n10);
                            int n11 = 0;
                            while (n11 < typeCode.member_count()) {
                                if (n11 != n7 && n10 == typeCode.member_label(n11).extract_long()) {
                                    n8 = n11;
                                    break block34;
                                }
                                ++n11;
                            }
                            break;
                        }
                        case 4: {
                            short s = this.read_ushort();
                            cDROutputStream.write_ushort(s);
                            int n12 = 0;
                            while (n12 < typeCode.member_count()) {
                                if (n12 != n7 && s == typeCode.member_label(n12).extract_ushort()) {
                                    n8 = n12;
                                    break block34;
                                }
                                ++n12;
                            }
                            break;
                        }
                        case 5: {
                            int n13 = this.read_ulong();
                            cDROutputStream.write_ulong(n13);
                            int n14 = 0;
                            while (n14 < typeCode.member_count()) {
                                if (n14 != n7 && n13 == typeCode.member_label(n14).extract_ulong()) {
                                    n8 = n14;
                                    break block34;
                                }
                                ++n14;
                            }
                            break;
                        }
                        case 23: {
                            long l = this.read_longlong();
                            cDROutputStream.write_longlong(l);
                            int n15 = 0;
                            while (n15 < typeCode.member_count()) {
                                if (n15 != n7 && l == typeCode.member_label(n15).extract_longlong()) {
                                    n8 = n15;
                                    break block34;
                                }
                                ++n15;
                            }
                            break;
                        }
                        case 24: {
                            long l = this.read_ulonglong();
                            cDROutputStream.write_ulonglong(l);
                            int n16 = 0;
                            while (n16 < typeCode.member_count()) {
                                if (n16 != n7 && l == typeCode.member_label(n16).extract_ulonglong()) {
                                    n8 = n16;
                                    break block34;
                                }
                                ++n16;
                            }
                            break;
                        }
                        case 9: {
                            char c = this.read_char();
                            cDROutputStream.write_char(c);
                            int n17 = 0;
                            while (n17 < typeCode.member_count()) {
                                if (n17 != n7 && c == typeCode.member_label(n17).extract_char()) {
                                    n8 = n17;
                                    break block34;
                                }
                                ++n17;
                            }
                            break;
                        }
                        case 17: {
                            int n18 = this.read_long();
                            Debug.output(10, "Input  switch: " + n18 + " at pos " + this.pos);
                            cDROutputStream.write_long(n18);
                            int n19 = 0;
                            while (n19 < typeCode.member_count()) {
                                if (n19 != n7) {
                                    int n20 = typeCode.member_label(n19).create_input_stream().read_long();
                                    Debug.output(10, "Input label: " + n20 + " switch: " + n18);
                                    if (n18 == n20) {
                                        n8 = n19;
                                        break block34;
                                    }
                                }
                                ++n19;
                            }
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unfinished implementation for unions in anys, sorry.");
                        }
                    }
                    if (n8 != -1) {
                        this.read_value(typeCode.member_type(n8), cDROutputStream);
                        break;
                    }
                    if (n7 == -1) {
                        Debug.output(4, " -- TC error ", this.buffer);
                        throw new RuntimeException("Error in Union, no member and no default!");
                    }
                    this.read_value(typeCode.member_type(n7), cDROutputStream);
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case -1: {
                cDROutputStream.write_long(this.read_long());
                break;
            }
            default: {
                throw new RuntimeException("Cannot handle TypeCode with kind " + n);
            }
        }
    }

    public int get_pos() {
        return this.pos;
    }
}

