/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.net.ProtocolException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cookie2
extends Cookie {
    protected int version;
    protected boolean discard;
    protected String comment;
    protected URI comment_url;
    protected int[] port_list;
    protected String port_list_str;
    protected boolean path_set;
    protected boolean port_set;
    protected boolean domain_set;

    public Cookie2(String string, String string2, String string3, int[] nArray, String string4, Date date, boolean bl, boolean bl2, String string5, URI uRI) {
        super(string, string2, string3, string4, date, bl2);
        this.discard = bl;
        this.port_list = nArray;
        this.comment = string5;
        this.comment_url = uRI;
        this.path_set = true;
        this.domain_set = true;
        if (nArray != null && nArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nArray[0]);
            int n = 1;
            while (n < nArray.length) {
                stringBuffer.append(',');
                stringBuffer.append(nArray[n]);
                ++n;
            }
            this.port_list_str = stringBuffer.toString();
            this.port_set = true;
        }
        this.version = 1;
    }

    protected Cookie2(RoRequest roRequest) {
        super(roRequest);
        int n = this.path.lastIndexOf(47);
        if (n != -1) {
            this.path = this.path.substring(0, n + 1);
        }
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.version = -1;
        this.discard = false;
        this.comment = null;
        this.comment_url = null;
        this.port_list = null;
        this.port_list_str = null;
        this.path_set = false;
        this.port_set = false;
        this.domain_set = false;
    }

    protected static Cookie[] parse(String string, RoRequest roRequest) throws ProtocolException {
        Vector vector;
        try {
            vector = Util.parseHeader(string);
        }
        catch (ParseException parseException) {
            throw new ProtocolException(parseException.getMessage());
        }
        Cookie[] cookieArray = new Cookie[vector.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < cookieArray.length) {
            block53: {
                Cookie2 cookie2;
                block54: {
                    String string2;
                    HttpHeaderElement httpHeaderElement = (HttpHeaderElement)vector.elementAt(n2);
                    if (httpHeaderElement.getValue() == null) {
                        throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nMissing value " + "for cookie '" + httpHeaderElement.getName() + "'");
                    }
                    cookie2 = new Cookie2(roRequest);
                    cookie2.name = httpHeaderElement.getName();
                    cookie2.value = httpHeaderElement.getValue();
                    NVPair[] nVPairArray = httpHeaderElement.getParams();
                    boolean bl = false;
                    boolean bl2 = false;
                    int n3 = 0;
                    while (n3 < nVPairArray.length) {
                        string2 = nVPairArray[n3].getName().toLowerCase();
                        if ((string2.equals("version") || string2.equals("max-age") || string2.equals("domain") || string2.equals("path") || string2.equals("comment") || string2.equals("commenturl")) && nVPairArray[n3].getValue() == null) {
                            throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nMissing value " + "for " + nVPairArray[n3].getName() + " attribute in cookie '" + httpHeaderElement.getName() + "'");
                        }
                        if (string2.equals("version")) {
                            if (cookie2.version == -1) {
                                try {
                                    cookie2.version = Integer.parseInt(nVPairArray[n3].getValue());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nVersion '" + nVPairArray[n3].getValue() + "' not a number");
                                }
                            }
                        } else if (string2.equals("path")) {
                            if (!cookie2.path_set) {
                                cookie2.path = nVPairArray[n3].getValue();
                                cookie2.path_set = true;
                            }
                        } else if (string2.equals("domain")) {
                            if (!cookie2.domain_set) {
                                String string3 = nVPairArray[n3].getValue().toLowerCase();
                                cookie2.domain = string3.charAt(0) != '.' && !string3.equals(cookie2.domain) ? "." + string3 : string3;
                                cookie2.domain_set = true;
                            }
                        } else if (string2.equals("max-age")) {
                            if (cookie2.expires == null) {
                                int n4;
                                try {
                                    n4 = Integer.parseInt(nVPairArray[n3].getValue());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nMax-Age '" + nVPairArray[n3].getValue() + "' not a number");
                                }
                                cookie2.expires = new Date(System.currentTimeMillis() + (long)n4 * 1000L);
                            }
                        } else if (string2.equals("port")) {
                            if (!cookie2.port_set) {
                                if (nVPairArray[n3].getValue() == null) {
                                    cookie2.port_list = new int[1];
                                    cookie2.port_list[0] = roRequest.getConnection().getPort();
                                    cookie2.port_set = true;
                                } else {
                                    cookie2.port_list_str = nVPairArray[n3].getValue();
                                    StringTokenizer stringTokenizer = new StringTokenizer(nVPairArray[n3].getValue(), ",");
                                    cookie2.port_list = new int[stringTokenizer.countTokens()];
                                    int n5 = 0;
                                    while (n5 < cookie2.port_list.length) {
                                        String string4 = stringTokenizer.nextToken().trim();
                                        try {
                                            cookie2.port_list[n5] = Integer.parseInt(string4);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nPort '" + string4 + "' not a number");
                                        }
                                        ++n5;
                                    }
                                    cookie2.port_set = true;
                                }
                            }
                        } else if (string2.equals("discard")) {
                            if (!bl) {
                                cookie2.discard = true;
                                bl = true;
                            }
                        } else if (string2.equals("secure")) {
                            if (!bl2) {
                                cookie2.secure = true;
                                bl2 = true;
                            }
                        } else if (string2.equals("comment")) {
                            if (cookie2.comment == null) {
                                cookie2.comment = nVPairArray[n3].getValue();
                            }
                        } else if (string2.equals("commenturl") && cookie2.comment_url == null) {
                            try {
                                cookie2.comment_url = new URI(nVPairArray[n3].getValue());
                            }
                            catch (ParseException parseException) {
                                throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nCommentURL '" + nVPairArray[n3].getValue() + "' not a valid URL");
                            }
                        }
                        ++n3;
                    }
                    if (cookie2.version == -1) {
                        throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nMissing Version " + "attribute");
                    }
                    if (cookie2.version != 1) break block53;
                    if (cookie2.expires == null) {
                        cookie2.discard = true;
                    }
                    if (!Util.getPath(roRequest.getRequestURI()).startsWith(cookie2.path)) break block53;
                    string2 = roRequest.getConnection().getHost();
                    if (string2.indexOf(46) == -1) {
                        string2 = string2 + ".local";
                    }
                    if (!cookie2.domain.equals(".local") && cookie2.domain.indexOf(46, 1) == -1 || !string2.endsWith(cookie2.domain) || string2.substring(0, string2.length() - cookie2.domain.length()).indexOf(46) != -1) break block53;
                    if (!cookie2.port_set) break block54;
                    int n6 = 0;
                    n6 = 0;
                    while (n6 < cookie2.port_list.length) {
                        if (cookie2.port_list[n6] == roRequest.getConnection().getPort()) break;
                        ++n6;
                    }
                    if (n6 == cookie2.port_list.length) break block53;
                }
                cookieArray[n++] = cookie2;
            }
            ++n2;
        }
        if (n < cookieArray.length) {
            cookieArray = Util.resizeArray(cookieArray, n);
        }
        return cookieArray;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public URI getCommentURL() {
        return this.comment_url;
    }

    public int[] getPorts() {
        return this.port_list;
    }

    public boolean discard() {
        return this.discard;
    }

    protected boolean sendWith(RoRequest roRequest) {
        String string;
        boolean bl;
        HTTPConnection hTTPConnection = roRequest.getConnection();
        boolean bl2 = bl = !this.port_set;
        if (this.port_set) {
            int n = 0;
            while (n < this.port_list.length) {
                if (this.port_list[n] == hTTPConnection.getPort()) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        if ((string = hTTPConnection.getHost()).indexOf(46) == -1) {
            string = string + ".local";
        }
        return (this.domain.charAt(0) == '.' && string.endsWith(this.domain) || this.domain.charAt(0) != '.' && string.equals(this.domain)) && bl && Util.getPath(roRequest.getRequestURI()).startsWith(this.path) && (!this.secure || hTTPConnection.getProtocol().equals("https") || hTTPConnection.getProtocol().equals("shttp"));
    }

    protected String toExternalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.version == 1) {
            stringBuffer.append(this.name);
            stringBuffer.append("=");
            stringBuffer.append(this.value);
            if (this.path_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Path=");
                stringBuffer.append(this.path);
            }
            if (this.domain_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Domain=");
                stringBuffer.append(this.domain);
            }
            if (this.port_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Port");
                if (this.port_list_str != null) {
                    stringBuffer.append("=\"");
                    stringBuffer.append(this.port_list_str);
                    stringBuffer.append('\"');
                }
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = this.name + "=" + this.value;
        if (this.version == 1) {
            string = string + "; Version=" + this.version;
            string = string + "; Path=" + this.path;
            string = string + "; Domain=" + this.domain;
            if (this.port_set) {
                string = string + "; Port=\"" + this.port_list[0];
                int n = 1;
                while (n < this.port_list.length) {
                    string = string + "," + this.port_list[n];
                    ++n;
                }
                string = string + "\"";
            }
            if (this.expires != null) {
                string = string + "; Max-Age=" + (this.expires.getTime() - new Date().getTime()) / 1000L;
            }
            if (this.discard) {
                string = string + "; Discard";
            }
            if (this.secure) {
                string = string + "; Secure";
            }
            if (this.comment != null) {
                string = string + "; Comment=\"" + this.comment + "\"";
            }
            if (this.comment_url != null) {
                string = string + "; CommentURL=\"" + this.comment_url + "\"";
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return string;
    }
}

