/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.query;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.jacorb.trading.client.util.AnyUtil;
import org.jacorb.trading.client.util.Constrain;
import org.jacorb.trading.client.util.QuickSort;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.LookupPackage.IllegalPolicyName;
import org.omg.CosTrading.LookupPackage.IllegalPreference;
import org.omg.CosTrading.LookupPackage.InvalidPolicyValue;
import org.omg.CosTrading.LookupPackage.PolicyTypeMismatch;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;

public class Query
extends Frame
implements ActionListener,
ItemListener,
Runnable {
    private Choice m_types;
    private TextField m_constraint;
    private TextField m_preference;
    private Checkbox m_exactType;
    private Checkbox m_useDynamic;
    private Checkbox m_useProxy;
    private Checkbox m_useProps;
    private TextField m_props;
    private Button m_query;
    private TextArea m_results;
    private Label m_status;
    private Lookup m_lookup;
    private ServiceTypeRepository m_repos;
    private static ORB s_orb;

    public Query(Lookup lookup) {
        super("Query");
        this.setFont(new Font("Helvetica", 0, 12));
        this.m_lookup = lookup;
        Object object = lookup.type_repos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(object);
        this.createContents();
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0, 0, 0));
        panel2.add(new Label("Service type", 0));
        this.m_types = new Choice();
        this.loadTypes(this.m_types);
        panel2.add(this.m_types);
        Constrain.constrain(panel, panel2, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 0, 10);
        Constrain.constrain(panel, new Label("Constraint", 0), 0, 1, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_constraint = new TextField(50);
        this.m_constraint.setEditable(true);
        Constrain.constrain(panel, this.m_constraint, 0, 2, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        Constrain.constrain(panel, new Label("Preference", 0), 0, 3, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_preference = new TextField(50);
        this.m_preference.setEditable(true);
        Constrain.constrain(panel, this.m_preference, 0, 4, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        this.m_useProps = new Checkbox("Desired properties", false);
        this.m_useProps.addItemListener(this);
        Constrain.constrain(panel, this.m_useProps, 0, 5, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_props = new TextField(40);
        this.m_props.setEditable(false);
        Constrain.constrain(panel, this.m_props, 0, 6, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridBagLayout());
        this.m_exactType = new Checkbox("Exact type", false);
        Constrain.constrain(panel3, this.m_exactType, 0, 0, 1, 1, 0, 17);
        this.m_useDynamic = new Checkbox("Dynamic properties", false);
        Constrain.constrain(panel3, this.m_useDynamic, 1, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 10, 0, 10);
        this.m_useProxy = new Checkbox("Proxy offers", false);
        Constrain.constrain(panel3, this.m_useProxy, 2, 0, 1, 1, 0, 13);
        Constrain.constrain(panel, panel3, 0, 7, 2, 1, 2, 17, 1.0, 0.0, 5, 10, 0, 10);
        this.m_query = new Button("Query");
        this.m_query.setActionCommand("query");
        this.m_query.addActionListener(this);
        Constrain.constrain(panel, this.m_query, 0, 8, 2, 1, 0, 10, 0.0, 0.0, 5, 10, 0, 10, 30, 3);
        Constrain.constrain(panel, new Label("Results", 0), 0, 9, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_results = new TextArea(10, 50);
        this.m_results.setEditable(false);
        Constrain.constrain(panel, this.m_results, 0, 10, 2, 1, 1, 18, 1.0, 1.0, 0, 10, 0, 10);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 11, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 3, 10);
        this.add(panel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("query")) {
            new Thread(this).start();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_props.setEditable(itemEvent.getStateChange() == 1);
    }

    public void run() {
        block21: {
            try {
                try {
                    int n;
                    String[] stringArray;
                    java.lang.Object object;
                    java.lang.Object object2;
                    this.showStatus("Performing query...");
                    this.m_query.setEnabled(false);
                    this.m_results.setText("");
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    String string = this.m_types.getSelectedItem();
                    String string2 = this.m_constraint.getText();
                    String string3 = this.m_preference.getText();
                    Policy[] policyArray = new Policy[3];
                    policyArray[0] = new Policy();
                    policyArray[0].name = "exact_type_match";
                    policyArray[0].value = s_orb.create_any();
                    policyArray[0].value.insert_boolean(this.m_exactType.getState());
                    policyArray[1] = new Policy();
                    policyArray[1].name = "use_dynamic_properties";
                    policyArray[1].value = s_orb.create_any();
                    policyArray[1].value.insert_boolean(this.m_useDynamic.getState());
                    policyArray[2] = new Policy();
                    policyArray[2].name = "use_proxy_offers";
                    policyArray[2].value = s_orb.create_any();
                    policyArray[2].value.insert_boolean(this.m_useProxy.getState());
                    SpecifiedProps specifiedProps = new SpecifiedProps();
                    if (!this.m_useProps.getState()) {
                        specifiedProps.all_dummy((short)0);
                    } else {
                        object2 = this.m_props.getText().trim();
                        if (((String)object2).length() == 0) {
                            specifiedProps.none_dummy((short)0);
                        } else {
                            object = new StringTokenizer((String)object2, ",");
                            stringArray = new String[((StringTokenizer)object).countTokens()];
                            n = 0;
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                stringArray[n++] = ((StringTokenizer)object).nextToken().trim();
                            }
                            specifiedProps.prop_names(stringArray);
                        }
                    }
                    object2 = new OfferSeqHolder();
                    object = new OfferIteratorHolder();
                    stringArray = new PolicyNameSeqHolder();
                    this.m_lookup.query(string, string2, string3, policyArray, specifiedProps, 20, (OfferSeqHolder)object2, (OfferIteratorHolder)object, (PolicyNameSeqHolder)stringArray);
                    n = ((OfferSeqHolder)object2).value.length;
                    this.showStatus("Received " + n + " offers...");
                    this.describeOffers(printWriter, ((OfferSeqHolder)object2).value);
                    if (((OfferIteratorHolder)object).value != null) {
                        boolean bl;
                        OfferSeqHolder offerSeqHolder = new OfferSeqHolder();
                        do {
                            bl = ((OfferIteratorHolder)object).value.next_n(20, offerSeqHolder);
                            this.showStatus("Received " + (n += offerSeqHolder.value.length) + " offers...");
                            this.describeOffers(printWriter, offerSeqHolder.value);
                        } while (bl);
                        ((OfferIteratorHolder)object).value.destroy();
                    }
                    printWriter.flush();
                    this.m_results.setText(stringWriter.toString());
                }
                catch (IllegalServiceType illegalServiceType) {
                    this.showStatus("Illegal service type '" + illegalServiceType.type + "'");
                    java.lang.Object var15_26 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (UnknownServiceType unknownServiceType) {
                    this.showStatus("Unknown service type '" + unknownServiceType.type + "'");
                    java.lang.Object var15_27 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (IllegalConstraint illegalConstraint) {
                    this.showStatus("Illegal constraint");
                    java.lang.Object var15_28 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (IllegalPreference illegalPreference) {
                    this.showStatus("Illegal preference");
                    java.lang.Object var15_29 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (IllegalPolicyName illegalPolicyName) {
                    this.showStatus("Illegal policy '" + illegalPolicyName.name + "'");
                    java.lang.Object var15_30 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (PolicyTypeMismatch policyTypeMismatch) {
                    this.showStatus("Policy type mismatch for '" + policyTypeMismatch.the_policy.name + "'");
                    java.lang.Object var15_31 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (InvalidPolicyValue invalidPolicyValue) {
                    this.showStatus("Invalid policy value for '" + invalidPolicyValue.the_policy.name + "'");
                    java.lang.Object var15_32 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (IllegalPropertyName illegalPropertyName) {
                    this.showStatus("Illegal property name '" + illegalPropertyName.name + "'");
                    java.lang.Object var15_33 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (DuplicatePropertyName duplicatePropertyName) {
                    this.showStatus("Duplicate property name '" + duplicatePropertyName.name + "'");
                    java.lang.Object var15_34 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (DuplicatePolicyName duplicatePolicyName) {
                    this.showStatus("Duplicate policy name '" + duplicatePolicyName.name + "'");
                    java.lang.Object var15_35 = null;
                    this.m_query.setEnabled(true);
                    break block21;
                }
                catch (SystemException systemException) {
                    this.showStatus("System error occurred");
                    java.lang.Object var15_36 = null;
                    this.m_query.setEnabled(true);
                }
                java.lang.Object var15_25 = null;
                this.m_query.setEnabled(true);
            }
            catch (Throwable throwable) {
                java.lang.Object var15_37 = null;
                this.m_query.setEnabled(true);
                throw throwable;
            }
        }
    }

    protected void describeOffers(PrintWriter printWriter, Offer[] offerArray) {
        int n = 0;
        while (n < offerArray.length) {
            printWriter.println("Offer:");
            printWriter.println();
            int n2 = 0;
            while (n2 < offerArray[n].properties.length) {
                printWriter.print("  " + offerArray[n].properties[n2].name + " = ");
                AnyUtil.print(s_orb, printWriter, offerArray[n].properties[n2].value);
                printWriter.println();
                ++n2;
            }
            printWriter.println();
            printWriter.println("  Reference:");
            String string = s_orb.object_to_string(offerArray[n].reference);
            printWriter.println("    " + string);
            printWriter.println();
            ++n;
        }
    }

    protected void loadTypes(Choice choice) {
        choice.removeAll();
        SpecifiedServiceTypes specifiedServiceTypes = new SpecifiedServiceTypes();
        specifiedServiceTypes.__default();
        String[] stringArray = this.m_repos.list_types(specifiedServiceTypes);
        QuickSort.sort(stringArray);
        int n = 0;
        while (n < stringArray.length) {
            choice.add(stringArray[n]);
            ++n;
        }
    }

    protected void showStatus(String string) {
        this.m_status.setText(string);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected static void usage() {
        System.out.println("Usage: Query iorfile");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        java.lang.Object object;
        s_orb = ORB.init(stringArray, null);
        Lookup lookup = null;
        try {
            object = s_orb.resolve_initial_references("TradingService");
            if (object == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            lookup = LookupHelper.narrow((Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        object = new Query(lookup);
        ((Window)object).addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
                System.exit(0);
            }
        });
        ((Window)object).pack();
        ((Component)object).setVisible(true);
    }
}

