/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.proxy;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.Forwarder;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.connection.ClientConnection;
import org.jacorb.orb.connection.ReplyInputStream;
import org.jacorb.orb.connection.RequestOutputStream;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.proxy.ForwarderPOA;
import org.jacorb.proxy.ForwarderPOATie;
import org.jacorb.proxy.MiniStub;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;

class ForwarderImpl
extends ForwarderPOA {
    private static int counter = 0;
    private Hashtable forwardMap = new Hashtable();
    private Hashtable iorMap = new Hashtable();
    private Hashtable iorRefCnt = new Hashtable();
    private ORB orb;
    private POA rootPOA;
    private POA forwarderPOA;

    public ForwarderImpl(org.omg.CORBA.ORB oRB) {
        this.orb = (ORB)oRB;
        try {
            this.rootPOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            POAManager pOAManager = this.rootPOA.the_POAManager();
            Policy[] policyArray = new Policy[]{this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN)};
            this.forwarderPOA = this.rootPOA.create_POA("FORWARDER_POA", pOAManager, policyArray);
            int n = 0;
            while (n < policyArray.length) {
                policyArray[n].destroy();
                ++n;
            }
            this.forwarderPOA.set_servant(new ProxyEntry(oRB));
            pOAManager.activate();
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public String forward(String string, StringHolder stringHolder) {
        Debug.output(2, "Forwading for IOR: " + string);
        Object object = null;
        ParsedIOR parsedIOR = new ParsedIOR(string);
        String string2 = null;
        try {
            object = (Object)this.iorMap.get(string);
            if (object == null) {
                Debug.output(3, "Creating new proxy object");
                this.forwarderPOA = this.rootPOA.find_POA("FORWARDER_POA", false);
                object = this.forwarderPOA.create_reference(parsedIOR.getIOR().type_id);
                string2 = new String(this.forwarderPOA.reference_to_id(object));
                Delegate delegate = (Delegate)((ObjectImpl)object)._get_delegate();
                ClientConnection clientConnection = this.orb.getConnectionManager()._getConnection(parsedIOR.getAddress(), false);
                MiniStub miniStub = new MiniStub(clientConnection, parsedIOR);
                this.forwardMap.put(string2, miniStub);
                this.iorMap.put(string, object);
                this.iorRefCnt.put(string, new Integer(1));
            } else {
                Debug.output(3, "Proxyobject taken from cache");
                Integer n = (Integer)this.iorRefCnt.get(string);
                int n2 = n;
                this.iorRefCnt.put(string, new Integer(++n2));
                string2 = new String(this.forwarderPOA.reference_to_id(object));
            }
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
        stringHolder.value = string2;
        return this.orb.object_to_string(object);
    }

    public synchronized void release(String string) {
        Debug.output(3, "Release starts...");
        try {
            MiniStub miniStub = (MiniStub)this.forwardMap.get(string);
            String string2 = miniStub.getParsedIOR().getIORString();
            Integer n = (Integer)this.iorRefCnt.get(string2);
            int n2 = n;
            if (n2 == 1) {
                this.iorMap.remove(string2);
                this.forwardMap.remove(string);
                ClientConnection clientConnection = miniStub.getConnection();
                clientConnection.releaseConnection();
                this.iorRefCnt.remove(string2);
            } else {
                this.iorRefCnt.put(string2, new Integer(--n2));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Debug.output(3, "Release ends");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            Debug.output(0, "usage: appligator <port> <IOR-File>");
            System.exit(1);
        }
        try {
            Properties properties = new Properties();
            ((Hashtable)properties).put("OAPort", stringArray[0]);
            org.omg.CORBA.ORB oRB = org.omg.CORBA.ORB.init(stringArray, properties);
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            ForwarderPOATie forwarderPOATie = new ForwarderPOATie(new ForwarderImpl(oRB));
            Object object = pOA.servant_to_reference(forwarderPOATie);
            FileWriter fileWriter = new FileWriter(stringArray[1]);
            fileWriter.write(oRB.object_to_string(object));
            fileWriter.close();
            NamingContextExt namingContextExt = null;
            try {
                namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
            }
            catch (BAD_PARAM bAD_PARAM) {
                Debug.output(2, bAD_PARAM);
            }
            if (namingContextExt == null) {
                Debug.output(1, "Nameserver not present. Trying without");
            } else {
                namingContextExt.bind(namingContextExt.to_name("proxyserver"), object);
            }
            oRB.run();
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
        catch (IOException iOException) {
            Debug.output(1, "Could not write IOR File:" + iOException.toString());
        }
    }

    private class ProxyEntry
    extends DynamicImplementation
    implements Forwarder {
        private ORB orb;

        public ProxyEntry(org.omg.CORBA.ORB oRB) {
            this.orb = (ORB)oRB;
        }

        public String[] _all_interfaces(POA pOA, byte[] byArray) {
            String[] stringArray = new String[]{"IDL:jacorb/proxy/Forwarder:1.0"};
            return stringArray;
        }

        public void Xswap4(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
            byte by = byArray[n + n5];
            byArray[n + n5] = byArray[n4 + n5];
            byArray[n4 + n5] = by;
            by = byArray[n2 + n5];
            byArray[n2 + n5] = byArray[n3 + n5];
            byArray[n3 + n5] = by;
        }

        public int doAlign(int n, int n2) {
            if (n % n2 != 0) {
                n = n + n2 - n % n2;
            }
            return n;
        }

        public void changeByteOrder(byte[] byArray) {
            boolean bl = (byArray[6] & 1) == 0;
            boolean bl2 = byArray[5] == 1;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (Environment.verbosityLevel() >= 3) {
                System.out.println("[changeByteOrder] little=" + bl + " is_giop_1_1=" + bl2);
            }
            this.Xswap4(byArray, 0, 1, 2, 3, n5 += 8);
            n = bl ? ((byArray[3 + n5] & 0xFF) << 24) + ((byArray[2 + n5] & 0xFF) << 16) + ((byArray[1 + n5] & 0xFF) << 8) + ((byArray[0 + n5] & 0xFF) << 0) : ((byArray[0 + n5] & 0xFF) << 24) + ((byArray[1 + n5] & 0xFF) << 16) + ((byArray[2 + n5] & 0xFF) << 8) + ((byArray[3 + n5] & 0xFF) << 0);
            if (Environment.verbosityLevel() >= 3) {
                System.out.println("[changeByteOrder[" + n5 + "]] msgSize=" + n);
            }
            this.Xswap4(byArray, 0, 1, 2, 3, n5 += 4);
            n2 = bl ? ((byArray[3 + n5] & 0xFF) << 24) + ((byArray[2 + n5] & 0xFF) << 16) + ((byArray[1 + n5] & 0xFF) << 8) + ((byArray[0 + n5] & 0xFF) << 0) : ((byArray[0 + n5] & 0xFF) << 24) + ((byArray[1 + n5] & 0xFF) << 16) + ((byArray[2 + n5] & 0xFF) << 8) + ((byArray[3 + n5] & 0xFF) << 0);
            if (Environment.verbosityLevel() >= 3) {
                System.out.println("[changeByteOrder[" + n5 + "]] serviceContextLength=" + n2);
            }
            n5 += 4;
            int n6 = n2;
            while (n6 > 0) {
                this.Xswap4(byArray, 0, 1, 2, 3, n5);
                this.Xswap4(byArray, 4, 5, 6, 7, n5);
                int n7 = bl ? ((byArray[7 + n5] & 0xFF) << 24) + ((byArray[6 + n5] & 0xFF) << 16) + ((byArray[5 + n5] & 0xFF) << 8) + ((byArray[4 + n5] & 0xFF) << 0) : ((byArray[4 + n5] & 0xFF) << 24) + ((byArray[5 + n5] & 0xFF) << 16) + ((byArray[6 + n5] & 0xFF) << 8) + ((byArray[7 + n5] & 0xFF) << 0);
                if (Environment.verbosityLevel() >= 3) {
                    System.out.println("[changeByteOrder[" + n5 + "]] context_dataLength=" + n7);
                }
                n5 = n5 + 8 + n7;
                n5 = this.doAlign(n5, 4);
                --n6;
            }
            this.Xswap4(byArray, 0, 1, 2, 3, n5);
            n5 += 4;
            ++n5;
            if (bl2) {
                n5 += 3;
            }
            n5 = this.doAlign(n5, 4);
            this.Xswap4(byArray, 0, 1, 2, 3, n5);
            n3 = bl ? ((byArray[3 + n5] & 0xFF) << 24) + ((byArray[2 + n5] & 0xFF) << 16) + ((byArray[1 + n5] & 0xFF) << 8) + ((byArray[0 + n5] & 0xFF) << 0) : ((byArray[0 + n5] & 0xFF) << 24) + ((byArray[1 + n5] & 0xFF) << 16) + ((byArray[2 + n5] & 0xFF) << 8) + ((byArray[3 + n5] & 0xFF) << 0);
            if (Environment.verbosityLevel() >= 3) {
                System.out.println("[changeByteOrder[" + n5 + "]] object_keyLength=" + n3);
            }
            n5 += 4 + n3;
            n5 = this.doAlign(n5, 4);
            this.Xswap4(byArray, 0, 1, 2, 3, n5);
            n4 = bl ? ((byArray[3 + n5] & 0xFF) << 24) + ((byArray[2 + n5] & 0xFF) << 16) + ((byArray[1 + n5] & 0xFF) << 8) + ((byArray[0 + n5] & 0xFF) << 0) : ((byArray[0 + n5] & 0xFF) << 24) + ((byArray[1 + n5] & 0xFF) << 16) + ((byArray[2 + n5] & 0xFF) << 8) + ((byArray[3 + n5] & 0xFF) << 0);
            if (Environment.verbosityLevel() >= 3) {
                System.out.println("[changeByteOrder[" + n5 + "]] opname_Length=" + n4);
            }
            byArray[6] = bl ? (byte)1 : 0;
        }

        public void invoke(org.omg.CORBA.ServerRequest serverRequest) {
            java.lang.Object object;
            int n = counter++;
            Debug.output(1, "[DynProxy]invoked:" + n);
            byte[] byArray = null;
            Integer n2 = null;
            ServerRequest serverRequest2 = (ServerRequest)serverRequest;
            byArray = serverRequest2.objectId();
            Current current = null;
            try {
                current = CurrentHelper.narrow(this.orb.resolve_initial_references("POACurrent"));
            }
            catch (UserException userException) {
                userException.printStackTrace();
            }
            MiniStub miniStub = (MiniStub)ForwarderImpl.this.forwardMap.get(new String(byArray));
            ParsedIOR parsedIOR = miniStub.getParsedIOR();
            Debug.output(4, "[Call should go to IOR: " + parsedIOR + " ]");
            ReplyInputStream replyInputStream = null;
            ClientConnection clientConnection = miniStub.getConnection();
            if (!clientConnection.connected()) {
                clientConnection.reconnect();
            }
            RequestOutputStream requestOutputStream = null;
            try {
                requestOutputStream = new RequestOutputStream(this.orb, clientConnection.getId(), serverRequest2.operation(), serverRequest2.get_in().req_hdr.response_expected, parsedIOR.get_object_key(), serverRequest2.getServiceContext());
                object = clientConnection.writeLock;
                synchronized (object) {
                    int n3;
                    byte[] byArray2 = requestOutputStream.getInternalBuffer();
                    System.out.println("[" + n + "]Incoming Request with size: " + (serverRequest2.get_in().msg_hdr.message_size + 12));
                    int n4 = serverRequest2.get_in().msg_hdr.message_size + 12 - serverRequest2.get_in().get_pos();
                    if (byArray2.length < n4 + requestOutputStream.size()) {
                        byte[] byArray3 = BufferManager.getInstance().getBuffer(n4 + requestOutputStream.size());
                        System.arraycopy(byArray2, 0, byArray3, 0, requestOutputStream.size());
                        byArray2 = byArray3;
                        n3 = requestOutputStream.size();
                        requestOutputStream.setBuffer(byArray2);
                        requestOutputStream.setSize(n3);
                    }
                    if (n4 > 0) {
                        System.arraycopy(serverRequest2.get_in().getBuffer(), serverRequest2.get_in().get_pos(), byArray2, requestOutputStream.size(), n4);
                    }
                    requestOutputStream.setSize(requestOutputStream.size() + n4);
                    requestOutputStream.insertMsgSize();
                    if ((serverRequest2.get_in().getBuffer()[6] & 1) != (byArray2[6] & 1)) {
                        this.changeByteOrder(byArray2);
                    }
                    if (Environment.verbosityLevel() >= 3) {
                        Debug.output(3, "[Proxy:Incoming byte-stream:]");
                        int n5 = 0;
                        while (n5 < serverRequest2.get_in().msg_hdr.message_size + 12) {
                            System.out.print(serverRequest2.get_in().getBuffer()[n5] + "  ");
                            ++n5;
                        }
                        Debug.output(3, "[Proxy:Outgoing byte-stream:]");
                        n3 = 0;
                        while (n3 < requestOutputStream.size()) {
                            System.out.print(requestOutputStream.getInternalBuffer()[n3] + "  ");
                            ++n3;
                        }
                        System.out.println("[The real Data:]");
                        int n6 = serverRequest2.get_in().get_pos();
                        while (n6 < serverRequest2.get_in().msg_hdr.message_size + 12) {
                            System.out.print(serverRequest2.get_in().getBuffer()[n6] + "  ");
                            ++n6;
                        }
                    }
                    if (requestOutputStream.response_expected()) {
                        replyInputStream = new ReplyInputStream((org.omg.CORBA.ORB)this.orb, requestOutputStream.requestId());
                        n2 = new Integer(requestOutputStream.requestId());
                        clientConnection.get_replies().put(n2, replyInputStream);
                        clientConnection.get_objects().put(n2, current.get_POA().servant_to_reference(this));
                    }
                    System.out.println("[" + n + "]Outgoing Request with size: " + requestOutputStream.size());
                    clientConnection.writeDirectly(requestOutputStream.getInternalBuffer(), requestOutputStream.size());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (requestOutputStream.response_expected()) {
                    object = (ReplyInputStream)replyInputStream.rawResult();
                    clientConnection.get_replies().remove(n2);
                    clientConnection.get_objects().remove(n2);
                    serverRequest2.reply(((CDRInputStream)object).getBuffer(), ((ReplyInputStream)object).msg_hdr.message_size + 12);
                }
            }
            catch (Exception exception) {
                Debug.output(1, "Proxy:reply forward error");
                serverRequest2.setSystemException(new COMM_FAILURE(exception.toString()));
                serverRequest2.reply();
            }
            Debug.output(1, "[DynProxy]invoke DONE:" + n);
        }
    }
}

