/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.domain;

import java.util.Hashtable;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainFactory;
import org.jacorb.orb.domain.DomainFactoryHelper;
import org.jacorb.orb.domain.DomainFactoryImpl;
import org.jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import org.jacorb.orb.domain.InitialMapPolicyOperations;
import org.jacorb.orb.domain.InitialMapPolicyPOATie;
import org.jacorb.orb.domain.ManagementPolicyImpl;
import org.jacorb.orb.domain.NameAlreadyDefined;
import org.jacorb.orb.domain.Util;
import org.jacorb.util.Debug;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class MapToTypeDomainsPolicy
extends ManagementPolicyImpl
implements InitialMapPolicyOperations {
    private Hashtable _typeDomains;
    private DomainFactory _factory;
    private InitialMapPolicyPOATie _tie;
    boolean callMyself = false;

    public MapToTypeDomainsPolicy() {
        super("initial map");
        String string = "This object implements the domain initial map policy. The initial map policy is used to map a newly created object reference to one or more domains. The strategy of this object is to map a new object reference to its type domain. The type domain of an object \"obj\" is the domain containing all objects which have the same most specific type as \"obj\".";
        this.long_description(string);
        this._typeDomains = new Hashtable();
    }

    public Domain[] OnReferenceCreation(Object object, Domain domain) {
        String string = Util.toID(object.toString());
        Debug.output(2, "type is a " + string);
        Domain domain2 = (Domain)this._typeDomains.get(string);
        if (domain2 == null) {
            if (this.callMyself) {
                return new Domain[0];
            }
            this.callMyself = true;
            domain2 = this._domainFactory().createDomain(null, null, string);
            this.callMyself = false;
            this._typeDomains.put(string, domain2);
            try {
                domain.insertChild(domain2);
            }
            catch (ClosesCycle closesCycle) {
                Debug.output(1, "MapToTypeDomainsPolicy.OnReferenceCreation: cannot insert " + Util.downcast(domain2) + " as child domain to " + "root domain " + Util.downcast(domain));
                Debug.output(1, closesCycle);
            }
            catch (NameAlreadyDefined nameAlreadyDefined) {
                Debug.output(1, "MapToTypeDomainsPolicy.OnReferenceCreation: cannot insert " + Util.downcast(domain2) + " as child domain to " + "root domain " + Util.downcast(domain));
                Debug.output(1, nameAlreadyDefined);
            }
        }
        Domain[] domainArray = new Domain[]{domain2};
        return domainArray;
    }

    private DomainFactory _domainFactory() {
        if (this._factory == null) {
            try {
                DomainFactoryImpl domainFactoryImpl = new DomainFactoryImpl();
                this.callMyself = true;
                this._factory = DomainFactoryHelper.narrow(this.getTie()._poa().servant_to_reference(domainFactoryImpl));
                this.callMyself = false;
            }
            catch (WrongPolicy wrongPolicy) {
                Debug.output(1, "the poa of this domain(" + this + ") has the wrong policies for \"servant_to_reference\".");
            }
            catch (Exception exception) {
                Debug.output(1, exception);
            }
        }
        return this._factory;
    }

    public void setTie(InitialMapPolicyPOATie initialMapPolicyPOATie) {
        this._tie = initialMapPolicyPOATie;
    }

    public InitialMapPolicyPOATie getTie() {
        Debug.assert(1, this._tie != null, "MapToTypeDomainsPolicy.getTie: tie is not set !");
        return this._tie;
    }

    public short strategy() {
        return 2;
    }

    public int policy_type() {
        return 115;
    }

    public Policy copy() {
        return this.getTie()._this();
    }
}

