/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Current;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.Reference;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.connection.ConnectionManager;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import org.jacorb.orb.domain.InvalidName;
import org.jacorb.orb.domain.NameAlreadyDefined;
import org.jacorb.orb.domain.ORBDomain;
import org.jacorb.orb.domain.ORBDomainHelper;
import org.jacorb.orb.domain.ORBDomainImpl;
import org.jacorb.orb.domain.ORBDomainPOATie;
import org.jacorb.orb.domain.PolicyFactoryHelper;
import org.jacorb.orb.domain.PolicyFactoryImpl;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.policies.BiDirPolicyFactoryImpl;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAConstants;
import org.jacorb.poa.POAListener;
import org.jacorb.transaction.TransactionCurrentImpl;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.Request;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public final class ORB
extends ORBSingleton
implements POAListener {
    private static final String versionString = "1.3.30";
    private static final String dateString = "13 June 2001";
    private Hashtable initial_references = new Hashtable();
    private POA rootpoa;
    private org.jacorb.poa.Current poaCurrent;
    private BasicAdapter basicAdapter;
    private Current current;
    private org.omg.SecurityLevel2.Current securityCurrent = null;
    private InterceptorManager interceptor_manager = null;
    private Hashtable knownReferences = null;
    private ConnectionManager connectionManager;
    private BufferManager bufferManager = BufferManager.getInstance();
    private Properties _props;
    public String[] _args;
    protected Version IIOPVersion = new Version(1, 1);
    public Applet applet;
    private java.lang.Object orb_synch = new java.lang.Object();
    private boolean run = true;
    private boolean wait = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private java.lang.Object shutdown_synch = new java.lang.Object();
    private static boolean ORBDomainCreationInProgress = false;
    private Registration imr = null;
    private ImRInfo imr_info = null;
    private int persistentPOACount;
    public static String orb_id = "jacorb:1.0";
    private Hashtable policy_factories = null;
    private static TCKind kind;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;

    public ORB() {
        this.connectionManager = new ConnectionManager(this);
        String string = Environment.getProperty("jacorb.hashtable_class");
        if (string == null || string.length() == 0) {
            Debug.output(514, "Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            this.knownReferences = new Hashtable();
        } else {
            try {
                this.knownReferences = (Hashtable)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                Debug.output(514, exception);
                this.knownReferences = new Hashtable();
            }
        }
    }

    synchronized Object _getObject(ParsedIOR parsedIOR) {
        Delegate delegate;
        String string = parsedIOR.getIORString();
        ObjectImpl objectImpl = (ObjectImpl)this.knownReferences.get(string);
        if (objectImpl != null) {
            Debug.output(5, "Found a reference for key " + string + " in cache ");
            delegate = (Delegate)objectImpl._get_delegate();
            if (delegate != null) {
                ParsedIOR parsedIOR2 = delegate.getParsedIOR();
                if (parsedIOR2 == null) {
                    this.knownReferences.remove(string);
                    Debug.output(4, "Removing an invalid reference from cache.");
                } else if (parsedIOR.getAddress().equals(parsedIOR2.getAddress())) {
                    return objectImpl._duplicate();
                }
            } else {
                Debug.output(3, "remove stale reference for key " + string + " from cache ");
                this.knownReferences.remove(string);
            }
        }
        delegate = new Delegate((org.omg.CORBA.ORB)this, parsedIOR);
        objectImpl = delegate.getReference(null);
        if (Environment.cacheReferences()) {
            Debug.output(5, "Caching reference for key " + string);
            this.knownReferences.put(string, objectImpl);
        }
        return objectImpl;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    synchronized void _release(Delegate delegate) {
        this.knownReferences.remove(delegate.pior.getIORString());
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        Integer n2 = new Integer(n);
        if (this.policy_factories == null || !this.policy_factories.containsKey(n2)) {
            throw new PolicyError();
        }
        PolicyFactory policyFactory = (PolicyFactory)this.policy_factories.get(n2);
        return policyFactory.create_policy(n, any);
    }

    public boolean hasPolicyFactoryForType(int n) {
        return this.policy_factories != null && this.policy_factories.containsKey(new Integer(n));
    }

    public ContextList create_context_list() {
        return null;
    }

    public org.omg.CORBA.Environment create_environment() {
        return null;
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    protected IOR createIOR(String string, byte[] byArray, boolean bl, POA pOA) {
        boolean bl2 = false;
        TaggedProfile[] taggedProfileArray = null;
        String string2 = Environment.getProperty("jacorb.ior_proxy_host");
        if (string2 == null) {
            string2 = this.basicAdapter.getAddress();
        } else {
            Debug.output(514, "Using proxy host " + string2 + " in IOR");
        }
        String string3 = Environment.getProperty("jacorb.ior_proxy_port");
        int n = -1;
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Error("Unable to create int from string >>" + string3 + "<<. " + "(check property \"jacorb.ior_proxy_port\")");
            }
            if (n < 0) {
                throw new Error("Negative port numbers are not allowed! (check property \"jacorb.ior_proxy_port\")");
            }
        } else {
            n = this.basicAdapter.getPort();
        }
        if (!bl && Environment.useImR()) {
            try {
                if (this.imr == null) {
                    this.imr = RegistrationHelper.narrow(this.resolve_initial_references("ImplementationRepository"));
                }
                if (this.imr_info == null) {
                    this.imr_info = this.imr.get_imr_info();
                }
                string2 = this.imr_info.host;
                n = this.imr_info.port;
                Debug.output(2, "New persistent IOR created with ImR at " + string2 + ":" + n);
            }
            catch (Exception exception) {
                Debug.output(6, exception);
            }
        }
        boolean bl3 = Environment.charsetUpdateMulti();
        TaggedComponent[] taggedComponentArray = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
            IORInfoImpl iORInfoImpl = new IORInfoImpl(this, pOA, vector, vector2);
            try {
                this.interceptor_manager.getIORIterator().iterate(iORInfoImpl);
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
        switch (this.IIOPVersion.minor) {
            case 1: {
                taggedComponentArray = new TaggedComponent[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    taggedComponentArray[n2] = (TaggedComponent)vector.elementAt(n2);
                    ++n2;
                }
                ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1(this.IIOPVersion, string2, (short)n, byArray, taggedComponentArray);
                CDROutputStream cDROutputStream = new CDROutputStream(this);
                cDROutputStream.write_boolean(bl2);
                ProfileBody_1_1Helper.write(cDROutputStream, profileBody_1_1);
                taggedProfileArray = new TaggedProfile[bl3 ? 3 : 2];
                taggedProfileArray[1] = new TaggedProfile(0, cDROutputStream.getBufferCopy());
            }
            case 0: {
                ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0(new Version(1, 0), string2, (short)n, byArray);
                CDROutputStream cDROutputStream = new CDROutputStream(this);
                cDROutputStream.write_boolean(bl2);
                ProfileBody_1_0Helper.write(cDROutputStream, profileBody_1_0);
                if (taggedProfileArray == null) {
                    taggedProfileArray = new TaggedProfile[bl3 ? 2 : 1];
                }
                taggedProfileArray[0] = new TaggedProfile(0, cDROutputStream.getBufferCopy());
                if (!bl3) break;
                taggedComponentArray = new TaggedComponent[vector2.size()];
                int n3 = 0;
                while (n3 < vector2.size()) {
                    taggedComponentArray[n3] = (TaggedComponent)vector2.elementAt(n3);
                    ++n3;
                }
                cDROutputStream = new CDROutputStream(this);
                cDROutputStream.write_boolean(bl2);
                MultipleComponentProfileHelper.write(cDROutputStream, taggedComponentArray);
                taggedProfileArray[taggedProfileArray.length - 1] = new TaggedProfile(1, cDROutputStream.getBufferCopy());
            }
        }
        IOR iOR = new IOR(string, taggedProfileArray);
        if (Environment.useAppligator(this.isApplet())) {
            try {
                CDROutputStream cDROutputStream = new CDROutputStream(this);
                cDROutputStream.write_boolean(bl2);
                IORHelper.write(cDROutputStream, iOR);
                byte[] byArray2 = cDROutputStream.getBufferCopy();
                StringBuffer stringBuffer = new StringBuffer("IOR:");
                int n4 = 0;
                while (n4 < byArray2.length) {
                    int n5 = byArray2[n4];
                    if (n5 < 0) {
                        n5 += 256;
                    }
                    int n6 = (n5 & 0xFF) / 16;
                    int n7 = (n5 & 0xFF) % 16;
                    int n8 = n6 < 10 ? 48 + n6 : 97 + (n6 - 10);
                    int n9 = n7 < 10 ? 48 + n7 : 97 + (n7 - 10);
                    stringBuffer.append((char)n8);
                    stringBuffer.append((char)n9);
                    ++n4;
                }
                String string4 = stringBuffer.toString();
                Debug.output(4, "ORB.createIOR, proxifying original ior " + iOR.hashCode());
                IOR iOR2 = this.getConnectionManager().proxyfy(string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return iOR;
    }

    IOR unproxyfy(IOR iOR) {
        return this.getConnectionManager().unproxyfy(iOR);
    }

    public org.omg.CORBA.Current get_current() {
        return this.current;
    }

    public Context get_default_context() {
        return null;
    }

    public Request get_next_response() {
        return null;
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new RuntimeException("Adapters not initialized, call POA.init() first");
        }
        return this.basicAdapter;
    }

    public org.jacorb.poa.Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = org.jacorb.poa.Current._Current_init();
        }
        return this.poaCurrent;
    }

    public Object getReference(POA pOA, byte[] byArray, String string, boolean bl) {
        try {
            if (string == null) {
                string = "IDL:org.omg/CORBA/Object:1.0";
            }
            IOR iOR = this.createIOR(string, byArray, bl, pOA);
            Delegate delegate = new Delegate((org.omg.CORBA.ORB)this, iOR);
            return delegate.getReference(pOA);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public POA getRootPOA() {
        if (this.rootpoa == null) {
            this.rootpoa = POA._POA_init(this);
            this.rootpoa._addPOAEventListener(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa);
        }
        return this.rootpoa;
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public String[] list_initial_services() {
        String[] stringArray = new String[]{"NameService", "TradingService", "RootPOA", "POACurrent", "DynAnyFactory", "DomainService", "LocalDomainService", "PICurrent", "CodecFactory", "TransactionCurrent"};
        return stringArray;
    }

    public void poaCreated(POA pOA) {
        pOA._addPOAEventListener(this);
        if (pOA.isPersistent()) {
            ++this.persistentPOACount;
            if (this.imr == null && Environment.useImR()) {
                try {
                    this.imr = RegistrationHelper.narrow(this.resolve_initial_references("ImplementationRepository"));
                }
                catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
                    // empty catch block
                }
                if (this.imr == null || this.imr._non_existent()) {
                    Debug.output(3, "No connection to ImplementationRepository");
                    return;
                }
            }
            if (this.imr != null) {
                try {
                    String string = new String(Environment.implName());
                    this.imr.register_poa(string + "/" + pOA._getQualifiedName(), string, this.basicAdapter.getAddress(), this.basicAdapter.getPort());
                }
                catch (DuplicatePOAName duplicatePOAName) {
                    throw new INTERNAL("A server with the same combination of ImplName/POA-Name (" + new String(Environment.implName()) + '/' + pOA._getQualifiedName() + ") is already registered and listed as active at the imr!");
                }
                catch (IllegalPOAName illegalPOAName) {
                    throw new INTERNAL("The ImR replied that the POA name >>" + illegalPOAName.name + "<< is illegal!");
                }
                catch (UnknownServerName unknownServerName) {
                    throw new INTERNAL("The ImR replied that the server name >>" + unknownServerName.name + "<< is unknown!");
                }
                catch (Exception exception) {
                    Debug.output(4, exception);
                }
            }
        }
    }

    public void poaStateChanged(POA pOA, int n) {
        if ((n == POAConstants.DESTROYED || n == POAConstants.INACTIVE) && pOA.isPersistent() && this.imr != null && --this.persistentPOACount == 0) {
            try {
                this.imr.set_server_down(new String(Environment.implName()));
            }
            catch (Exception exception) {
                Debug.output(2, exception);
            }
        }
    }

    public boolean poll_next_response() {
        return false;
    }

    public void referenceCreated(Object object) {
    }

    public boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        return false;
    }

    public Object resolve_initial_references(String string) throws org.omg.CORBA.ORBPackage.InvalidName {
        if (Environment.useAppligator(this.isApplet())) {
            this.getConnectionManager().initProxy();
        }
        if (this.initial_references.containsKey(string)) {
            return (Object)this.initial_references.get(string);
        }
        Object object = null;
        String string2 = Environment.getProperty("ORBInitRef." + string);
        if (string2 != null) {
            object = this.string_to_object(string2);
        } else if (string.equals("NameService") && this.isApplet()) {
            String string3 = ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + "NameService.ior");
            object = this.string_to_object(string3);
            if (!object._is_a(NamingContextHelper.id())) {
                object = null;
            }
        } else {
            if (string.equals("RootPOA")) {
                return this.getRootPOA();
            }
            if (string.equals("POACurrent")) {
                return this.getPOACurrent();
            }
            if (string.equals("LocalDomainService")) {
                java.lang.Object object2;
                java.lang.Object object3;
                java.lang.Object object4;
                if (!Environment.useDomain()) {
                    throw new org.omg.CORBA.ORBPackage.InvalidName("domain service is not configured for usage. Set property \"jacorb.use_domain\" to \"on\".");
                }
                ORBDomain oRBDomain = null;
                if (ORBDomainCreationInProgress) {
                    throw new org.omg.CORBA.ORBPackage.InvalidName("second call");
                }
                ORBDomainCreationInProgress = true;
                try {
                    object4 = new PolicyFactoryImpl();
                    try {
                        this.getRootPOA().the_POAManager().activate();
                    }
                    catch (AdapterInactive adapterInactive) {
                        Debug.output(1, adapterInactive);
                    }
                    object3 = PolicyFactoryHelper.narrow(this.getRootPOA().servant_to_reference((Servant)object4));
                    object2 = new Policy[]{object3.createConflictResolutionPolicy((short)2)};
                    ORBDomainImpl oRBDomainImpl = new ORBDomainImpl(null, (Policy[])object2, "orb domain");
                    ORBDomainPOATie oRBDomainPOATie = new ORBDomainPOATie(oRBDomainImpl);
                    oRBDomainImpl.setTie(oRBDomainPOATie);
                    oRBDomain = ORBDomainHelper.narrow(this.getRootPOA().servant_to_reference(oRBDomainPOATie));
                    object = oRBDomain;
                    ORBDomainCreationInProgress = false;
                }
                catch (WrongPolicy wrongPolicy) {
                    Debug.output(1, "the root poa of this orb has the wrong policies for \"servant_to_reference\".");
                }
                catch (ServantNotActive servantNotActive) {
                    Debug.output(1, servantNotActive);
                }
                if (Environment.mountORBDomain()) {
                    this.initial_references.put(string, object);
                    this.mountORBDomain();
                }
                if ((object4 = Environment.ORBDomainFilename()) != null && !((String)object4).equals("")) {
                    Debug.output(32770, "writing IOR of local domain service to file " + (String)object4);
                    try {
                        object3 = new FileOutputStream((String)object4);
                        object2 = new PrintWriter((OutputStream)object3);
                        ((PrintWriter)object2).println(this.object_to_string(oRBDomain));
                        ((PrintWriter)object2).flush();
                        ((FileOutputStream)object3).close();
                    }
                    catch (IOException iOException) {
                        Debug.output(1, "Unable to write IOR to file " + (String)object4);
                    }
                }
            } else if (string.equals("SecurityCurrent")) {
                if (this.securityCurrent == null) {
                    try {
                        Class<?> clazz = Class.forName("org.jacorb.security.level2.CurrentImpl");
                        Constructor<?> constructor = clazz.getConstructor(class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = ORB.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB);
                        this.securityCurrent = (org.omg.SecurityLevel2.Current)constructor.newInstance(this);
                        Method method = clazz.getDeclaredMethod("init", new Class[0]);
                        method.invoke((java.lang.Object)this.securityCurrent, new java.lang.Object[0]);
                    }
                    catch (Exception exception) {
                        Debug.output(513, exception);
                    }
                }
                object = this.securityCurrent;
            } else if (string.equals("DynAnyFactory")) {
                object = new DynAnyFactoryImpl(this)._this();
            } else {
                if (string.equals("PICurrent")) {
                    if (this.interceptor_manager == null) {
                        return InterceptorManager.EMPTY_CURRENT;
                    }
                    return this.interceptor_manager.getCurrent();
                }
                if (string.equals("CodecFactory")) {
                    object = new CodecFactoryImpl(this);
                } else if (string.equals("TransactionCurrent")) {
                    object = new TransactionCurrentImpl();
                } else {
                    throw new org.omg.CORBA.ORBPackage.InvalidName();
                }
            }
        }
        if (object != null) {
            this.initial_references.put(string, object);
            return object;
        }
        return null;
    }

    public void register_initial_reference(String string, Object object) throws org.omg.CORBA.ORBPackage.InvalidName {
        if (string == null || string.length() == 0 || this.initial_references.containsKey(string)) {
            throw new org.omg.CORBA.ORBPackage.InvalidName();
        }
        this.initial_references.put(string, object);
    }

    public void run() {
        Debug.output(4, "ORB run");
        try {
            java.lang.Object object = this.orb_synch;
            synchronized (object) {
                while (this.run) {
                    this.orb_synch.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Debug.output(4, "ORB run, exit");
    }

    public void send_multiple_requests_deferred(Request[] requestArray) {
    }

    public void send_multiple_requests_oneway(Request[] requestArray) {
    }

    protected void set_parameters(String[] stringArray, Properties properties) {
        this._args = stringArray;
        this._props = properties;
        Environment.addProperties(properties);
        String string = Environment.getProperty("jacorb.orb.print_version");
        if (string != null && string.equals("on")) {
            System.out.println("\tJacORB V 1.3.30, www.jacorb.org");
            System.out.println("\t(C) Gerald Brose, FU Berlin, 13 June 2001");
        }
        this.interceptorInit();
    }

    protected void set_parameters(Applet applet, Properties properties) {
        this.applet = applet;
        this._props = properties;
        Environment.addProperties(properties);
        this.interceptorInit();
    }

    private void interceptorInit() {
        Vector vector = Environment.getORBInitializers();
        if (vector.size() > 0) {
            java.lang.Object object;
            Serializable serializable;
            ORBInitInfoImpl oRBInitInfoImpl = new ORBInitInfoImpl(this);
            int n = 0;
            while (n < vector.size()) {
                try {
                    ORBInitializer oRBInitializer = (ORBInitializer)vector.elementAt(n);
                    oRBInitializer.pre_init(oRBInitInfoImpl);
                }
                catch (Exception exception) {
                    Debug.output(0, exception);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                try {
                    serializable = (ORBInitializer)vector.elementAt(n2);
                    serializable.post_init(oRBInitInfoImpl);
                }
                catch (Exception exception) {
                    Debug.output(0, exception);
                }
                ++n2;
            }
            oRBInitInfoImpl.setInvalid();
            serializable = oRBInitInfoImpl.getClientInterceptors();
            Vector vector2 = oRBInitInfoImpl.getServerInterceptors();
            Vector vector3 = oRBInitInfoImpl.getIORInterceptors();
            if (vector2.size() > 0 || ((Vector)serializable).size() > 0 || vector3.size() > 0) {
                this.interceptor_manager = new InterceptorManager((Vector)serializable, vector2, vector3, oRBInitInfoImpl.getSlotCount(), this);
                object = this.knownReferences.elements();
                while (object.hasMoreElements()) {
                    Reference reference = (Reference)object.nextElement();
                    if (reference == null) continue;
                    ((Delegate)reference._get_delegate()).initInterceptors();
                }
            }
            this.policy_factories = oRBInitInfoImpl.getPolicyFactories();
            try {
                object = new BiDirPolicyFactoryImpl(this);
                this.policy_factories.put(new Integer(37), object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void shutdown(boolean bl) {
        Debug.output(2, "prepare ORB for going down...");
        if (!this.run) {
            return;
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            Debug.output(2, "ORB going down...");
            if (this.shutdown_in_progress && bl) {
                java.lang.Object object2 = this.shutdown_synch;
                synchronized (object2) {
                    try {
                        this.shutdown_synch.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Debug.output(2, "ORB shutdown complete (1)");
                    return;
                }
            }
            if (this.shutdown_in_progress && !bl) {
                Debug.output(2, "ORB shutdown complete (2)");
                return;
            }
            this.shutdown_in_progress = true;
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, bl);
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        Debug.output(3, "ORB shutdown (cleaning up ORB...)");
        this.connectionManager.shutdown();
        this.knownReferences.clear();
        BufferManager.getInstance().release();
        Debug.output(3, "ORB shutdown (all tables cleared)");
        java.lang.Object object3 = this.shutdown_synch;
        synchronized (object3) {
            this.shutdown_synch.notifyAll();
        }
        Debug.output(3, "ORB shutdown (threads notified)");
        java.lang.Object object4 = this.orb_synch;
        synchronized (object4) {
            this.run = false;
            this.orb_synch.notifyAll();
        }
        Debug.output(2, "ORB shutdown complete");
    }

    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        if (this.run) {
            this.shutdown(true);
        }
        this.destroyed = true;
    }

    public Object string_to_object(String string) {
        if (string == null) {
            return null;
        }
        ParsedIOR parsedIOR = new ParsedIOR(string);
        if (parsedIOR.isNull()) {
            return null;
        }
        return this._getObject(parsedIOR);
    }

    public void set_delegate(java.lang.Object object) {
        if (!(object instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)object)._get_delegate();
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            ServantDelegate servantDelegate = new ServantDelegate(this);
            ((Servant)object)._set_delegate(servantDelegate);
        }
    }

    public void useProxy() {
        this.applet = new Applet();
    }

    public String object_to_string(Object object) {
        return object.toString();
    }

    public void perform_work() {
    }

    public boolean work_pending() {
        return false;
    }

    public boolean hasClientRequestInterceptors() {
        return this.interceptor_manager != null && this.interceptor_manager.hasClientRequestInterceptors();
    }

    public boolean hasServerRequestInterceptors() {
        return this.interceptor_manager != null && this.interceptor_manager.hasServerRequestInterceptors();
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public void mountORBDomain() {
        this.mountORBDomain("orb domain");
    }

    public void mountORBDomain(String string) {
        Domain domain = null;
        Domain domain2 = null;
        try {
            domain = DomainHelper.narrow(this.resolve_initial_references("DomainService"));
            domain2 = DomainHelper.narrow(this.resolve_initial_references("LocalDomainService"));
            if (string == null || string.equals("")) {
                string = "orb domain";
            }
            if (domain.hasChild(domain2)) {
                Debug.output(2, "ORB.mountORBDomain: rename from \"" + domain2.name() + "\" to \"" + string + "\".");
                domain.renameChildDomain(domain2.name(), string);
                domain2.name(string);
                return;
            }
            domain2.name(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            Debug.output(1, invalidName);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            return;
        }
        catch (InvalidName invalidName) {
            return;
        }
        int n = 0;
        while (true) {
            try {
                domain.insertChild(domain2);
                return;
            }
            catch (ClosesCycle closesCycle) {
                Debug.output(1, closesCycle);
                return;
            }
            catch (NameAlreadyDefined nameAlreadyDefined) {
                Debug.output(1, "ORB.mountORBDomain: name " + nameAlreadyDefined.name + " already used in domain server scope");
                domain2.name(string + "#" + Integer.toString(++n));
                continue;
            }
            break;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

