/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.ApplicationExceptionHelper;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.Reference;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.ClientConnection;
import org.jacorb.orb.connection.LocateReplyInputStream;
import org.jacorb.orb.connection.LocateRequestOutputStream;
import org.jacorb.orb.connection.ReplyInputStream;
import org.jacorb.orb.connection.RequestOutputStream;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.domain.Domain;
import org.jacorb.orb.domain.DomainHelper;
import org.jacorb.orb.domain.DomainListHelper;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.poa.InvocationContext;
import org.jacorb.poa.LocalInvocationContext;
import org.jacorb.poa.POA;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.GIOP.ReplyHeader_1_0;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.Servant;
import org.omg.SSLIOP.SSL;

public final class Delegate
extends org.omg.CORBA.portable.Delegate {
    public ParsedIOR pior;
    public ClientConnection connection;
    private byte[] object_key;
    private byte[] oid;
    private String adport;
    private IOR ior;
    ServiceContext[] ctx = new ServiceContext[0];
    private SSL ssl;
    private static Domain _domainService = null;
    private boolean uses_ssl = false;
    private IOR iorOriginal = null;
    private ParsedIOR piorOriginal = null;
    private boolean bound = false;
    private POA poa;
    protected org.omg.CORBA.ORB orb;
    private InvocationContext context;
    private boolean use_interceptors = false;
    private boolean location_forward_permanent = true;
    private Hashtable pending_replies = new Hashtable();
    private Barrier pending_replies_sync = new Barrier();

    public Delegate() {
    }

    protected Delegate(org.omg.CORBA.ORB oRB, ParsedIOR parsedIOR) {
        this.orb = oRB;
        this.ior = parsedIOR.getIOR();
        this.pior = parsedIOR;
        this._init();
    }

    protected Delegate(org.omg.CORBA.ORB oRB, String string) {
        this.orb = oRB;
        if (string.indexOf("IOR:") != 0) {
            throw new INV_OBJREF("Not an IOR: " + string);
        }
        this.pior = new ParsedIOR(string);
        this.ior = this.pior.getIOR();
        this._init();
    }

    protected Delegate(org.omg.CORBA.ORB oRB, IOR iOR) {
        this.orb = oRB;
        this.ior = iOR;
        this.pior = new ParsedIOR(this.ior);
        this._init();
    }

    public int _get_TCKind() {
        return 14;
    }

    private boolean useSSL(SSL sSL) {
        if (sSL == null) {
            return false;
        }
        return Environment.enforceSSL() || Environment.supportSSL() && sSL.target_requires > 1;
    }

    private void _init() {
        ProfileBody_1_1 profileBody_1_1 = this.pior.getProfileBody();
        int n = profileBody_1_1.port;
        this.ssl = ParsedIOR.getSSLTaggedComponent(profileBody_1_1);
        if (this.useSSL(this.ssl)) {
            this.uses_ssl = true;
            n = this.ssl.port;
        } else {
            this.uses_ssl = false;
        }
        if (n < 0) {
            n += 65536;
        }
        this.object_key = profileBody_1_1.object_key;
        this.adport = profileBody_1_1.host + ":" + n;
        if (this.uses_ssl) {
            Debug.output(3, "Delegate bound to SSL " + this.adport);
        } else {
            Debug.output(3, "Delegate bound to " + this.adport);
        }
        this.initInterceptors();
    }

    public synchronized void bind() {
        if (this.bound) {
            return;
        }
        this.connection = ((ORB)this.orb).getConnectionManager().getConnection(this);
        this.bound = true;
        this.connection.duplicate();
        if (Environment.locateOnBind()) {
            LocateRequestOutputStream locateRequestOutputStream = new LocateRequestOutputStream(this.object_key, this.connection.getId());
            LocateReplyInputStream locateReplyInputStream = this.connection.sendLocateRequest(locateRequestOutputStream);
            switch (locateReplyInputStream.status().value()) {
                case 1: {
                    Debug.output(3, "object here");
                    break;
                }
                case 2: {
                    Debug.output(3, "Locate Reply: Forward");
                    this.unbind();
                    this.bind(this.orb.object_to_string(locateReplyInputStream.read_Object()));
                    break;
                }
                case 0: {
                    throw new UNKNOWN("Could not bind to object, server does not know it!");
                }
                default: {
                    throw new RuntimeException("Unknown reply status for LOCATE_REQUEST: " + locateReplyInputStream.status().value());
                }
            }
        }
    }

    public synchronized void bind(String string) {
        if (this.bound) {
            return;
        }
        if (string.indexOf("IOR:") == 0) {
            this.pior = new ParsedIOR(string);
            this.ior = this.pior.getIOR();
        }
        this._init();
        this.bind();
    }

    public synchronized void unbind() {
        if (!this.bound) {
            return;
        }
        this.pior = null;
        this.adport = null;
        if (this.connection != null) {
            this.connection.releaseConnection();
        }
        this.bound = false;
    }

    public org.omg.CORBA.Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue) {
        if (!this.bound) {
            this.bind();
        }
        return new Request(object, this.orb, this.connection, this.object_key, string, nVList, context, namedValue);
    }

    public org.omg.CORBA.Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue, ExceptionList exceptionList, ContextList contextList) {
        throw new NO_IMPLEMENT();
    }

    public synchronized Object duplicate(Object object) {
        return object;
    }

    public boolean equals(java.lang.Object object) {
        return object instanceof Object && this.toString().equals(object.toString());
    }

    public boolean equals(Object object, java.lang.Object object2) {
        return this.equals(object2);
    }

    public void finalize() {
        ((ORB)this.orb)._release(this);
        if (this.bound) {
            this.unbind();
        }
        Debug.output(3, " Delegate gc'ed!");
    }

    public String get_adport() {
        return this.adport;
    }

    private Domain _domainService() {
        if (_domainService == null) {
            try {
                Debug.output(32771, "Delegate._domainService: fetching global domain service reference from orb");
                _domainService = DomainHelper.narrow(this.orb.resolve_initial_references("DomainService"));
            }
            catch (Exception exception) {
                Debug.output(32769, exception);
            }
        }
        return _domainService;
    }

    public DomainManager[] get_domain_managers(Object object) {
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_get_domain_managers", true);
                outputStream.write_Object(object);
                InputStream inputStream = this.invoke(object, outputStream);
                return DomainListHelper.read(inputStream);
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            catch (ApplicationException applicationException) {
                String string = applicationException.getId();
                throw new RuntimeException("Unexpected exception " + string);
            }
            break;
        }
    }

    public Policy get_policy_no_intercept(Object object, int n) {
        if (!this.bound) {
            this.bind();
        }
        this.ctx = this.connection.addCodeSetContext(this.ctx, this.pior);
        RequestOutputStream requestOutputStream = new RequestOutputStream(this.orb, this.connection.getId(), "_get_policy", true, this.object_key, this.ctx);
        return this.get_policy(object, n, requestOutputStream);
    }

    public Policy get_policy(Object object, int n) {
        return this.get_policy(object, n, this.request(object, "_get_policy", true));
    }

    public Policy get_policy(Object object, int n, OutputStream outputStream) {
        while (true) {
            try {
                outputStream.write_Object(object);
                outputStream.write_long(n);
                InputStream inputStream = this.invoke(object, outputStream);
                return PolicyHelper.narrow(inputStream.read_Object());
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            catch (ApplicationException applicationException) {
                String string = applicationException.getId();
                throw new RuntimeException("Unexpected exception " + string);
            }
            break;
        }
    }

    public InterfaceDef get_interface(Object object) {
        return InterfaceDefHelper.narrow(this.get_interface_def(object));
    }

    /*
     * Loose catch block
     */
    public Object get_interface_def(Object object) {
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_interface", true);
                InputStream inputStream = this.invoke(object, outputStream);
                return inputStream.read_Object();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            break;
        }
        catch (Exception exception) {
            return null;
        }
    }

    ClientConnection getConnection() {
        return this.connection;
    }

    public IOR getIOR() {
        if (this.iorOriginal != null) {
            return this.iorOriginal;
        }
        return this.ior;
    }

    public byte[] getObjectId() {
        if (this.oid == null) {
            this.oid = POAUtil.extractOID(this.object_key);
        }
        return this.oid;
    }

    public byte[] getObjectKey() {
        return this.object_key;
    }

    public ParsedIOR getParsedIOR() {
        return this.pior;
    }

    public POA getPOA() {
        return this.poa;
    }

    public boolean port_is_ssl() {
        if (this.uses_ssl && this.connection != null && !this.connection.isSSL()) {
            Debug.output(1, "SSL socket expected. FATAL ERROR.");
            System.exit(0);
        }
        return this.uses_ssl;
    }

    public SSL ssl() {
        return this.ssl;
    }

    public ObjectImpl getReference(POA pOA) {
        if (pOA != null && pOA._localStubsSupported()) {
            this.poa = pOA;
        }
        Reference reference = new Reference(this.typeId());
        reference._set_delegate(this);
        return reference;
    }

    public int hash(Object object, int n) {
        return this.hashCode();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int hashCode(Object object) {
        return this.hashCode();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream invoke(Object object, OutputStream outputStream) throws ApplicationException, RemarshalException {
        java.lang.Object object2;
        java.lang.Object object3;
        ReplyInputStream replyInputStream = null;
        ClientRequestInfoImpl clientRequestInfoImpl = null;
        RequestOutputStream requestOutputStream = null;
        if (!this.bound) {
            this.bind();
        }
        requestOutputStream = (RequestOutputStream)outputStream;
        if (this.use_interceptors && requestOutputStream.separateHeader()) {
            clientRequestInfoImpl = new ClientRequestInfoImpl();
            clientRequestInfoImpl.orb = (ORB)this.orb;
            clientRequestInfoImpl.operation = requestOutputStream.operation();
            clientRequestInfoImpl.response_expected = requestOutputStream.response_expected();
            clientRequestInfoImpl.setRequestServiceContexts(requestOutputStream.getServiceContexts());
            clientRequestInfoImpl.received_exception = this.orb.create_any();
            if (requestOutputStream.getRequest() != null) {
                clientRequestInfoImpl.setRequest(requestOutputStream.getRequest());
            }
            clientRequestInfoImpl.effective_target = object;
            clientRequestInfoImpl.target = this.iorOriginal != null ? ((ORB)this.orb)._getObject(this.pior) : object;
            clientRequestInfoImpl.effective_profile = this.pior.getEffectiveProfile();
            object3 = this.pior.getProfileBody();
            if (object3 != null) {
                clientRequestInfoImpl.effective_components = ((ProfileBody_1_1)object3).components;
            }
            if (clientRequestInfoImpl.effective_components == null) {
                Debug.output(3, "no effective components");
                clientRequestInfoImpl.effective_components = new TaggedComponent[0];
            } else {
                object2 = ParsedIOR.getSSLTaggedComponent(clientRequestInfoImpl.effective_components);
                if (object2 == null) {
                    Debug.output(3, "no SSL in effective components");
                }
            }
            clientRequestInfoImpl.delegate = this;
            clientRequestInfoImpl.request_id = requestOutputStream.requestId();
            object2 = ((ORB)this.orb).getInterceptorManager();
            clientRequestInfoImpl.current = ((InterceptorManager)object2).getCurrent();
            clientRequestInfoImpl.request_os = requestOutputStream;
            this.invokeInterceptors(clientRequestInfoImpl, (short)0);
            requestOutputStream.setServiceContexts(clientRequestInfoImpl.getRequestServiceContexts());
        }
        try {
            outputStream.close();
            replyInputStream = (ReplyInputStream)this.connection.sendRequest(object, requestOutputStream);
            this.connection.markTcsNegotiated();
            if (requestOutputStream.response_expected()) {
                this.pending_replies.put(replyInputStream, replyInputStream);
            }
        }
        catch (SystemException systemException) {
            if (this.use_interceptors && clientRequestInfoImpl != null) {
                SystemExceptionHelper.insert(clientRequestInfoImpl.received_exception, systemException);
                try {
                    clientRequestInfoImpl.received_exception_id = SystemExceptionHelper.type(systemException).id();
                }
                catch (BadKind badKind) {
                    Debug.output(2, badKind);
                }
                clientRequestInfoImpl.reply_status = 1;
                clientRequestInfoImpl.setReplyServiceContexts(new ServiceContext[0]);
                this.invokeInterceptors(clientRequestInfoImpl, (short)3);
            }
            if (this.iorOriginal != null) {
                this.unbind();
                this.ior = this.iorOriginal;
                this.iorOriginal = null;
                this.piorOriginal = null;
                this.pior = new ParsedIOR(this.ior);
                this._init();
                this.bind();
                throw new RemarshalException();
            }
            throw systemException;
        }
        catch (IOException iOException) {
            Debug.output(0, iOException);
            ApplicationException applicationException = new ApplicationException(iOException.getMessage(), null);
            if (this.use_interceptors && clientRequestInfoImpl != null) {
                SystemExceptionHelper.insert(clientRequestInfoImpl.received_exception, new UNKNOWN(iOException.getMessage(), 1, CompletionStatus.COMPLETED_MAYBE));
                clientRequestInfoImpl.received_exception_id = applicationException.getId();
                clientRequestInfoImpl.reply_status = 1;
                clientRequestInfoImpl.setReplyServiceContexts(new ServiceContext[0]);
                this.invokeInterceptors(clientRequestInfoImpl, (short)3);
            }
            throw applicationException;
        }
        catch (Exception exception) {
            Debug.output(0, exception);
            ApplicationException applicationException = new ApplicationException(exception.getMessage(), null);
            if (this.use_interceptors && clientRequestInfoImpl != null) {
                SystemExceptionHelper.insert(clientRequestInfoImpl.received_exception, new UNKNOWN(exception.getMessage(), 1, CompletionStatus.COMPLETED_MAYBE));
                clientRequestInfoImpl.received_exception_id = applicationException.getId();
                clientRequestInfoImpl.reply_status = 1;
                clientRequestInfoImpl.setReplyServiceContexts(new ServiceContext[0]);
                this.invokeInterceptors(clientRequestInfoImpl, (short)3);
            }
            throw applicationException;
        }
        if (replyInputStream != null) {
            try {
                Enumeration enumeration;
                try {
                    object3 = replyInputStream.result();
                    if (this.use_interceptors && clientRequestInfoImpl != null) {
                        object2 = replyInputStream.getHeader();
                        if (((ReplyHeader_1_0)object2).reply_status.value() == 0) {
                            clientRequestInfoImpl.reply_status = 0;
                            clientRequestInfoImpl.setReplyServiceContexts(((ReplyHeader_1_0)object2).service_context);
                            if (requestOutputStream.getRequest() == null) {
                                InterceptorManager interceptorManager = ((ORB)this.orb).getInterceptorManager();
                                clientRequestInfoImpl.current = interceptorManager.getCurrent();
                                clientRequestInfoImpl.reply_is = replyInputStream;
                                this.invokeInterceptors(clientRequestInfoImpl, (short)2);
                            } else {
                                requestOutputStream.getRequest().setInfo(clientRequestInfoImpl);
                            }
                        }
                    }
                    object2 = object3;
                    java.lang.Object var12_22 = null;
                }
                catch (RemarshalException remarshalException) {
                    this.pending_replies_sync.waitOnBarrier();
                    throw remarshalException;
                }
                catch (org.omg.PortableServer.ForwardRequest forwardRequest) {
                    if (this.use_interceptors && clientRequestInfoImpl != null) {
                        clientRequestInfoImpl.reply_status = (short)4;
                        clientRequestInfoImpl.setReplyServiceContexts(replyInputStream.getHeader().service_context);
                        clientRequestInfoImpl.forward_reference = forwardRequest.forward_reference;
                        clientRequestInfoImpl.reply_is = replyInputStream;
                        this.invokeInterceptors(clientRequestInfoImpl, (short)4);
                    }
                    if (this.iorOriginal == null) {
                        this.iorOriginal = this.ior;
                        this.piorOriginal = this.pior;
                    }
                    Debug.output(3, "LocationForward");
                    this.pending_replies_sync.lockBarrier();
                    enumeration = this.pending_replies.elements();
                }
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        this.unbind();
                        this.bind(this.orb.object_to_string(forwardRequest.forward_reference));
                        this.pending_replies_sync.openBarrier();
                        throw new RemarshalException();
                    }
                    ReplyInputStream replyInputStream2 = (ReplyInputStream)enumeration.nextElement();
                    replyInputStream2.retry();
                }
                catch (SystemException systemException) {
                    if (this.use_interceptors && clientRequestInfoImpl != null) {
                        clientRequestInfoImpl.reply_status = 1;
                        if (replyInputStream.getHeader() != null) {
                            clientRequestInfoImpl.setReplyServiceContexts(replyInputStream.getHeader().service_context);
                        } else {
                            clientRequestInfoImpl.setReplyServiceContexts(new ServiceContext[0]);
                        }
                        SystemExceptionHelper.insert(clientRequestInfoImpl.received_exception, systemException);
                        try {
                            clientRequestInfoImpl.received_exception_id = SystemExceptionHelper.type(systemException).id();
                        }
                        catch (BadKind badKind) {
                            Debug.output(2, badKind);
                        }
                        clientRequestInfoImpl.reply_is = replyInputStream;
                        this.invokeInterceptors(clientRequestInfoImpl, (short)3);
                    }
                    throw systemException;
                }
                catch (ApplicationException applicationException) {
                    if (this.use_interceptors && clientRequestInfoImpl != null) {
                        clientRequestInfoImpl.reply_status = (short)2;
                        clientRequestInfoImpl.setReplyServiceContexts(replyInputStream.getHeader().service_context);
                        clientRequestInfoImpl.received_exception_id = applicationException.getId();
                        replyInputStream.mark(0);
                        try {
                            ApplicationExceptionHelper.insert(clientRequestInfoImpl.received_exception, applicationException);
                        }
                        catch (Exception exception) {
                            Debug.output(2, exception);
                            SystemExceptionHelper.insert(clientRequestInfoImpl.received_exception, new UNKNOWN(exception.getMessage()));
                        }
                        try {
                            replyInputStream.reset();
                        }
                        catch (Exception exception) {
                            Debug.output(2, exception);
                        }
                        clientRequestInfoImpl.reply_is = replyInputStream;
                        this.invokeInterceptors(clientRequestInfoImpl, (short)3);
                    }
                    throw applicationException;
                }
                this.pending_replies.remove(replyInputStream);
            }
            catch (Throwable throwable) {
                java.lang.Object var12_23 = null;
                this.pending_replies.remove(replyInputStream);
                if (!this.location_forward_permanent) {
                    this.fallback();
                }
                throw throwable;
            }
            if (!this.location_forward_permanent) {
                this.fallback();
            }
            return object2;
        }
        if (this.use_interceptors && clientRequestInfoImpl != null) {
            clientRequestInfoImpl.reply_status = 0;
            clientRequestInfoImpl.setReplyServiceContexts(new ServiceContext[0]);
            this.invokeInterceptors(clientRequestInfoImpl, (short)4);
        }
        if (!this.location_forward_permanent) {
            this.fallback();
        }
        return null;
    }

    public void invokeInterceptors(ClientRequestInfoImpl clientRequestInfoImpl, short s) throws RemarshalException {
        ClientInterceptorIterator clientInterceptorIterator = ((ORB)this.orb).getInterceptorManager().getClientIterator();
        try {
            clientInterceptorIterator.iterate(clientRequestInfoImpl, s);
        }
        catch (ForwardRequest forwardRequest) {
            this.iorOriginal = this.ior;
            this.piorOriginal = this.pior;
            this.location_forward_permanent = forwardRequest.permanent;
            this.unbind();
            this.bind(this.orb.object_to_string(forwardRequest.forward));
            throw new RemarshalException();
        }
        catch (UserException userException) {
            Debug.output(16385, userException);
        }
    }

    public boolean is_a(Object object, String string) {
        if (this.pior.getTypeId().equals(string)) {
            return true;
        }
        String[] stringArray = ((ObjectImpl)object)._ids();
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_is_a", true);
                outputStream.write_string(string);
                InputStream inputStream = this.invoke(object, outputStream);
                return inputStream.read_boolean();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            catch (ApplicationException applicationException) {
                String string2 = applicationException.getId();
                throw new RuntimeException("Unexpected exception " + string2);
            }
            break;
        }
    }

    public boolean is_equivalent(Object object, Object object2) {
        return object.toString().equals(object2.toString());
    }

    public boolean is_local(Object object) {
        return this.poa != null;
    }

    public boolean is_nil() {
        return this.ior.type_id.equals("") && this.ior.profiles.length == 0;
    }

    /*
     * Loose catch block
     */
    public boolean non_existent(Object object) {
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_non_existent", true);
                InputStream inputStream = this.invoke(object, outputStream);
                return inputStream.read_boolean();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            break;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public org.omg.CORBA.ORB orb(Object object) {
        return this.orb;
    }

    public synchronized void release(Object object) {
    }

    public void releaseReply(Object object, InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized org.omg.CORBA.Request request(Object object, String string) {
        if (!this.bound) {
            this.bind();
        }
        return new Request(object, this.orb, this.connection, this.object_key, string);
    }

    public synchronized OutputStream request(Object object, String string, boolean bl) {
        if (!this.bound) {
            this.bind();
        }
        this.ctx = this.connection.addCodeSetContext(this.ctx, this.pior);
        RequestOutputStream requestOutputStream = new RequestOutputStream(this.orb, this.connection.getId(), string, bl, this.object_key, this.ctx, this.use_interceptors);
        requestOutputStream.setCodeSet(this.connection.TCS, this.connection.TCSW);
        return requestOutputStream;
    }

    public void servant_postinvoke(Object object, ServantObject servantObject) {
        ((ORB)this.orb).getPOACurrent()._removeContext(this.context);
    }

    public ServantObject servant_preinvoke(Object object, String string, Class clazz) {
        if (this.poa != null) {
            java.lang.Object object2;
            if (((ORB)this.orb).isApplet()) {
                Debug.output(1, "Unproxyfying IOR:");
                object2 = (Delegate)((ObjectImpl)object)._get_delegate();
                ParsedIOR parsedIOR = new ParsedIOR(((ORB)this.orb).unproxyfy(((Delegate)object2).getIOR()));
                ((Delegate)object2).setIOR(parsedIOR.getIOR());
                ((Delegate)object2).set_adport_and_key(parsedIOR.getProfileBody().host + ":" + parsedIOR.getProfileBody().port, parsedIOR.getProfileBody().object_key);
                ((ObjectImpl)object)._set_delegate((org.omg.CORBA.portable.Delegate)object2);
            }
            try {
                object2 = new ServantObject();
                ((ServantObject)object2).servant = this.poa.reference_to_servant(object);
                if (!clazz.isInstance(((ServantObject)object2).servant)) {
                    return null;
                }
                this.context = new LocalInvocationContext(this.orb, this.poa, this.getObjectId(), (Servant)((ServantObject)object2).servant);
                ((ORB)this.orb).getPOACurrent()._addContext(this.context, Thread.currentThread());
                return object2;
            }
            catch (Throwable throwable) {
                Debug.output(2, throwable);
            }
        }
        return null;
    }

    public void set_adport_and_key(String string, byte[] byArray) {
        this.adport = string;
        this.object_key = byArray;
    }

    public void setIOR(IOR iOR) {
        this.ior = iOR;
        this.pior = new ParsedIOR(this.ior);
        this.iorOriginal = null;
        this.piorOriginal = null;
    }

    public String toString() {
        if (this.piorOriginal != null) {
            return this.piorOriginal.ior_str;
        }
        return this.pior.ior_str;
    }

    public String toString(Object object) {
        return this.toString();
    }

    public String typeId() {
        return this.ior.type_id;
    }

    private void fallback() {
        Debug.output(2, "Delegate: falling back to original IOR");
        this.unbind();
        this.ior = this.iorOriginal;
        this.pior = this.piorOriginal;
        this.iorOriginal = null;
        this.piorOriginal = null;
        this.location_forward_permanent = true;
        this._init();
    }

    public void initInterceptors() {
        this.use_interceptors = ((ORB)this.orb).hasClientRequestInterceptors();
    }

    private class Barrier {
        private boolean is_open = true;

        private Barrier() {
        }

        public synchronized void waitOnBarrier() {
            while (!this.is_open) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void lockBarrier() {
            this.is_open = false;
        }

        public synchronized void openBarrier() {
            this.is_open = true;
            this.notifyAll();
        }
    }
}

