/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CIHashtable;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RetryException;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;

public class HTTPResponse
implements GlobalConstants,
HTTPClientModuleConstants {
    private HTTPClientModule[] modules;
    private int timeout;
    private Request request = null;
    private Response response = null;
    private HttpOutputStream out_stream = null;
    private InputStream inp_stream;
    private int StatusCode;
    private String ReasonLine;
    private String Version;
    private URI OriginalURI = null;
    private URI EffectiveURI = null;
    private CIHashtable Headers = null;
    private CIHashtable Trailers = null;
    private int ContentLength = -1;
    private byte[] Data = null;
    private boolean initialized = false;
    private boolean got_trailers = false;
    private boolean aborted = false;
    private String method = null;
    private boolean handle_trailers = false;
    private boolean trailers_handled = false;

    HTTPResponse(HTTPClientModule[] hTTPClientModuleArray, int n, Request request) {
        this.modules = hTTPClientModuleArray;
        this.timeout = n;
        try {
            this.OriginalURI = new URI(request.getConnection().getProtocol(), request.getConnection().getHost(), request.getConnection().getPort(), request.getRequestURI());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.method = request.getMethod();
    }

    void set(Request request, Response response) {
        this.request = request;
        this.response = response;
        response.http_resp = this;
        response.timeout = this.timeout;
        this.aborted = response.final_resp;
    }

    void set(Request request, HttpOutputStream httpOutputStream) {
        this.request = request;
        this.out_stream = httpOutputStream;
    }

    public final int getStatusCode() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.StatusCode;
    }

    public final String getReasonLine() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.ReasonLine;
    }

    public final String getVersion() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Version;
    }

    public final String getServer() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.getHeader("Server");
    }

    public final URI getOriginalURI() {
        return this.OriginalURI;
    }

    public final URL getEffectiveURL() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI.toURL();
        }
        return null;
    }

    public final URI getEffectiveURI() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI;
        }
        return this.OriginalURI;
    }

    public String getHeader(String string) throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return (String)this.Headers.get(string.trim());
    }

    public int getHeaderAsInt(String string) throws IOException, ModuleException, NumberFormatException {
        return Integer.parseInt(this.getHeader(string));
    }

    public Date getHeaderAsDate(String string) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1) {
            string2 = string2 + " GMT";
        }
        try {
            date = new Date(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public Enumeration listHeaders() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Headers.keys();
    }

    public String getTrailer(String string) throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(string.trim());
    }

    public int getTrailerAsInt(String string) throws IOException, ModuleException, NumberFormatException {
        return Integer.parseInt(this.getTrailer(string));
    }

    public Date getTrailerAsDate(String string) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String string2 = this.getTrailer(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1) {
            string2 = string2 + " GMT";
        }
        try {
            date = new Date(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public Enumeration listTrailers() throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return this.Trailers.keys();
    }

    public synchronized byte[] getData() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                if (GlobalConstants.DebugResp) {
                    System.err.println("HResp: (\"" + this.method + " " + this.OriginalURI.getPath() + "\")");
                    System.err.print("       ");
                    iOException.printStackTrace();
                }
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw iOException;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public synchronized InputStream getInputStream() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        this.getData();
        return new ByteArrayInputStream(this.Data);
    }

    public String toString() {
        if (!this.initialized) {
            try {
                this.handleResponse();
            }
            catch (Exception exception) {
                if (GlobalConstants.DebugResp && !(exception instanceof InterruptedIOException)) {
                    System.err.println("HResp: (\"" + this.method + " " + this.OriginalURI.getPath() + "\")");
                    System.err.print("       ");
                    exception.printStackTrace();
                }
                return "Failed to read headers: " + exception;
            }
        }
        String string = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer(this.Version);
        stringBuffer.append(' ');
        stringBuffer.append(this.StatusCode);
        stringBuffer.append(' ');
        stringBuffer.append(this.ReasonLine);
        stringBuffer.append(string);
        if (this.EffectiveURI != null) {
            stringBuffer.append("Effective-URI: ");
            stringBuffer.append(this.EffectiveURI);
            stringBuffer.append(string);
        }
        Enumeration enumeration = this.Headers.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(this.Headers.get(string2));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    HTTPClientModule[] getModules() {
        return this.modules;
    }

    synchronized boolean handleResponse() throws IOException, ModuleException {
        block22: {
            int n;
            if (this.initialized) {
                return false;
            }
            if (this.out_stream != null) {
                this.response = this.out_stream.getResponse();
                this.response.http_resp = this;
                this.out_stream = null;
            }
            block9: while (true) {
                int n2 = 0;
                while (n2 < this.modules.length && !this.aborted) {
                    try {
                        this.modules[n2].responsePhase1Handler(this.response, this.request);
                    }
                    catch (RetryException retryException) {
                        if (retryException.restart) continue block9;
                        throw retryException;
                    }
                    ++n2;
                }
                int n3 = 0;
                while (n3 < this.modules.length && !this.aborted) {
                    n = this.modules[n3].responsePhase2Handler(this.response, this.request);
                    switch (n) {
                        case 10: {
                            break;
                        }
                        case 11: {
                            n3 = -1;
                            continue block9;
                        }
                        case 12: {
                            break block22;
                        }
                        case 13: 
                        case 15: {
                            this.response.getInputStream().close();
                            if (this.handle_trailers) {
                                this.invokeTrailerHandlers(true);
                            }
                            if (this.request.internal_subrequest) {
                                return true;
                            }
                            this.request.getConnection().handleRequest(this.request, this, this.response, true);
                            if (!this.initialized) {
                                n3 = -1;
                                continue block9;
                            }
                            break block22;
                        }
                        case 14: 
                        case 16: {
                            this.response.getInputStream().close();
                            if (this.handle_trailers) {
                                this.invokeTrailerHandlers(true);
                            }
                            if (this.request.internal_subrequest) {
                                return true;
                            }
                            this.request.getConnection().handleRequest(this.request, this, this.response, false);
                            n3 = -1;
                            continue block9;
                        }
                        default: {
                            throw new Error("HTTPClient Internal Error: invalid status " + n + " returned by module " + this.modules[n3].getClass().getName());
                        }
                    }
                    ++n3;
                }
                break;
            }
            n = 0;
            while (n < this.modules.length && !this.aborted) {
                this.modules[n].responsePhase3Handler(this.response, this.request);
                ++n;
            }
        }
        this.response.getStatusCode();
        if (!this.request.internal_subrequest) {
            this.init(this.response);
        }
        if (this.handle_trailers) {
            this.invokeTrailerHandlers(false);
        }
        return false;
    }

    void init(Response response) {
        if (this.initialized) {
            return;
        }
        this.StatusCode = response.StatusCode;
        this.ReasonLine = response.ReasonLine;
        this.Version = response.Version;
        this.EffectiveURI = response.EffectiveURI;
        this.ContentLength = response.ContentLength;
        this.Headers = response.Headers;
        this.inp_stream = response.inp_stream;
        this.Data = response.Data;
        this.initialized = true;
    }

    void invokeTrailerHandlers(boolean bl) throws IOException, ModuleException {
        if (this.trailers_handled) {
            return;
        }
        if (!bl && !this.initialized) {
            this.handle_trailers = true;
            return;
        }
        int n = 0;
        while (n < this.modules.length && !this.aborted) {
            this.modules[n].trailerHandler(this.response, this.request);
            ++n;
        }
        this.trailers_handled = true;
    }

    void markAborted() {
        this.aborted = true;
    }

    private synchronized void getTrailers() throws IOException, ModuleException {
        if (this.got_trailers) {
            return;
        }
        if (!this.initialized) {
            this.handleResponse();
        }
        this.response.getTrailer("Any");
        this.Trailers = this.response.Trailers;
        this.got_trailers = true;
        this.invokeTrailerHandlers(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readResponseData(InputStream inputStream) throws IOException, ModuleException {
        if (this.ContentLength == 0) {
            return;
        }
        if (this.Data == null) {
            this.Data = new byte[0];
        }
        int n = this.Data.length;
        try {
            try {
                if (this.getHeader("Content-Length") != null) {
                    int n2 = 0;
                    this.Data = new byte[this.ContentLength];
                    while ((n2 = inputStream.read(this.Data, n += n2, this.ContentLength - n)) != -1 && n + n2 < this.ContentLength) {
                    }
                } else {
                    int n3 = 1000;
                    int n4 = 0;
                    do {
                        this.Data = Util.resizeArray(this.Data, (n += n4) + n3);
                    } while ((n4 = inputStream.read(this.Data, n, n3)) != -1);
                    this.Data = Util.resizeArray(this.Data, n);
                }
            }
            catch (IOException iOException) {
                this.Data = Util.resizeArray(this.Data, n);
                throw iOException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return;
    }

    int getTimeout() {
        return this.timeout;
    }
}

