/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;

class AuthorizationModule
implements HTTPClientModule,
GlobalConstants {
    private static Hashtable proxy_cntxt_list = new Hashtable();
    private int auth_lst_idx = 0;
    private int prxy_lst_idx = 0;
    private int auth_scm_idx = 0;
    private int prxy_scm_idx = 0;
    private AuthorizationInfo auth_sent = null;
    private AuthorizationInfo prxy_sent = null;
    private boolean auth_from_4xx = false;
    private boolean prxy_from_4xx = false;
    private int num_tries = 0;

    AuthorizationModule() {
    }

    public int requestHandler(Request request, Response[] responseArray) {
        block17: {
            AuthorizationInfo authorizationInfo;
            block19: {
                AuthorizationHandler authorizationHandler;
                block16: {
                    block18: {
                        Hashtable hashtable;
                        HTTPConnection hTTPConnection = request.getConnection();
                        authorizationHandler = AuthorizationInfo.getAuthHandler();
                        if (hTTPConnection.getProxyHost() == null || this.prxy_from_4xx || (authorizationInfo = (AuthorizationInfo)(hashtable = Util.getList(proxy_cntxt_list, request.getConnection().getContext())).get(hTTPConnection.getProxyHost() + ":" + hTTPConnection.getProxyPort())) == null) break block16;
                        if (authorizationHandler == null) break block18;
                        try {
                            authorizationInfo = authorizationHandler.fixupAuthInfo(authorizationInfo, request, null, null);
                        }
                        catch (AuthSchemeNotImplException authSchemeNotImplException) {
                            break block16;
                        }
                        if (authorizationInfo == null) break block16;
                    }
                    NVPair[] nVPairArray = request.getHeaders();
                    int n = 0;
                    while (n < nVPairArray.length) {
                        if (nVPairArray[n].getName().equalsIgnoreCase("Proxy-Authorization")) break;
                        ++n;
                    }
                    if (n == nVPairArray.length) {
                        nVPairArray = Util.resizeArray(nVPairArray, n + 1);
                        request.setHeaders(nVPairArray);
                    }
                    nVPairArray[n] = new NVPair("Proxy-Authorization", authorizationInfo.toString());
                    this.prxy_sent = authorizationInfo;
                    this.prxy_from_4xx = false;
                    if (GlobalConstants.DebugMods) {
                        System.err.println("AuthM: Preemptively sending Proxy-Authorization '" + authorizationInfo + "'");
                    }
                }
                if (this.auth_from_4xx || (authorizationInfo = AuthorizationInfo.findBest(request)) == null) break block17;
                if (authorizationHandler == null) break block19;
                try {
                    authorizationInfo = authorizationHandler.fixupAuthInfo(authorizationInfo, request, null, null);
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    break block17;
                }
                if (authorizationInfo == null) break block17;
            }
            NVPair[] nVPairArray = request.getHeaders();
            int n = 0;
            while (n < nVPairArray.length) {
                if (nVPairArray[n].getName().equalsIgnoreCase("Authorization")) break;
                ++n;
            }
            if (n == nVPairArray.length) {
                nVPairArray = Util.resizeArray(nVPairArray, n + 1);
                request.setHeaders(nVPairArray);
            }
            nVPairArray[n] = new NVPair("Authorization", authorizationInfo.toString());
            this.auth_sent = authorizationInfo;
            this.auth_from_4xx = false;
            if (GlobalConstants.DebugMods) {
                System.err.println("AuthM: Preemptively sending Authorization '" + authorizationInfo + "'");
            }
        }
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) throws IOException {
        if (response.getStatusCode() != 401 && response.getStatusCode() != 407) {
            if (this.auth_sent != null && this.auth_from_4xx) {
                try {
                    AuthorizationInfo.getAuthorization(this.auth_sent, roRequest, response, false).addPath(roRequest.getRequestURI());
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    // empty catch block
                }
            }
            this.num_tries = 0;
        }
        this.auth_from_4xx = false;
        this.prxy_from_4xx = false;
        if (response.getHeader("WWW-Authenticate") == null) {
            this.auth_lst_idx = 0;
            this.auth_scm_idx = 0;
        }
        if (response.getHeader("Proxy-Authenticate") == null) {
            this.prxy_lst_idx = 0;
            this.prxy_scm_idx = 0;
        }
    }

    public int responsePhase2Handler(Response response, Request request) throws IOException, AuthSchemeNotImplException {
        AuthorizationHandler authorizationHandler = AuthorizationInfo.getAuthHandler();
        if (authorizationHandler != null) {
            authorizationHandler.handleAuthHeaders(response, request, this.auth_sent, this.prxy_sent);
        }
        int n = response.getStatusCode();
        switch (n) {
            case 401: 
            case 407: {
                ++this.num_tries;
                if (this.num_tries > 10) {
                    throw new ProtocolException("Bug in authorization handling: server refused the given info 10 times");
                }
                if (GlobalConstants.DebugMods) {
                    System.err.println("AuthM: Handling status: " + n + " " + response.getReasonLine());
                }
                int[] nArray = new int[]{this.auth_lst_idx, this.auth_scm_idx};
                this.auth_sent = this.setAuthHeaders(response.getHeader("WWW-Authenticate"), request, response, "Authorization", nArray, this.auth_sent);
                if (this.auth_sent != null) {
                    this.auth_from_4xx = true;
                }
                this.auth_lst_idx = nArray[0];
                this.auth_scm_idx = nArray[1];
                nArray[0] = this.prxy_lst_idx;
                nArray[1] = this.prxy_scm_idx;
                this.prxy_sent = this.setAuthHeaders(response.getHeader("Proxy-Authenticate"), request, response, "Proxy-Authorization", nArray, this.prxy_sent);
                if (this.prxy_sent != null) {
                    this.prxy_from_4xx = true;
                }
                this.prxy_lst_idx = nArray[0];
                this.prxy_scm_idx = nArray[1];
                if (this.prxy_sent != null) {
                    HTTPConnection hTTPConnection = request.getConnection();
                    Util.getList(proxy_cntxt_list, hTTPConnection.getContext()).put(hTTPConnection.getProxyHost() + ":" + hTTPConnection.getProxyPort(), this.prxy_sent);
                }
                if (request.getStream() == null && (this.auth_sent != null || this.prxy_sent != null)) {
                    try {
                        response.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (GlobalConstants.DebugMods) {
                        if (this.auth_sent != null) {
                            System.err.println("AuthM: Resending request with Authorization '" + this.auth_sent + "'");
                        } else {
                            System.err.println("AuthM: Resending request with Proxy-Authorization '" + this.prxy_sent + "'");
                        }
                    }
                    return 13;
                }
                if (this.auth_sent == null && this.prxy_sent == null && response.getHeader("WWW-Authenticate") == null && response.getHeader("Proxy-Authenticate") == null) {
                    if (response.getStatusCode() == 401) {
                        throw new ProtocolException("Missing WWW-Authenticate header");
                    }
                    throw new ProtocolException("Missing Proxy-Authenticate header");
                }
                if (GlobalConstants.DebugMods) {
                    if (request.getStream() == null) {
                        System.err.println("AuthM: status " + n + " not " + "handled - request has an output " + "stream");
                    } else {
                        System.err.println("AuthM: No Auth Info found - status " + n + " not handled");
                    }
                }
                return 10;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) {
    }

    public void trailerHandler(Response response, RoRequest roRequest) throws IOException {
        AuthorizationHandler authorizationHandler = AuthorizationInfo.getAuthHandler();
        if (authorizationHandler != null) {
            authorizationHandler.handleAuthTrailers(response, roRequest, this.auth_sent, this.prxy_sent);
        }
    }

    private AuthorizationInfo setAuthHeaders(String string, Request request, RoResponse roResponse, String string2, int[] nArray, AuthorizationInfo authorizationInfo) throws ProtocolException, AuthSchemeNotImplException {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        AuthorizationInfo[] authorizationInfoArray = AuthorizationInfo.parseAuthString(string, request, roResponse);
        if (GlobalConstants.DebugMods) {
            System.err.println("AuthM: parsed " + authorizationInfoArray.length + " challenges:");
            n2 = 0;
            while (n2 < authorizationInfoArray.length) {
                System.err.println("AuthM: Challenge " + authorizationInfoArray[n2]);
                ++n2;
            }
        }
        if (authorizationInfo != null && authorizationInfo.getScheme().equalsIgnoreCase("Basic")) {
            n2 = 0;
            while (n2 < authorizationInfoArray.length) {
                if (authorizationInfo.getRealm().equals(authorizationInfoArray[n2].getRealm()) && authorizationInfo.getScheme().equalsIgnoreCase(authorizationInfoArray[n2].getScheme())) {
                    AuthorizationInfo.removeAuthorization(authorizationInfo, request.getConnection().getContext());
                }
                ++n2;
            }
        }
        AuthorizationInfo authorizationInfo2 = null;
        AuthorizationHandler authorizationHandler = AuthorizationInfo.getAuthHandler();
        while (authorizationInfo2 == null && nArray[0] != -1) {
            authorizationInfo2 = AuthorizationInfo.getAuthorization(authorizationInfoArray[nArray[0]], request, roResponse, false);
            if (authorizationHandler != null && authorizationInfo2 != null) {
                authorizationInfo2 = authorizationHandler.fixupAuthInfo(authorizationInfo2, request, authorizationInfoArray[nArray[0]], roResponse);
            }
            if ((nArray[0] = nArray[0] + 1) != authorizationInfoArray.length) continue;
            nArray[0] = -1;
        }
        if (authorizationInfo2 == null) {
            n = 0;
            while (n < authorizationInfoArray.length) {
                try {
                    authorizationInfo2 = AuthorizationInfo.queryAuthHandler(authorizationInfoArray[nArray[1]], request, roResponse);
                    break;
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    if (n == authorizationInfoArray.length - 1) {
                        throw authSchemeNotImplException;
                    }
                    ++n;
                }
            }
            nArray[1] = nArray[1] + 1;
            if (nArray[1] == authorizationInfoArray.length) {
                nArray[1] = 0;
            }
        }
        if (authorizationInfo2 == null) {
            return null;
        }
        NVPair[] nVPairArray = request.getHeaders();
        n = 0;
        while (n < nVPairArray.length) {
            if (nVPairArray[n].getName().equalsIgnoreCase(string2)) break;
            ++n;
        }
        if (n == nVPairArray.length) {
            nVPairArray = Util.resizeArray(nVPairArray, n + 1);
            request.setHeaders(nVPairArray);
        }
        nVPairArray[n] = new NVPair(string2, authorizationInfo2.toString());
        return authorizationInfo2;
    }
}

