/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class LongType
extends IntType {
    public LongType(int n) {
        super(n);
    }

    public Object clone() {
        return new LongType(IdlSymbol.new_num());
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public String typeName() {
        return "int";
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        if (this.unsigned) {
            return 5;
        }
        return 3;
    }

    public String toString() {
        return this.typeName();
    }

    public String signature() {
        return "I";
    }

    public String holderName() {
        return "org.omg.CORBA.IntHolder";
    }

    public String printReadExpression(String string) {
        if (this.unsigned) {
            return string + ".read_ulong()";
        }
        return string + ".read_long()";
    }

    public String printWriteStatement(String string, String string2) {
        if (this.unsigned) {
            return string2 + ".write_ulong(" + string + ");";
        }
        return string2 + ".write_long(" + string + ");";
    }

    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ulong";
        }
        return "insert_long";
    }

    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ulong";
        }
        return "extract_long";
    }
}

