/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.ArrayDeclarator;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

class ArrayTypeSpec
extends TemplateTypeSpec {
    ArrayDeclarator declarator = null;
    String typename = null;
    String dimensionStr = "";
    int[] dims;
    int my_dim = 0;
    String typeSig;
    private boolean written = false;

    public ArrayTypeSpec(int n, TypeSpec typeSpec, ArrayDeclarator arrayDeclarator, String string) {
        super(n);
        this.declarator = arrayDeclarator;
        this.name = this.declarator.name();
        this.set_token(arrayDeclarator.get_token());
        this.setEnclosingSymbol(arrayDeclarator.getEnclosingSymbol());
        this.pack_name = string;
        this.type_spec = typeSpec;
    }

    private ArrayTypeSpec(int n, TypeSpec typeSpec, ArrayDeclarator arrayDeclarator, String string, int n2) {
        super(n);
        this.declarator = arrayDeclarator;
        this.name = this.declarator.name();
        this.dims = this.declarator.dimensions();
        this.set_token(arrayDeclarator.get_token());
        this.setEnclosingSymbol(arrayDeclarator.getEnclosingSymbol());
        this.pack_name = string;
        this.my_dim = n2;
        this.type_spec = this.dims.length > n2 + 1 ? new ArrayTypeSpec(IdlSymbol.new_num(), typeSpec, arrayDeclarator, string, n2 + 1) : typeSpec;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2;
        while (n3 < this.dims.length) {
            stringBuffer.append("[]");
            ++n3;
        }
        this.dimensionStr = stringBuffer.toString();
    }

    public Object clone() {
        System.out.println("clone");
        ArrayTypeSpec arrayTypeSpec = new ArrayTypeSpec(IdlSymbol.new_num(), this.type_spec, this.declarator, this.pack_name);
        arrayTypeSpec.dims = this.dims;
        arrayTypeSpec.included = this.included;
        arrayTypeSpec.typedefd = this.typedefd;
        arrayTypeSpec.inhibitionFlag = this.inhibitionFlag;
        arrayTypeSpec.dims = this.dims;
        arrayTypeSpec.my_dim = this.my_dim;
        arrayTypeSpec.dimensionStr = this.dimensionStr;
        arrayTypeSpec.set_token(this.get_token());
        arrayTypeSpec.setEnclosingSymbol(this.getEnclosingSymbol());
        return arrayTypeSpec;
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public TypeSpec elementTypeSpec() {
        TypeSpec typeSpec = this.type_spec;
        while (!(typeSpec instanceof ArrayTypeSpec) && typeSpec.type_spec != null) {
            typeSpec = typeSpec.type_spec;
        }
        return typeSpec;
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        throw new RuntimeException("ArrayTypeSpec.setPackage should never be called!");
    }

    public void markTypeDefd() {
        this.typedefd = true;
    }

    public String typeName() {
        return this.elementTypeName() + "[]";
    }

    public String elementTypeName() {
        if (this.type_spec.typeSpec() instanceof ScopedName) {
            return ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec().typeName();
        }
        return this.type_spec.typeName();
    }

    public String typeSignature() {
        if (this.typeSig == null) {
            this.typeSig = this.typeName();
            while (this.typeSig.endsWith("[]")) {
                this.typeSig = "[" + this.typeSig.substring(0, this.typeSig.length() - 3);
            }
        }
        return this.typeSig;
    }

    public void parse() throws ParseException {
        Serializable serializable;
        this.dims = this.declarator.dimensions();
        if (this.dims.length > 1) {
            this.type_spec = new ArrayTypeSpec(IdlSymbol.new_num(), this.type_spec, this.declarator, this.pack_name, 1);
        } else if (this.type_spec.typeSpec() instanceof ScopedName && (serializable = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec()) != null) {
            this.type_spec = serializable;
        }
        serializable = new StringBuffer();
        int n = this.my_dim;
        while (n < this.dims.length) {
            ((StringBuffer)serializable).append("[]");
            ++n;
        }
        this.dimensionStr = ((StringBuffer)serializable).toString();
        try {
            if (!this.typedefd) {
                NameTable.define(this.full_name(), "type");
            }
            if (!NameTable.defined(this.typeName(), "type")) {
                NameTable.define(this.typeName(), "type");
            }
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.fatal_error("Name " + this.full_name() + " already defined.", null);
        }
    }

    public String getTypeCodeExpression() {
        String string = "org.omg.CORBA.ORB.init().create_array_tc(" + this.dims[this.my_dim] + "," + this.elementTypeSpec().getTypeCodeExpression() + ")";
        return string;
    }

    public String helperName() {
        return ScopedName.unPseudoName(this.full_name()) + "Helper";
    }

    public String holderName() {
        return ScopedName.unPseudoName(this.full_name()) + "Holder";
    }

    public String className() {
        String string;
        String string2 = this.pack_name.length() > 0 ? ScopedName.unPseudoName(this.pack_name + "." + this.name) : ScopedName.unPseudoName(this.name);
        if (string2.indexOf(46) > 0) {
            this.pack_name = string2.substring(0, string2.lastIndexOf(46));
            string = string2.substring(string2.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            string = string2;
        }
        return string;
    }

    int length() {
        return this.dims[this.my_dim];
    }

    public String printReadExpression(String string) {
        return this.helperName() + ".read(" + string + ")";
    }

    public String printReadStatement(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.typeName();
        stringBuffer.append(string + " = new " + string3.substring(0, string3.indexOf("[")));
        stringBuffer.append("[" + this.length() + "]");
        stringBuffer.append(string3.substring(string3.indexOf(93) + 1) + ";\n");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String string4 = this.elementTypeSpec().printReadExpression(string2);
            stringBuffer.append("\t\t" + string4.substring(0, string4.indexOf("(")) + "_array(" + string + ",0," + this.length() + ");");
        } else {
            char c = 'i';
            String string5 = "";
            if (string.endsWith("]")) {
                c = (char)(string.charAt(string.length() - 2) + '\u0001');
                string5 = "    ";
            }
            stringBuffer.append("\t\t" + string5 + "for(int " + c + "=0;" + c + "<" + this.length() + ";" + c + "++)\n\t\t" + string5 + "{\n");
            stringBuffer.append("\t\t\t" + string5 + this.elementTypeSpec().printReadStatement(string + "[" + c + "]", string2) + "\n");
            stringBuffer.append("\t\t" + string5 + "}\n");
        }
        return stringBuffer.toString();
    }

    public String printWriteStatement(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = this.typeName();
        stringBuffer.append("\t\tif(" + string + ".length<" + this.length() + ")\n\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect array size \"+" + string + ".length+\", expecting " + this.length() + "\");\n");
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String string4 = this.elementTypeSpec().printWriteStatement(string, string2);
            stringBuffer.append("\t\t" + string4.substring(0, string4.indexOf("(")) + "_array(" + string + ",0," + this.length() + ");");
        } else {
            char c = 'i';
            String string5 = "";
            if (string.endsWith("]")) {
                c = (char)(string.charAt(string.length() - 2) + '\u0001');
                string5 = "    ";
            }
            stringBuffer.append("\t\t" + string5 + "for( int " + c + "=0; " + c + "<" + this.length() + ";" + c + "++)\n\t\t" + string5 + "{\n");
            stringBuffer.append("\t\t\t" + string5 + this.elementTypeSpec().printWriteStatement(string + "[" + c + "]", string2) + "\n");
            stringBuffer.append("\t\t" + string5 + "}\n");
        }
        return stringBuffer.toString();
    }

    private void printHolderClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        String string2 = this.typeName();
        printWriter.println("public class " + string + "Holder");
        printWriter.println("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\tpublic " + string2 + " value;");
        printWriter.println("\tpublic " + string + "Holder()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder(" + string2 + " initial)\n\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + string + "Helper.type();");
        printWriter.println("\t}");
        TypeSpec typeSpec = this.type_spec;
        printWriter.println("\tpublic void _read(org.omg.CORBA.portable.InputStream _in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + string + "Helper.read(_in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(org.omg.CORBA.portable.OutputStream _out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + string + "Helper.write(_out,value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        String string2;
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        String string3 = this.typeName();
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        printWriter.println("\tpublic " + string + "Helper ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        TypeSpec.printHelperClassMethods(string, printWriter, string3);
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + string3 + " read(org.omg.CORBA.portable.InputStream _in)");
        printWriter.println("\t{");
        printWriter.print("\t\t" + string3 + " result = new " + string3.substring(0, string3.indexOf(93)) + this.length() + "]");
        printWriter.println(string3.substring(string3.indexOf(93)) + "; // " + string3);
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            string2 = this.elementTypeSpec().printReadExpression("_in");
            printWriter.println("\t\t" + string2.substring(0, string2.indexOf("(")) + "_array(result,0," + this.length() + ");");
        } else {
            printWriter.println("\t\tfor( int i = 0; i < " + this.length() + "; i++ )\n\t\t{");
            printWriter.println("\t\t\t" + this.elementTypeSpec().printReadStatement("result[i]", "_in") + "\n\t\t}");
        }
        printWriter.println("\t\treturn result;");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream out, " + string3 + " s)");
        printWriter.println("\t{");
        if (this.declarator.dimensions()[0] != 0) {
            printWriter.println("\t\tif( s.length != " + this.declarator.dimensions()[0] + ")");
            printWriter.println("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect array size\");");
        }
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            string2 = this.elementTypeSpec().printWriteStatement("s", "out");
            printWriter.println("\t\t" + string2.substring(0, string2.indexOf("(")) + "_array(s,0," + this.length() + ");");
        } else {
            printWriter.println("\t\tfor( int i = 0; i < s.length; i++ )\n\t\t{");
            printWriter.println("\t\t\t" + this.elementTypeSpec().printWriteStatement("s[i]", "out") + "\n\t\t}");
        }
        printWriter.println("\t}");
        printWriter.println("}");
    }

    public void print(PrintWriter printWriter) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        try {
            if (!this.written && this.typedefd) {
                String string = this.className();
                String string2 = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
                File file = new File(string2);
                if (!file.exists() && !file.mkdirs()) {
                    parser.fatal_error("Unable to create " + string2, null);
                }
                String string3 = string + "Holder.java";
                PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
                this.printHolderClass(string, printWriter2);
                printWriter2.close();
                string3 = string + "Helper.java";
                printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
                this.printHelperClass(string, printWriter2);
                printWriter2.close();
                this.written = true;
            }
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }

    public String toString() {
        return this.typeName();
    }
}

