/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.jacorb.orb.connection.ClientConnection;
import org.jacorb.orb.connection.CloseConnectionException;
import org.jacorb.util.Debug;

public class ReplyReceptor
extends Thread {
    private Boolean stopped = new Boolean(false);
    private Boolean onceOnly = new Boolean(false);
    ClientConnection master;

    public ReplyReceptor(ClientConnection clientConnection) {
        this.master = clientConnection;
        try {
            this.setDaemon(true);
        }
        catch (SecurityException securityException) {
            Debug.output(3, "Could not start reply receptor as daemon, running as a regular thread.");
        }
        this.setName("JacORB ReplyReceptor Thread for connection " + this.master.getInfo());
        this.start();
    }

    public ReplyReceptor(ClientConnection clientConnection, boolean bl) {
        this(clientConnection);
        this.oneRun(bl);
    }

    public void stopReceptor() {
        Boolean bl = this.stopped;
        synchronized (bl) {
            this.stopped = new Boolean(true);
            this.interrupt();
        }
    }

    private void oneRun(boolean bl) {
        Boolean bl2 = this.onceOnly;
        synchronized (bl2) {
            this.onceOnly = new Boolean(bl);
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void run() {
        while (!this.isStopped()) {
            try {
                this.master.receiveReply();
            }
            catch (CloseConnectionException closeConnectionException) {
                Debug.output(3, "ReplyReceptor: CloseConnectionException");
                this.master.closeConnection();
                break;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isStopped()) break;
                Debug.output(3, interruptedIOException);
                break;
            }
            catch (IOException iOException) {
                if (this.isStopped()) break;
                Debug.output(3, iOException);
                this.master.closeConnection();
                break;
            }
            catch (Exception exception) {
                Debug.output(3, exception);
            }
            if (this.onceOnly.booleanValue()) break;
        }
    }
}

