/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.RoResponse;
import java.io.IOException;

class VerifyMD5
implements HashVerifier,
GlobalConstants {
    RoResponse resp;

    public VerifyMD5(RoResponse roResponse) {
        this.resp = roResponse;
    }

    public void verifyHash(byte[] byArray, long l) throws IOException {
        String string;
        try {
            string = this.resp.getHeader("Content-MD5");
            if (string == null) {
                string = this.resp.getTrailer("Content-MD5");
            }
        }
        catch (IOException iOException) {
            return;
        }
        if (string == null) {
            return;
        }
        string = string.trim();
        byte[] byArray2 = new byte[string.length()];
        string.getBytes(0, byArray2.length, byArray2, 0);
        byArray2 = Codecs.base64Decode(byArray2);
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                throw new IOException("MD5-Digest mismatch: expected " + VerifyMD5.hex(byArray2) + " but calculated " + VerifyMD5.hex(byArray));
            }
            ++n;
        }
        if (GlobalConstants.DebugMods) {
            System.err.println("CMD5M: hash successfully verified");
        }
    }

    private static String hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Character.forDigit(byArray[n] >>> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[n] & 0xF, 16));
            stringBuffer.append(':');
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

