/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;

class RedirectionModule
implements HTTPClientModule,
GlobalConstants {
    private static Hashtable perm_redir_cntxt_list = new Hashtable();
    private int level = 0;
    private URI lastURI = null;

    RedirectionModule() {
    }

    public int requestHandler(Request request, Response[] responseArray) {
        URI uRI;
        HTTPConnection hTTPConnection = request.getConnection();
        try {
            uRI = new URI(hTTPConnection.getProtocol(), hTTPConnection.getHost(), hTTPConnection.getPort(), request.getRequestURI());
        }
        catch (ParseException parseException) {
            throw new Error("HTTPClient Internal Error: unexpected exception '" + parseException + "'");
        }
        Hashtable hashtable = Util.getList(perm_redir_cntxt_list, request.getConnection().getContext());
        URI uRI2 = (URI)hashtable.get(uRI);
        if (uRI2 != null) {
            String string = uRI2.getPath();
            request.setRequestURI(string);
            try {
                this.lastURI = new URI(uRI2, string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (GlobalConstants.DebugMods) {
                System.err.println("RdirM: matched request in permanent redirection list - redoing request to " + this.lastURI);
            }
            if (!this.sameServer(hTTPConnection, uRI2)) {
                try {
                    hTTPConnection = new HTTPConnection(uRI2.toURL());
                }
                catch (Exception exception) {
                    throw new Error("HTTPClient Internal Error: unexpected exception '" + exception + "'");
                }
                hTTPConnection.setContext(request.getConnection().getContext());
                request.setConnection(hTTPConnection);
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) throws IOException {
        int n = response.getStatusCode();
        if ((n < 301 || n > 307 || n == 304) && this.lastURI != null) {
            response.setEffectiveURI(this.lastURI);
        }
    }

    public int responsePhase2Handler(Response response, Request request) throws IOException {
        int n = response.getStatusCode();
        switch (n) {
            case 302: {
                if (GlobalConstants.DebugMods) {
                    System.err.println("RdirM: Received status: " + n + " " + response.getReasonLine() + " - treating as 303");
                }
                n = 303;
            }
            case 301: 
            case 303: 
            case 307: {
                if (GlobalConstants.DebugMods) {
                    System.err.println("RdirM: Handling status: " + n + " " + response.getReasonLine());
                }
                if (!request.getMethod().equals("GET") && !request.getMethod().equals("HEAD") && n != 303) {
                    if (GlobalConstants.DebugMods) {
                        System.err.println("RdirM: not redirected because method is neither HEAD nor GET");
                    }
                    if (n == 301 && response.getHeader("Location") != null) {
                        RedirectionModule.update_perm_redir_list(request, this.resLocHdr(response.getHeader("Location"), request));
                    }
                    response.setEffectiveURI(this.lastURI);
                    return 10;
                }
            }
            case 305: 
            case 306: {
                String string;
                HTTPConnection hTTPConnection;
                if (GlobalConstants.DebugMods && (n == 305 || n == 306)) {
                    System.err.println("RdirM: Handling status: " + n + " " + response.getReasonLine());
                }
                if (n == 305 && request.getConnection().getProxyHost() != null) {
                    if (GlobalConstants.DebugMods) {
                        System.err.println("RdirM: 305 ignored because a proxy is already in use");
                    }
                    response.setEffectiveURI(this.lastURI);
                    return 10;
                }
                if (this.level == 15 || response.getHeader("Location") == null) {
                    if (GlobalConstants.DebugMods) {
                        if (this.level == 15) {
                            System.err.println("RdirM: not redirected because of too many levels of redirection");
                        } else {
                            System.err.println("RdirM: not redirected because no Location header was present");
                        }
                    }
                    response.setEffectiveURI(this.lastURI);
                    return 10;
                }
                ++this.level;
                URI uRI = this.resLocHdr(response.getHeader("Location"), request);
                if (request.getStream() != null && (n == 306 || n == 305)) {
                    return 10;
                }
                boolean bl = false;
                if (n == 305) {
                    hTTPConnection = new HTTPConnection(request.getConnection().getProtocol(), request.getConnection().getHost(), request.getConnection().getPort());
                    hTTPConnection.setCurrentProxy(uRI.getHost(), uRI.getPort());
                    hTTPConnection.setContext(request.getConnection().getContext());
                    bl = true;
                    string = request.getRequestURI();
                    request.setMethod("GET");
                    request.setData(null);
                    request.setStream(null);
                } else {
                    if (n == 306) {
                        return 10;
                    }
                    if (this.sameServer(request.getConnection(), uRI)) {
                        hTTPConnection = request.getConnection();
                        string = uRI.getPath();
                    } else {
                        try {
                            hTTPConnection = new HTTPConnection(uRI.toURL());
                            string = uRI.getPath();
                        }
                        catch (Exception exception) {
                            if (request.getConnection().getProxyHost() == null || !uRI.getScheme().equalsIgnoreCase("ftp")) {
                                return 10;
                            }
                            hTTPConnection = new HTTPConnection("http", request.getConnection().getProxyHost(), request.getConnection().getProxyPort());
                            hTTPConnection.setCurrentProxy(null, 0);
                            string = uRI.toExternalForm();
                        }
                        hTTPConnection.setContext(request.getConnection().getContext());
                        bl = true;
                    }
                    if (n == 303 && !request.getMethod().equals("HEAD")) {
                        request.setMethod("GET");
                        request.setData(null);
                        request.setStream(null);
                    } else if (n == 301) {
                        try {
                            RedirectionModule.update_perm_redir_list(request, new URI(uRI, string));
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    NVPair[] nVPairArray = request.getHeaders();
                    int n2 = 0;
                    while (n2 < nVPairArray.length) {
                        if (nVPairArray[n2].getName().equalsIgnoreCase("Referer")) {
                            HTTPConnection hTTPConnection2 = request.getConnection();
                            nVPairArray[n2] = new NVPair("Referer", hTTPConnection2 + request.getRequestURI());
                            break;
                        }
                        ++n2;
                    }
                }
                request.setConnection(hTTPConnection);
                request.setRequestURI(string);
                try {
                    response.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n != 305 && n != 306) {
                    try {
                        this.lastURI = new URI(uRI, string);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (GlobalConstants.DebugMods) {
                        System.err.println("RdirM: request redirected to " + this.lastURI + " using method " + request.getMethod());
                    }
                } else if (GlobalConstants.DebugMods) {
                    System.err.println("RdirM: resending request using proxy " + hTTPConnection.getProxyHost() + ":" + hTTPConnection.getProxyPort());
                }
                if (bl) {
                    return 15;
                }
                return 13;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) {
    }

    public void trailerHandler(Response response, RoRequest roRequest) {
    }

    private static void update_perm_redir_list(RoRequest roRequest, URI uRI) {
        HTTPConnection hTTPConnection = roRequest.getConnection();
        URI uRI2 = null;
        try {
            uRI2 = new URI(hTTPConnection.getProtocol(), hTTPConnection.getHost(), hTTPConnection.getPort(), roRequest.getRequestURI());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (!uRI2.equals(uRI)) {
            Hashtable hashtable = Util.getList(perm_redir_cntxt_list, hTTPConnection.getContext());
            hashtable.put(uRI2, uRI);
        }
    }

    private URI resLocHdr(String string, RoRequest roRequest) throws ProtocolException {
        try {
            return new URI(string);
        }
        catch (ParseException parseException) {
            try {
                URI uRI = new URI(roRequest.getConnection().getProtocol(), roRequest.getConnection().getHost(), roRequest.getConnection().getPort(), roRequest.getRequestURI());
                return new URI(uRI, string);
            }
            catch (ParseException parseException2) {
                throw new ProtocolException("Malformed URL in Location header: " + string);
            }
        }
    }

    private boolean sameServer(HTTPConnection hTTPConnection, URI uRI) {
        if (!uRI.getScheme().equalsIgnoreCase(hTTPConnection.getProtocol())) {
            return false;
        }
        if (!uRI.getHost().equalsIgnoreCase(hTTPConnection.getHost())) {
            return false;
        }
        return uRI.getPort() == hTTPConnection.getPort();
    }
}

