/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.CIHashtable;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpHeaderElement;
import HTTPClient.HttpOutputStream;
import HTTPClient.IdempotentSequence;
import HTTPClient.LinkedList;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.SocksClient;
import HTTPClient.SocksException;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.URI;
import HTTPClient.Util;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;

public class HTTPConnection
implements GlobalConstants,
HTTPClientModuleConstants {
    public static final String version = "RPT-HTTPClient/0.3-2";
    private static final Object dflt_context;
    private Object Context = null;
    private int Protocol;
    int ServerProtocolVersion;
    boolean ServProtVersKnown;
    private String RequestProtocolVersion;
    private static boolean no_chunked;
    private static boolean force_1_0;
    private String Host;
    private int Port;
    private String Proxy_Host = null;
    private int Proxy_Port;
    private static String Default_Proxy_Host;
    private static int Default_Proxy_Port;
    private static CIHashtable non_proxy_host_list;
    private static Vector non_proxy_dom_list;
    private static Vector non_proxy_addr_list;
    private static Vector non_proxy_mask_list;
    private SocksClient Socks_client = null;
    private static SocksClient Default_Socks_client;
    private StreamDemultiplexor input_demux = null;
    LinkedList DemuxList = new LinkedList();
    private LinkedList RequestList = new LinkedList();
    private boolean DoesKeepAlive = false;
    private boolean KeepAliveUnknown = true;
    private int KeepAliveReqMax = -1;
    private int KeepAliveReqLeft;
    private static boolean NeverPipeline;
    private static boolean NoKeepAlives;
    private static boolean haveMSLargeWritesBug;
    private static int DefaultTimeout;
    private int Timeout;
    private NVPair[] DefaultHeaders = new NVPair[0];
    private static Vector DefaultModuleList;
    private Vector ModuleList;
    private static boolean DefaultAllowUI;
    private boolean AllowUI;
    private Response early_stall = null;
    private Response late_stall = null;
    private Response prev_resp = null;
    private boolean output_finished = true;

    public HTTPConnection(Applet applet) throws ProtocolNotSuppException {
        this(applet.getCodeBase().getProtocol(), applet.getCodeBase().getHost(), applet.getCodeBase().getPort());
    }

    public HTTPConnection(String string) {
        this.Setup(0, string, 80);
    }

    public HTTPConnection(String string, int n) {
        this.Setup(0, string, n);
    }

    public HTTPConnection(String string, String string2, int n) throws ProtocolNotSuppException {
        string = string.trim().toLowerCase();
        if (!string.equals("http")) {
            throw new ProtocolNotSuppException("Unsupported protocol '" + string + "'");
        }
        if (string.equals("http")) {
            this.Setup(0, string2, n);
        } else if (string.equals("https")) {
            this.Setup(1, string2, n);
        } else if (string.equals("shttp")) {
            this.Setup(2, string2, n);
        } else if (string.equals("http-ng")) {
            this.Setup(3, string2, n);
        }
    }

    public HTTPConnection(URL uRL) throws ProtocolNotSuppException {
        this(uRL.getProtocol(), uRL.getHost(), uRL.getPort());
    }

    private void Setup(int n, String string, int n2) {
        this.Protocol = n;
        this.Host = string.trim().toLowerCase();
        this.Port = n2;
        if (this.Port == -1) {
            this.Port = URI.defaultPort(this.getProtocol());
        }
        if (Default_Proxy_Host != null && !this.matchNonProxy(this.Host)) {
            this.setCurrentProxy(Default_Proxy_Host, Default_Proxy_Port);
        } else {
            this.setCurrentProxy(null, 0);
        }
        this.Socks_client = Default_Socks_client;
        this.Timeout = DefaultTimeout;
        this.ModuleList = (Vector)DefaultModuleList.clone();
        this.AllowUI = DefaultAllowUI;
        if (NoKeepAlives) {
            this.setDefaultHeaders(new NVPair[]{new NVPair("Connection", "close")});
        }
    }

    private boolean matchNonProxy(String string) {
        InetAddress[] inetAddressArray;
        if (non_proxy_host_list.get(string) != null) {
            return true;
        }
        int n = 0;
        while (n < non_proxy_dom_list.size()) {
            if (string.endsWith((String)non_proxy_dom_list.elementAt(n))) {
                return true;
            }
            ++n;
        }
        if (non_proxy_addr_list.size() == 0) {
            return false;
        }
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        int n2 = 0;
        while (n2 < non_proxy_addr_list.size()) {
            byte[] byArray = (byte[])non_proxy_addr_list.elementAt(n2);
            byte[] byArray2 = (byte[])non_proxy_mask_list.elementAt(n2);
            int n3 = 0;
            while (n3 < inetAddressArray.length) {
                block11: {
                    byte[] byArray3 = inetAddressArray[n3].getAddress();
                    if (byArray3.length == byArray.length) {
                        int n4 = 0;
                        while (n4 < byArray3.length) {
                            if ((byArray3[n4] & byArray2[n4]) == (byArray[n4] & byArray2[n4])) {
                                ++n4;
                                continue;
                            }
                            break block11;
                        }
                        return true;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public HTTPResponse Head(String string) throws IOException, ModuleException {
        return this.Head(string, (String)null, null);
    }

    public HTTPResponse Head(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Head(string, nVPairArray, null);
    }

    public HTTPResponse Head(String string, NVPair[] nVPairArray, NVPair[] nVPairArray2) throws IOException, ModuleException {
        String string2 = this.stripRef(string);
        String string3 = Codecs.nv2query(nVPairArray);
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + "?" + string3;
        }
        return this.setupRequest("HEAD", string2, nVPairArray2, null, null);
    }

    public HTTPResponse Head(String string, String string2) throws IOException, ModuleException {
        return this.Head(string, string2, null);
    }

    public HTTPResponse Head(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        String string3 = this.stripRef(string);
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + "?" + Codecs.URLEncode(string2);
        }
        return this.setupRequest("HEAD", string3, nVPairArray, null, null);
    }

    public HTTPResponse Get(String string) throws IOException, ModuleException {
        return this.Get(string, (String)null, null);
    }

    public HTTPResponse Get(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Get(string, nVPairArray, null);
    }

    public HTTPResponse Get(String string, NVPair[] nVPairArray, NVPair[] nVPairArray2) throws IOException, ModuleException {
        String string2 = this.stripRef(string);
        String string3 = Codecs.nv2query(nVPairArray);
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + "?" + string3;
        }
        return this.setupRequest("GET", string2, nVPairArray2, null, null);
    }

    public HTTPResponse Get(String string, String string2) throws IOException, ModuleException {
        return this.Get(string, string2, null);
    }

    public HTTPResponse Get(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        String string3 = this.stripRef(string);
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + "?" + Codecs.URLEncode(string2);
        }
        return this.setupRequest("GET", string3, nVPairArray, null, null);
    }

    public HTTPResponse Post(String string) throws IOException, ModuleException {
        return this.Post(string, (byte[])null, null);
    }

    public HTTPResponse Post(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        NVPair[] nVPairArray2 = new NVPair[]{new NVPair("Content-type", "application/x-www-form-urlencoded")};
        return this.Post(string, Codecs.nv2query(nVPairArray), nVPairArray2);
    }

    public HTTPResponse Post(String string, NVPair[] nVPairArray, NVPair[] nVPairArray2) throws IOException, ModuleException {
        int n = 0;
        while (n < nVPairArray2.length) {
            if (nVPairArray2[n].getName().equalsIgnoreCase("Content-type")) break;
            ++n;
        }
        if (n == nVPairArray2.length) {
            nVPairArray2 = Util.resizeArray(nVPairArray2, n + 1);
            nVPairArray2[n] = new NVPair("Content-type", "application/x-www-form-urlencoded");
        }
        return this.Post(string, Codecs.nv2query(nVPairArray), nVPairArray2);
    }

    public HTTPResponse Post(String string, String string2) throws IOException, ModuleException {
        return this.Post(string, string2, null);
    }

    public HTTPResponse Post(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        byte[] byArray = null;
        if (string2 != null && string2.length() > 0) {
            byArray = new byte[string2.length()];
            string2.getBytes(0, string2.length(), byArray, 0);
        }
        return this.Post(string, byArray, nVPairArray);
    }

    public HTTPResponse Post(String string, byte[] byArray) throws IOException, ModuleException {
        return this.Post(string, byArray, null);
    }

    public HTTPResponse Post(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return this.setupRequest("POST", this.stripRef(string), nVPairArray, byArray, null);
    }

    public HTTPResponse Post(String string, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        return this.Post(string, httpOutputStream, null);
    }

    public HTTPResponse Post(String string, HttpOutputStream httpOutputStream, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("POST", this.stripRef(string), nVPairArray, null, httpOutputStream);
    }

    public HTTPResponse Put(String string, String string2) throws IOException, ModuleException {
        return this.Put(string, string2, null);
    }

    public HTTPResponse Put(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        byte[] byArray = null;
        if (string2 != null) {
            byArray = new byte[string2.length()];
            string2.getBytes(0, string2.length(), byArray, 0);
        }
        return this.Put(string, byArray, nVPairArray);
    }

    public HTTPResponse Put(String string, byte[] byArray) throws IOException, ModuleException {
        return this.Put(string, byArray, null);
    }

    public HTTPResponse Put(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return this.setupRequest("PUT", this.stripRef(string), nVPairArray, byArray, null);
    }

    public HTTPResponse Put(String string, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        return this.Put(string, httpOutputStream, null);
    }

    public HTTPResponse Put(String string, HttpOutputStream httpOutputStream, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("PUT", this.stripRef(string), nVPairArray, null, httpOutputStream);
    }

    public HTTPResponse Options(String string) throws IOException, ModuleException {
        return this.Options(string, null, (byte[])null);
    }

    public HTTPResponse Options(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Options(string, nVPairArray, (byte[])null);
    }

    public HTTPResponse Options(String string, NVPair[] nVPairArray, byte[] byArray) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(string), nVPairArray, byArray, null);
    }

    public HTTPResponse Options(String string, NVPair[] nVPairArray, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(string), nVPairArray, null, httpOutputStream);
    }

    public HTTPResponse Delete(String string) throws IOException, ModuleException {
        return this.Delete(string, null);
    }

    public HTTPResponse Delete(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("DELETE", this.stripRef(string), nVPairArray, null, null);
    }

    public HTTPResponse Trace(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("TRACE", this.stripRef(string), nVPairArray, null, null);
    }

    public HTTPResponse Trace(String string) throws IOException, ModuleException {
        return this.Trace(string, null);
    }

    public HTTPResponse ExtensionMethod(String string, String string2, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest(string.trim(), this.stripRef(string2), nVPairArray, byArray, null);
    }

    public HTTPResponse ExtensionMethod(String string, String string2, HttpOutputStream httpOutputStream, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest(string.trim(), this.stripRef(string2), nVPairArray, null, httpOutputStream);
    }

    public void stop() {
        Request request = (Request)this.RequestList.enumerate();
        while (request != null) {
            request.aborted = true;
            request = (Request)this.RequestList.next();
        }
        StreamDemultiplexor streamDemultiplexor = (StreamDemultiplexor)this.DemuxList.enumerate();
        while (streamDemultiplexor != null) {
            streamDemultiplexor.abort();
            streamDemultiplexor = (StreamDemultiplexor)this.DemuxList.next();
        }
    }

    public void setDefaultHeaders(NVPair[] nVPairArray) {
        Object object;
        int n = nVPairArray == null ? 0 : nVPairArray.length;
        NVPair[] nVPairArray2 = new NVPair[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            object = nVPairArray[n2].getName().trim();
            if (!((String)object).equalsIgnoreCase("Content-length") && !((String)object).equalsIgnoreCase("Host")) {
                nVPairArray2[n3++] = nVPairArray[n2];
            }
            ++n2;
        }
        if (n3 < n) {
            nVPairArray2 = Util.resizeArray(this.DefaultHeaders, n3);
        }
        object = this.DefaultHeaders;
        synchronized (object) {
            this.DefaultHeaders = nVPairArray2;
        }
    }

    public NVPair[] getDefaultHeaders() {
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (nVPairArray) {
            NVPair[] nVPairArray2 = new NVPair[this.DefaultHeaders.length];
            System.arraycopy(this.DefaultHeaders, 0, nVPairArray2, 0, nVPairArray2.length);
            NVPair[] nVPairArray3 = nVPairArray2;
            return nVPairArray3;
        }
    }

    public String getProtocol() {
        switch (this.Protocol) {
            case 0: {
                return "http";
            }
            case 1: {
                return "https";
            }
            case 2: {
                return "shttp";
            }
            case 3: {
                return "http-ng";
            }
        }
        throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
    }

    public String getHost() {
        return this.Host;
    }

    public int getPort() {
        return this.Port;
    }

    public String getProxyHost() {
        return this.Proxy_Host;
    }

    public int getProxyPort() {
        return this.Proxy_Port;
    }

    public boolean isCompatibleWith(URI uRI) {
        if (!uRI.getScheme().equals(this.getProtocol()) || !uRI.getHost().equalsIgnoreCase(this.Host)) {
            return false;
        }
        int n = uRI.getPort();
        if (n == -1) {
            n = URI.defaultPort(uRI.getScheme());
        }
        return n == this.Port;
    }

    public void setRawMode(boolean bl) {
        String[] stringArray = new String[]{"HTTPClient.CookieModule", "HTTPClient.RedirectionModule", "HTTPClient.AuthorizationModule", "HTTPClient.DefaultModule", "HTTPClient.TransferEncodingModule", "HTTPClient.ContentMD5Module", "HTTPClient.ContentEncodingModule"};
        int n = 0;
        while (n < stringArray.length) {
            try {
                if (bl) {
                    this.removeModule(Class.forName(stringArray[n]));
                } else {
                    this.addModule(Class.forName(stringArray[n]), -1);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n;
        }
    }

    public static void setDefaultTimeout(int n) {
        DefaultTimeout = n;
    }

    public static int getDefaultTimeout() {
        return DefaultTimeout;
    }

    public void setTimeout(int n) {
        this.Timeout = n;
    }

    public int getTimeout() {
        return this.Timeout;
    }

    public void setAllowUserInteraction(boolean bl) {
        this.AllowUI = bl;
    }

    public boolean getAllowUserInteraction() {
        return this.AllowUI;
    }

    public static void setDefaultAllowUserInteraction(boolean bl) {
        DefaultAllowUI = bl;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return DefaultAllowUI;
    }

    public static Class[] getDefaultModules() {
        Vector vector = DefaultModuleList;
        synchronized (vector) {
            Object[] objectArray = new Class[DefaultModuleList.size()];
            DefaultModuleList.copyInto(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    public static boolean addDefaultModule(Class clazz, int n) {
        Object object;
        try {
            object = (HTTPClientModule)clazz.newInstance();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        object = DefaultModuleList;
        synchronized (object) {
            if (DefaultModuleList.contains(clazz)) {
                boolean bl = false;
                return bl;
            }
            if (n < 0) {
                DefaultModuleList.insertElementAt(clazz, DefaultModuleList.size() + n + 1);
            } else {
                DefaultModuleList.insertElementAt(clazz, n);
            }
        }
        if (GlobalConstants.DebugConn) {
            System.err.println("Conn:  Added module " + clazz.getName() + " to default list");
        }
        return true;
    }

    public static boolean removeDefaultModule(Class clazz) {
        boolean bl = DefaultModuleList.removeElement(clazz);
        if (GlobalConstants.DebugConn && bl) {
            System.err.println("Conn:  Removed module " + clazz.getName() + " from default list");
        }
        return bl;
    }

    public Class[] getModules() {
        Vector vector = this.ModuleList;
        synchronized (vector) {
            Object[] objectArray = new Class[this.ModuleList.size()];
            this.ModuleList.copyInto(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    public boolean addModule(Class clazz, int n) {
        Object object;
        try {
            object = (HTTPClientModule)clazz.newInstance();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        object = this.ModuleList;
        synchronized (object) {
            if (this.ModuleList.contains(clazz)) {
                boolean bl = false;
                return bl;
            }
            if (n < 0) {
                this.ModuleList.insertElementAt(clazz, this.ModuleList.size() + n + 1);
            } else {
                this.ModuleList.insertElementAt(clazz, n);
            }
        }
        return true;
    }

    public boolean removeModule(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.ModuleList.removeElement(clazz);
    }

    public void setContext(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Context must be non-null");
        }
        if (this.Context != null) {
            throw new RuntimeException("Context already set");
        }
        this.Context = object;
    }

    public Object getContext() {
        if (this.Context != null) {
            return this.Context;
        }
        return dflt_context;
    }

    static Object getDefaultContext() {
        return dflt_context;
    }

    public void addDigestAuthorization(String string, String string2, String string3) {
        AuthorizationInfo.addDigestAuthorization(this.Host, this.Port, string, string2, string3, this.getContext());
    }

    public void addBasicAuthorization(String string, String string2, String string3) {
        AuthorizationInfo.addBasicAuthorization(this.Host, this.Port, string, string2, string3, this.getContext());
    }

    public static void setProxyServer(String string, int n) {
        if (string == null || string.trim().length() == 0) {
            Default_Proxy_Host = null;
        } else {
            Default_Proxy_Host = string.trim().toLowerCase();
            Default_Proxy_Port = n;
        }
    }

    public synchronized void setCurrentProxy(String string, int n) {
        if (string == null || string.trim().length() == 0) {
            this.Proxy_Host = null;
        } else {
            this.Proxy_Host = string.trim().toLowerCase();
            this.Proxy_Port = n <= 0 ? 80 : n;
        }
        switch (this.Protocol) {
            case 0: 
            case 1: {
                if (force_1_0) {
                    this.ServerProtocolVersion = 65536;
                    this.ServProtVersKnown = true;
                    this.RequestProtocolVersion = "HTTP/1.0";
                    break;
                }
                this.ServerProtocolVersion = 65537;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "HTTP/1.1";
                break;
            }
            case 3: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "";
                break;
            }
            case 2: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "Secure-HTTP/1.3";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        this.KeepAliveUnknown = true;
        this.DoesKeepAlive = false;
        this.input_demux = null;
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    public static void dontProxyFor(String string) throws ParseException {
        int n;
        byte[] byArray;
        byte[] byArray2;
        if ((string = string.trim().toLowerCase()).charAt(0) == '.') {
            if (!non_proxy_dom_list.contains(string)) {
                non_proxy_dom_list.addElement(string);
            }
            return;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isDigit(string.charAt(n2)) && string.charAt(n2) != '.' && string.charAt(n2) != '/') {
                non_proxy_host_list.put(string, "");
                return;
            }
            ++n2;
        }
        int n3 = string.indexOf(47);
        if (n3 != -1) {
            byArray2 = HTTPConnection.string2arr(string.substring(0, n3));
            if (byArray2.length != (byArray = HTTPConnection.string2arr(string.substring(n3 + 1))).length) {
                throw new ParseException("length of IP-address (" + byArray2.length + ") != length of netmask (" + byArray.length + ")");
            }
        } else {
            byArray2 = HTTPConnection.string2arr(string);
            byArray = new byte[byArray2.length];
            n = 0;
            while (n < byArray.length) {
                byArray[n] = -1;
                ++n;
            }
        }
        n = 0;
        while (n < non_proxy_addr_list.size()) {
            block12: {
                byte[] byArray3 = (byte[])non_proxy_addr_list.elementAt(n);
                byte[] byArray4 = (byte[])non_proxy_mask_list.elementAt(n);
                if (byArray3.length == byArray2.length) {
                    int n4 = 0;
                    while (n4 < byArray3.length) {
                        if ((byArray2[n4] & byArray4[n4]) == (byArray3[n4] & byArray4[n4]) && byArray4[n4] == byArray[n4]) {
                            ++n4;
                            continue;
                        }
                        break block12;
                    }
                    return;
                }
            }
            ++n;
        }
        non_proxy_addr_list.addElement(byArray2);
        non_proxy_mask_list.addElement(byArray);
    }

    public static void dontProxyFor(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                if (stringArray[n] != null) {
                    HTTPConnection.dontProxyFor(stringArray[n]);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            ++n;
        }
    }

    public static boolean doProxyFor(String string) throws ParseException {
        int n;
        byte[] byArray;
        byte[] byArray2;
        if ((string = string.trim().toLowerCase()).charAt(0) == '.') {
            return non_proxy_dom_list.removeElement(string);
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (!Character.isDigit(string.charAt(n2)) && string.charAt(n2) != '.' && string.charAt(n2) != '/') {
                return non_proxy_host_list.remove(string) != null;
            }
            ++n2;
        }
        int n3 = string.indexOf(47);
        if (n3 != -1) {
            byArray2 = HTTPConnection.string2arr(string.substring(0, n3));
            if (byArray2.length != (byArray = HTTPConnection.string2arr(string.substring(n3 + 1))).length) {
                throw new ParseException("length of IP-address (" + byArray2.length + ") != length of netmask (" + byArray.length + ")");
            }
        } else {
            byArray2 = HTTPConnection.string2arr(string);
            byArray = new byte[byArray2.length];
            n = 0;
            while (n < byArray.length) {
                byArray[n] = -1;
                ++n;
            }
        }
        n = 0;
        while (n < non_proxy_addr_list.size()) {
            block11: {
                byte[] byArray3 = (byte[])non_proxy_addr_list.elementAt(n);
                byte[] byArray4 = (byte[])non_proxy_mask_list.elementAt(n);
                if (byArray3.length == byArray2.length) {
                    int n4 = 0;
                    while (n4 < byArray3.length) {
                        if ((byArray2[n4] & byArray4[n4]) == (byArray3[n4] & byArray4[n4]) && byArray4[n4] == byArray[n4]) {
                            ++n4;
                            continue;
                        }
                        break block11;
                    }
                    non_proxy_addr_list.removeElementAt(n);
                    non_proxy_mask_list.removeElementAt(n);
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private static byte[] string2arr(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '.') {
                ++n;
            }
            ++n2;
        }
        byte[] byArray = new byte[n + 1];
        n = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            if (cArray[n4] == '.') {
                byArray[n] = (byte)Integer.parseInt(string.substring(n3, n4));
                ++n;
                n3 = n4 + 1;
            }
            ++n4;
        }
        byArray[n] = (byte)Integer.parseInt(string.substring(n3));
        return byArray;
    }

    public static void setSocksServer(String string) {
        HTTPConnection.setSocksServer(string, 1080);
    }

    public static void setSocksServer(String string, int n) {
        if (n <= 0) {
            n = 1080;
        }
        Default_Socks_client = string == null || string.length() == 0 ? null : new SocksClient(string, n);
    }

    public static void setSocksServer(String string, int n, int n2) throws SocksException {
        if (n <= 0) {
            n = 1080;
        }
        Default_Socks_client = string == null || string.length() == 0 ? null : new SocksClient(string, n, n2);
    }

    private final String stripRef(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    private HTTPResponse setupRequest(String string, String string2, NVPair[] nVPairArray, byte[] byArray, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        Request request = new Request(this, string, string2, this.mergedHeaders(nVPairArray), byArray, httpOutputStream, this.AllowUI);
        this.RequestList.addToEnd(request);
        try {
            HTTPResponse hTTPResponse = new HTTPResponse(this.gen_mod_insts(), this.Timeout, request);
            this.handleRequest(request, hTTPResponse, null, true);
            HTTPResponse hTTPResponse2 = hTTPResponse;
            Object var10_9 = null;
            this.RequestList.remove(request);
            return hTTPResponse2;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.RequestList.remove(request);
            throw throwable;
        }
    }

    private NVPair[] mergedHeaders(NVPair[] nVPairArray) {
        NVPair[] nVPairArray2;
        int n;
        int n2 = nVPairArray != null ? nVPairArray.length : 0;
        NVPair[] nVPairArray3 = this.DefaultHeaders;
        synchronized (nVPairArray3) {
            n = this.DefaultHeaders != null ? this.DefaultHeaders.length : 0;
            nVPairArray2 = new NVPair[n2 + n];
            System.arraycopy(this.DefaultHeaders, 0, nVPairArray2, 0, n);
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            String string = nVPairArray[n4].getName().trim();
            if (!string.equalsIgnoreCase("Content-length") && !string.equalsIgnoreCase("Host")) {
                int n5 = 0;
                while (n5 < n3) {
                    if (nVPairArray2[n5].getName().trim().equalsIgnoreCase(string)) break;
                    ++n5;
                }
                nVPairArray2[n5] = nVPairArray[n4];
                if (n5 == n3) {
                    ++n3;
                }
            }
            ++n4;
        }
        if (n3 < nVPairArray2.length) {
            nVPairArray2 = Util.resizeArray(nVPairArray2, n3);
        }
        return nVPairArray2;
    }

    private HTTPClientModule[] gen_mod_insts() {
        Vector vector = this.ModuleList;
        synchronized (vector) {
            Object object;
            HTTPClientModule[] hTTPClientModuleArray = new HTTPClientModule[this.ModuleList.size()];
            int n = 0;
            while (n < this.ModuleList.size()) {
                object = (Class)this.ModuleList.elementAt(n);
                try {
                    hTTPClientModuleArray[n] = (HTTPClientModule)((Class)object).newInstance();
                }
                catch (Exception exception) {
                    throw new Error("HTTPClient Internal Error: could not create instance of " + ((Class)object).getName() + " -\n" + exception);
                }
                ++n;
            }
            object = hTTPClientModuleArray;
            return object;
        }
    }

    void handleRequest(Request request, HTTPResponse hTTPResponse, Response response, boolean bl) throws IOException, ModuleException {
        int n;
        Response[] responseArray = new Response[]{response};
        HTTPClientModule[] hTTPClientModuleArray = hTTPResponse.getModules();
        if (bl) {
            int n2 = 0;
            block10: while (n2 < hTTPClientModuleArray.length) {
                n = hTTPClientModuleArray[n2].requestHandler(request, responseArray);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        n2 = -1;
                        break;
                    }
                    case 2: {
                        break block10;
                    }
                    case 3: 
                    case 4: {
                        if (responseArray[0] == null) {
                            throw new Error("HTTPClient Internal Error: no response returned by module " + hTTPClientModuleArray[n2].getClass().getName());
                        }
                        hTTPResponse.set(request, responseArray[0]);
                        if (request.getStream() != null) {
                            request.getStream().ignoreData(request);
                        }
                        if (request.internal_subrequest) {
                            return;
                        }
                        if (n == 3) {
                            hTTPResponse.handleResponse();
                        } else {
                            hTTPResponse.init(responseArray[0]);
                        }
                        return;
                    }
                    case 5: {
                        if (request.internal_subrequest) {
                            return;
                        }
                        request.getConnection().handleRequest(request, hTTPResponse, responseArray[0], true);
                        return;
                    }
                    case 6: {
                        if (request.internal_subrequest) {
                            return;
                        }
                        request.getConnection().handleRequest(request, hTTPResponse, responseArray[0], false);
                        return;
                    }
                    default: {
                        throw new Error("HTTPClient Internal Error: invalid status " + n + " returned by module " + hTTPClientModuleArray[n2].getClass().getName());
                    }
                }
                ++n2;
            }
        }
        if (request.internal_subrequest) {
            return;
        }
        if (request.getStream() != null && request.getStream().getLength() == -1) {
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || no_chunked) {
                request.getStream().goAhead(request, null, hTTPResponse.getTimeout());
                hTTPResponse.set(request, request.getStream());
            } else {
                NVPair[] nVPairArray = request.getHeaders();
                n = 0;
                while (n < nVPairArray.length) {
                    if (nVPairArray[n].getName().equalsIgnoreCase("Transfer-Encoding")) break;
                    ++n;
                }
                if (n == nVPairArray.length) {
                    nVPairArray = Util.resizeArray(nVPairArray, n + 1);
                    nVPairArray[n] = new NVPair("Transfer-Encoding", "chunked");
                    request.setHeaders(nVPairArray);
                } else {
                    String string = nVPairArray[n].getValue();
                    try {
                        if (!Util.hasToken(string, "chunked")) {
                            nVPairArray[n] = new NVPair("Transfer-Encoding", string + ", chunked");
                        }
                    }
                    catch (ParseException parseException) {
                        throw new IOException(parseException.toString());
                    }
                }
                hTTPResponse.set(request, this.sendRequest(request, hTTPResponse.getTimeout()));
            }
        } else {
            hTTPResponse.set(request, this.sendRequest(request, hTTPResponse.getTimeout()));
        }
        if (request.aborted) {
            throw new IOException("Request aborted by user");
        }
    }

    Response sendRequest(Request request, int n) throws IOException, ModuleException {
        boolean bl;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(600);
        Response response = null;
        if (this.early_stall != null) {
            try {
                if (GlobalConstants.DebugConn) {
                    System.err.println("Conn:  Early-stalling Request: " + request.getMethod() + " " + request.getRequestURI());
                }
                object = this.early_stall;
                synchronized (object) {
                    try {
                        this.early_stall.getVersion();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.early_stall = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        object = this.assembleHeaders(request, byteArrayOutputStream);
        try {
            bl = this.ServerProtocolVersion >= 65537 && !Util.hasToken(object[0], "close") || this.ServerProtocolVersion == 65536 && Util.hasToken(object[0], "keep-alive");
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            if (this.late_stall != null) {
                if (this.input_demux != null || this.KeepAliveUnknown) {
                    if (GlobalConstants.DebugConn) {
                        System.err.println("Conn:  Stalling Request: " + request.getMethod() + " " + request.getRequestURI());
                    }
                    try {
                        this.late_stall.getVersion();
                        if (this.KeepAliveUnknown) {
                            this.determineKeepAlive(this.late_stall);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.late_stall = null;
            }
            if ((request.getMethod().equals("POST") || request.dont_pipeline) && this.prev_resp != null && this.input_demux != null) {
                if (GlobalConstants.DebugConn) {
                    System.err.println("Conn:  Stalling Request: " + request.getMethod() + " " + request.getRequestURI());
                }
                try {
                    this.prev_resp.getVersion();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.output_finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.toString());
                }
            }
            if (request.aborted) {
                throw new IOException("Request aborted by user");
            }
            int n2 = 3;
            while (n2-- > 0) {
                try {
                    Object object2;
                    Socket socket;
                    if (this.input_demux == null || (socket = this.input_demux.getSocket()) == null) {
                        socket = this.getSocket(n);
                        if (this.Protocol == 1 && this.Proxy_Host != null) {
                            object2 = new Socket[]{socket};
                            response = this.enableSSLTunneling((Socket[])object2, request, n);
                            if (response != null) {
                                response.final_resp = true;
                                Response response2 = response;
                                return response2;
                            }
                            socket = object2[0];
                        }
                        this.input_demux = new StreamDemultiplexor(this.Protocol, socket, this);
                        this.DemuxList.addToEnd(this.input_demux);
                        this.KeepAliveReqLeft = this.KeepAliveReqMax;
                    }
                    if (request.aborted) {
                        throw new IOException("Request aborted by user");
                    }
                    if (GlobalConstants.DebugConn) {
                        System.err.println("Conn:  Sending Request: ");
                        System.err.println();
                        byteArrayOutputStream.writeTo(System.err);
                    }
                    object2 = socket.getOutputStream();
                    if (haveMSLargeWritesBug) {
                        object2 = new MSLargeWritesBugStream((OutputStream)object2);
                    }
                    byteArrayOutputStream.writeTo((OutputStream)object2);
                    try {
                        Object var14_24;
                        try {
                            if (this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 && Util.hasToken(object[1], "100-continue")) {
                                response = new Response(request, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                                response.timeout = 60;
                                if (response.getContinue() != 100) {
                                    Object var14_23 = null;
                                    if (response == null) break;
                                    response.timeout = 0;
                                    break;
                                }
                            }
                            var14_24 = null;
                            if (response != null) {
                                response.timeout = 0;
                            }
                        }
                        catch (ParseException parseException) {
                            throw new IOException(parseException.toString());
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            var14_24 = null;
                            if (response != null) {
                                response.timeout = 0;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_25 = null;
                        if (response != null) {
                            response.timeout = 0;
                        }
                        throw throwable;
                    }
                    if (request.getData() != null && request.getData().length > 0) {
                        if (request.delay_entity > 0L) {
                            long l = request.delay_entity / 100L;
                            long l2 = request.delay_entity / l;
                            int n3 = 0;
                            while ((long)n3 < l) {
                                if (this.input_demux.available(null) != 0) break;
                                try {
                                    Thread.sleep(l2);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                ++n3;
                            }
                            if (this.input_demux.available(null) == 0) {
                                ((OutputStream)object2).write(request.getData());
                            } else {
                                bl = false;
                            }
                        } else {
                            ((OutputStream)object2).write(request.getData());
                        }
                    }
                    if (request.getStream() != null) {
                        request.getStream().goAhead(request, (OutputStream)object2, 0);
                    } else {
                        ((OutputStream)object2).flush();
                    }
                    if (response != null) break;
                    response = new Response(request, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                    break;
                }
                catch (IOException iOException) {
                    if (GlobalConstants.DebugConn) {
                        System.err.print("Conn:  ");
                        iOException.printStackTrace();
                    }
                    this.closeDemux(iOException, true);
                    if (n2 == 0 || iOException instanceof UnknownHostException || iOException instanceof InterruptedIOException || request.aborted) {
                        throw iOException;
                    }
                    if (!GlobalConstants.DebugConn) continue;
                    System.err.println("Conn:  Retrying request");
                }
            }
            this.prev_resp = response;
            if (!this.KeepAliveUnknown && !this.DoesKeepAlive || !bl || this.KeepAliveReqMax != -1 && this.KeepAliveReqLeft-- == 0) {
                this.input_demux.markForClose(response);
                this.input_demux = null;
            } else {
                this.input_demux.restartTimer();
            }
            if (GlobalConstants.DebugConn && this.KeepAliveReqMax != -1) {
                System.err.println("Conn:  Number of requests left: " + this.KeepAliveReqLeft);
            }
            if (!this.ServProtVersKnown) {
                this.early_stall = response;
                response.markAsFirstResponse(request);
            }
            if (this.KeepAliveUnknown || !IdempotentSequence.methodIsIdempotent(request.getMethod()) || request.dont_pipeline || NeverPipeline) {
                this.late_stall = response;
            }
            if (request.getStream() != null) {
                this.output_finished = false;
            } else {
                this.output_finished = true;
                this.notify();
            }
            if (GlobalConstants.DebugConn) {
                System.err.println("Conn:  Request sent");
            }
        }
        return response;
    }

    private Socket getSocket(int n) throws IOException {
        int n2;
        String string;
        Socket socket = null;
        if (this.Proxy_Host != null) {
            string = this.Proxy_Host;
            n2 = this.Proxy_Port;
        } else {
            string = this.Host;
            n2 = this.Port;
        }
        if (GlobalConstants.DebugConn) {
            System.err.println("Conn:  Creating Socket: " + string + ":" + n2);
        }
        if (n == 0) {
            if (this.Socks_client != null) {
                socket = this.Socks_client.getSocket(string, n2);
            } else {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                int n3 = 0;
                while (n3 < inetAddressArray.length) {
                    try {
                        socket = new Socket(inetAddressArray[n3], n2);
                        break;
                    }
                    catch (SocketException socketException) {
                        if (n3 == inetAddressArray.length - 1) {
                            throw socketException;
                        }
                        ++n3;
                    }
                }
            }
        } else {
            EstablishConnection establishConnection = new EstablishConnection(string, n2, this.Socks_client);
            establishConnection.start();
            try {
                establishConnection.join(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (establishConnection.getException() != null) {
                throw establishConnection.getException();
            }
            socket = establishConnection.getSocket();
            if (socket == null) {
                establishConnection.forget();
                socket = establishConnection.getSocket();
                if (socket == null) {
                    throw new InterruptedIOException("Connection establishment timed out");
                }
            }
        }
        return socket;
    }

    private Response enableSSLTunneling(Socket[] socketArray, Request request, int n) throws IOException, ModuleException {
        Object object;
        Vector<NVPair> vector = new Vector<NVPair>();
        int n2 = 0;
        while (n2 < request.getHeaders().length) {
            object = request.getHeaders()[n2].getName();
            if (((String)object).equalsIgnoreCase("User-Agent") || ((String)object).equalsIgnoreCase("Proxy-Authorization")) {
                vector.addElement(request.getHeaders()[n2]);
            }
            ++n2;
        }
        object = new NVPair[vector.size()];
        vector.copyInto((Object[])object);
        Request request2 = new Request(this, "CONNECT", this.Host + ":" + this.Port, (NVPair[])object, null, null, request.allowUI());
        request2.internal_subrequest = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(600);
        HTTPResponse hTTPResponse = new HTTPResponse(this.gen_mod_insts(), n, request2);
        Response response = null;
        while (true) {
            this.handleRequest(request2, hTTPResponse, response, true);
            byteArrayOutputStream.reset();
            this.assembleHeaders(request2, byteArrayOutputStream);
            if (GlobalConstants.DebugConn) {
                System.err.println("Conn:  Sending SSL-Tunneling Subrequest: ");
                System.err.println();
                byteArrayOutputStream.writeTo(System.err);
            }
            byteArrayOutputStream.writeTo(socketArray[0].getOutputStream());
            response = new Response(request2, socketArray[0].getInputStream());
            if (response.getStatusCode() == 200) {
                return null;
            }
            try {
                response.getData();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                socketArray[0].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            hTTPResponse.set(request2, response);
            if (!hTTPResponse.handleResponse()) {
                return response;
            }
            socketArray[0] = this.getSocket(n);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[] assembleHeaders(Request var1_1, ByteArrayOutputStream var2_2) throws IOException {
        var3_3 = new DataOutputStream(var2_2);
        var4_4 = new String[]{"", ""};
        var5_5 = var1_1.getHeaders();
        var6_6 = Util.escapeUnsafeChars(var1_1.getRequestURI());
        if (this.Proxy_Host != null && this.Protocol != 1 && !var6_6.equals("*")) {
            var3_3.writeBytes(var1_1.getMethod() + " http://" + this.Host + ":" + this.Port + var6_6 + " " + this.RequestProtocolVersion + "\r\n");
        } else {
            var3_3.writeBytes(var1_1.getMethod() + " " + var6_6 + " " + this.RequestProtocolVersion + "\r\n");
        }
        if (this.Port != 80) {
            var3_3.writeBytes("Host: " + this.Host + ":" + this.Port + "\r\n");
        } else {
            var3_3.writeBytes("Host: " + this.Host + "\r\n");
        }
        var7_7 = -1;
        var8_8 = -1;
        var9_9 = -1;
        var10_10 = -1;
        var11_11 = -1;
        var12_12 = -1;
        var13_13 = -1;
        var14_14 = -1;
        var15_15 = -1;
        var16_16 = 0;
        while (var16_16 < var5_5.length) {
            var17_17 = var5_5[var16_16].getName().trim();
            if (var17_17.equalsIgnoreCase("Content-Type")) {
                var7_7 = var16_16;
            } else if (var17_17.equalsIgnoreCase("User-Agent")) {
                var8_8 = var16_16;
            } else if (var17_17.equalsIgnoreCase("Connection")) {
                var9_9 = var16_16;
            } else if (var17_17.equalsIgnoreCase("Proxy-Connection")) {
                var10_10 = var16_16;
            } else if (var17_17.equalsIgnoreCase("Keep-Alive")) {
                var11_11 = var16_16;
            } else if (var17_17.equalsIgnoreCase("Expect")) {
                var12_12 = var16_16;
            } else if (var17_17.equalsIgnoreCase("TE")) {
                var13_13 = var16_16;
            } else if (var17_17.equalsIgnoreCase("Transfer-Encoding")) {
                var14_14 = var16_16;
            } else if (var17_17.equalsIgnoreCase("Upgrade")) {
                var15_15 = var16_16;
            }
            ++var16_16;
        }
        var17_17 = null;
        if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || var9_9 != -1) {
            if (var9_9 == -1) {
                var17_17 = "Keep-Alive";
                var4_4[0] = "Keep-Alive";
            } else {
                var4_4[0] = var5_5[var9_9].getValue().trim();
                var17_17 = var4_4[0];
            }
            try {
                if (var11_11 != -1 && Util.hasToken(var4_4[0], "keep-alive")) {
                    var3_3.writeBytes("Keep-Alive: " + var5_5[var11_11].getValue().trim() + "\r\n");
                }
            }
            catch (ParseException var18_18) {
                throw new IOException(var18_18.toString());
            }
        }
        if (!(this.Proxy_Host == null || this.Protocol == 1 || this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 || var17_17 == null)) {
            var3_3.writeBytes("Proxy-Connection: ");
            var3_3.writeBytes(var17_17);
            var3_3.writeBytes("\r\n");
            var17_17 = null;
        }
        if (var17_17 != null) {
            try {
                if (Util.hasToken(var17_17, "TE")) ** GOTO lbl80
                var17_17 = var17_17 + ", TE";
            }
            catch (ParseException var18_19) {
                throw new IOException(var18_19.toString());
            }
        } else {
            var17_17 = "TE";
        }
lbl80:
        // 3 sources

        if (var15_15 != -1) {
            var17_17 = var17_17 + ", Upgrade";
        }
        if (var17_17 != null) {
            var3_3.writeBytes("Connection: ");
            var3_3.writeBytes(var17_17);
            var3_3.writeBytes("\r\n");
        }
        if (var13_13 != -1) {
            var3_3.writeBytes("TE: ");
            try {
                var18_20 = Util.parseHeader(var5_5[var13_13].getValue());
            }
            catch (ParseException var19_22) {
                throw new IOException(var19_22.toString());
            }
            if (!var18_20.contains(new HttpHeaderElement("trailers"))) {
                var3_3.writeBytes("trailers, ");
            }
            var3_3.writeBytes(var5_5[var13_13].getValue().trim() + "\r\n");
        } else {
            var3_3.writeBytes("TE: trailers\r\n");
        }
        if (var8_8 != -1) {
            var3_3.writeBytes("User-Agent: " + var5_5[var8_8].getValue().trim() + " " + "RPT-HTTPClient/0.3-2" + "\r\n");
        } else {
            var3_3.writeBytes("User-Agent: RPT-HTTPClient/0.3-2\r\n");
        }
        var18_21 = 0;
        while (var18_21 < var5_5.length) {
            if (var18_21 != var7_7 && var18_21 != var8_8 && var18_21 != var9_9 && var18_21 != var10_10 && var18_21 != var11_11 && var18_21 != var12_12 && var18_21 != var13_13) {
                var3_3.writeBytes(var5_5[var18_21].getName().trim() + ": " + var5_5[var18_21].getValue().trim() + "\r\n");
            }
            ++var18_21;
        }
        if (var1_1.getData() != null || var1_1.getStream() != null) {
            var3_3.writeBytes("Content-type: ");
            if (var7_7 != -1) {
                var3_3.writeBytes(var5_5[var7_7].getValue().trim());
            } else {
                var3_3.writeBytes("application/octet-stream");
            }
            var3_3.writeBytes("\r\n");
            if (var1_1.getData() != null) {
                var3_3.writeBytes("Content-length: " + var1_1.getData().length + "\r\n");
            } else if (var1_1.getStream().getLength() != -1 && var14_14 == -1) {
                var3_3.writeBytes("Content-length: " + var1_1.getStream().getLength() + "\r\n");
            }
            if (var12_12 != -1) {
                var4_4[1] = var5_5[var12_12].getValue().trim();
                var3_3.writeBytes("Expect: " + var4_4[1] + "\r\n");
            }
        } else if (var12_12 != -1) {
            try {
                var19_23 = Util.parseHeader(var5_5[var12_12].getValue());
            }
            catch (ParseException var20_24) {
                throw new IOException(var20_24.toString());
            }
            var20_25 = new HttpHeaderElement("100-continue");
            while (var19_23.removeElement(var20_25)) {
            }
            if (!var19_23.isEmpty()) {
                var4_4[1] = Util.assembleHeader(var19_23);
                var3_3.writeBytes("Expect: " + var4_4[1] + "\r\n");
            }
        }
        var3_3.writeBytes("\r\n");
        return var4_4;
    }

    boolean handleFirstRequest(Request request, Response response) throws IOException {
        this.ServerProtocolVersion = HTTPConnection.String2ProtVers(response.getVersion());
        this.ServProtVersKnown = true;
        if (this.Proxy_Host != null && this.Protocol != 1 && response.getHeader("Via") == null) {
            this.ServerProtocolVersion = 65536;
        }
        if (GlobalConstants.DebugConn) {
            System.err.println("Conn:  Protocol Version established: " + HTTPConnection.ProtVers2String(this.ServerProtocolVersion));
        }
        if (this.ServerProtocolVersion == 65536 && (response.getStatusCode() == 400 || response.getStatusCode() == 500)) {
            this.input_demux.markForClose(response);
            this.input_demux = null;
            this.RequestProtocolVersion = "HTTP/1.0";
            return false;
        }
        return true;
    }

    private void determineKeepAlive(Response response) throws IOException {
        try {
            HttpHeaderElement httpHeaderElement;
            String string;
            if (this.ServerProtocolVersion >= 65537 || ((this.Proxy_Host == null || this.Protocol == 1) && (string = response.getHeader("Connection")) != null || this.Proxy_Host != null && this.Protocol != 1 && (string = response.getHeader("Proxy-Connection")) != null) && Util.hasToken(string, "keep-alive")) {
                this.DoesKeepAlive = true;
                if (GlobalConstants.DebugConn) {
                    System.err.println("Conn:  Keep-Alive enabled");
                }
                this.KeepAliveUnknown = false;
            } else if (response.getStatusCode() < 400) {
                this.KeepAliveUnknown = false;
            }
            if (this.DoesKeepAlive && this.ServerProtocolVersion == 65536 && (string = response.getHeader("Keep-Alive")) != null && (httpHeaderElement = Util.getElement(Util.parseHeader(string), "max")) != null && httpHeaderElement.getValue() != null) {
                this.KeepAliveReqLeft = this.KeepAliveReqMax = Integer.parseInt(httpHeaderElement.getValue());
                if (GlobalConstants.DebugConn) {
                    System.err.println("Conn:  Max Keep-Alive requests: " + this.KeepAliveReqMax);
                }
            }
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    synchronized void outputFinished() {
        this.output_finished = true;
        this.notify();
    }

    synchronized void closeDemux(IOException iOException, boolean bl) {
        if (this.input_demux != null) {
            this.input_demux.close(iOException, bl);
        }
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    static final String ProtVers2String(int n) {
        return "HTTP/" + (n >>> 16) + "." + (n & 0xFFFF);
    }

    static final int String2ProtVers(String string) {
        String string2 = string.substring(5);
        int n = string2.indexOf(46);
        return Integer.parseInt(string2.substring(0, n)) << 16 | Integer.parseInt(string2.substring(n + 1));
    }

    public String toString() {
        return this.getProtocol() + "://" + this.getHost() + (this.getPort() != URI.defaultPort(this.getProtocol()) ? ":" + this.getPort() : "");
    }

    static {
        int n;
        String string;
        String string2;
        dflt_context = new Object();
        no_chunked = false;
        force_1_0 = false;
        Default_Proxy_Host = null;
        non_proxy_host_list = new CIHashtable();
        non_proxy_dom_list = new Vector();
        non_proxy_addr_list = new Vector();
        non_proxy_mask_list = new Vector();
        Default_Socks_client = null;
        NeverPipeline = false;
        NoKeepAlives = false;
        haveMSLargeWritesBug = false;
        DefaultTimeout = 0;
        DefaultAllowUI = true;
        try {
            string2 = System.getProperty("http.proxyHost");
            if (string2 == null) {
                throw new Exception();
            }
            int n2 = Integer.getInteger("http.proxyPort", -1);
            if (GlobalConstants.DebugConn) {
                System.err.println("Conn:  using proxy " + string2 + ":" + n2);
            }
            HTTPConnection.setProxyServer(string2, n2);
        }
        catch (Exception exception) {
            try {
                if (Boolean.getBoolean("proxySet")) {
                    String string3 = System.getProperty("proxyHost");
                    int n3 = Integer.getInteger("proxyPort", -1);
                    if (GlobalConstants.DebugConn) {
                        System.err.println("Conn:  using proxy " + string3 + ":" + n3);
                    }
                    HTTPConnection.setProxyServer(string3, n3);
                }
            }
            catch (Exception exception2) {
                Default_Proxy_Host = null;
            }
        }
        string2 = System.getProperty("HTTPClient.nonProxyHosts");
        if (string2 == null) {
            string2 = System.getProperty("http.nonProxyHosts");
        }
        String[] stringArray = Util.splitProperty(string2);
        HTTPConnection.dontProxyFor(stringArray);
        try {
            string = System.getProperty("HTTPClient.socksHost");
            if (string != null && string.length() > 0) {
                n = Integer.getInteger("HTTPClient.socksPort", -1);
                int n4 = Integer.getInteger("HTTPClient.socksVersion", -1);
                if (GlobalConstants.DebugConn) {
                    System.err.println("Conn:  using SOCKS " + string + ":" + n);
                }
                if (n4 == -1) {
                    HTTPConnection.setSocksServer(string, n);
                } else {
                    HTTPConnection.setSocksServer(string, n, n4);
                }
            }
        }
        catch (Exception exception) {
            Default_Socks_client = null;
        }
        string = "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule";
        n = 0;
        try {
            string = System.getProperty("HTTPClient.Modules", string);
        }
        catch (SecurityException securityException) {
            n = 1;
        }
        DefaultModuleList = new Vector();
        String[] stringArray2 = Util.splitProperty(string);
        int n5 = 0;
        while (n5 < stringArray2.length) {
            block37: {
                try {
                    DefaultModuleList.addElement(Class.forName(stringArray2[n5]));
                    if (GlobalConstants.DebugConn) {
                        System.err.println("Conn:  added module " + stringArray2[n5]);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (n != 0) break block37;
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ++n5;
        }
        try {
            NeverPipeline = Boolean.getBoolean("HTTPClient.disable_pipelining");
            if (GlobalConstants.DebugConn && NeverPipeline) {
                System.err.println("Conn:  disabling pipelining");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NoKeepAlives = Boolean.getBoolean("HTTPClient.disableKeepAlives");
            if (GlobalConstants.DebugConn && NoKeepAlives) {
                System.err.println("Conn:  disabling keep-alives");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            force_1_0 = Boolean.getBoolean("HTTPClient.forceHTTP_1.0");
            if (GlobalConstants.DebugConn && force_1_0) {
                System.err.println("Conn:  forcing HTTP/1.0 requests");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            no_chunked = Boolean.getBoolean("HTTPClient.dontChunkRequests");
            if (GlobalConstants.DebugConn && no_chunked) {
                System.err.println("Conn:  never chunking requests");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("os.name").indexOf("Windows") >= 0 && System.getProperty("java.version").startsWith("1.1")) {
                haveMSLargeWritesBug = true;
            }
            if (GlobalConstants.DebugConn && haveMSLargeWritesBug) {
                System.err.println("Conn:  splitting large writes into 20K chunks (M$ bug)");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MSLargeWritesBugStream
    extends FilterOutputStream {
        private final int CHUNK_SIZE = 20000;

        MSLargeWritesBugStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 20000) {
                this.out.write(byArray, n, 20000);
                n += 20000;
                n2 -= 20000;
            }
            this.out.write(byArray, n, n2);
        }
    }

    private class EstablishConnection
    extends Thread {
        String actual_host;
        int actual_port;
        IOException exception;
        Socket sock;
        SocksClient Socks_client;
        boolean close;

        EstablishConnection(String string, int n, SocksClient socksClient) {
            super("EstablishConnection (" + string + ":" + n + ")");
            try {
                this.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.actual_host = string;
            this.actual_port = n;
            this.Socks_client = socksClient;
            this.exception = null;
            this.sock = null;
            this.close = false;
        }

        public void run() {
            block10: {
                try {
                    if (this.Socks_client != null) {
                        this.sock = this.Socks_client.getSocket(this.actual_host, this.actual_port);
                        break block10;
                    }
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(this.actual_host);
                    int n = 0;
                    while (n < inetAddressArray.length) {
                        try {
                            this.sock = new Socket(inetAddressArray[n], this.actual_port);
                            break;
                        }
                        catch (SocketException socketException) {
                            if (n == inetAddressArray.length - 1 || this.close) {
                                throw socketException;
                            }
                            ++n;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.exception = iOException;
                }
            }
            if (this.close && this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        IOException getException() {
            return this.exception;
        }

        Socket getSocket() {
            return this.sock;
        }

        void forget() {
            this.close = true;
        }
    }
}

