/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Member;
import org.jacorb.idl.MemberList;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

class StructType
extends TypeDeclaration
implements Scope {
    private boolean written = false;
    public boolean exc;
    public MemberList memberlist = null;
    private boolean parsed = false;
    private ScopeData scopeData;

    public StructType(int n) {
        super(n);
        this.pack_name = "";
    }

    public void setScopeData(ScopeData scopeData) {
        this.scopeData = scopeData;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public boolean isException() {
        return this.exc;
    }

    public Object clone() {
        StructType structType = new StructType(IdlSymbol.new_num());
        structType.pack_name = this.pack_name;
        structType.name = this.name;
        structType.memberlist = this.memberlist;
        structType.included = this.included;
        structType.token = this.token;
        structType.exc = this.exc;
        structType.scopeData = this.scopeData;
        structType.enclosing_symbol = this.enclosing_symbol;
        return structType;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        if (this.typeName == null) {
            this.setPrintPhaseNames();
        }
        return this.typeName;
    }

    public String signature() {
        return "L" + this.typeName() + ";";
    }

    public boolean basic() {
        return false;
    }

    public void set_memberlist(MemberList memberList) {
        memberList.setStruct(this);
        this.memberlist = memberList;
        this.memberlist.setPackage(this.name);
        if (this.memberlist != null) {
            this.memberlist.setEnclosingSymbol(this);
        }
    }

    public void set_included(boolean bl) {
        this.included = bl;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        this.pack_name = this.pack_name.length() > 0 ? new String(string + "." + this.pack_name) : string;
        if (this.memberlist != null) {
            this.memberlist.setPackage(string);
        }
    }

    public void setEnclosingSymbol(IdlSymbol idlSymbol) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != idlSymbol) {
            System.err.println("was " + this.enclosing_symbol.getClass().getName() + " now: " + idlSymbol.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = idlSymbol;
    }

    public String toString() {
        return this.typeName();
    }

    public void parse() {
        if (this.parsed) {
            throw new RuntimeException("Compiler error: Struct already parsed!");
        }
        this.escapeName();
        try {
            ScopedName.definePseudoScope(this.full_name());
            ConstrTypeSpec constrTypeSpec = new ConstrTypeSpec(IdlSymbol.new_num());
            constrTypeSpec.c_type_spec = this;
            NameTable.define(this.full_name(), "type-struct");
            TypeMap.typedef(this.full_name(), constrTypeSpec);
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            Environment.output(4, nameAlreadyDefined);
            parser.error("Struct " + this.typeName() + " already defined", this.token);
        }
        if (this.memberlist != null) {
            ScopedName.addRecursionScope(this.typeName());
            this.memberlist.parse();
            ScopedName.removeRecursionScope(this.typeName());
        }
        this.parsed = true;
    }

    public String className() {
        String string = this.typeName();
        if (string.indexOf(46) > 0) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return string;
    }

    public String printReadExpression(String string) {
        return this.toString() + "Helper.read(" + string + ")";
    }

    public String printWriteStatement(String string, String string2) {
        return this.toString() + "Helper.write(" + string2 + "," + string + ");";
    }

    public String holderName() {
        return this.typeName() + "Holder";
    }

    public String getTypeCodeExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("org.omg.CORBA.ORB.init().create_struct_tc(" + this.typeName() + "Helper.id(),\"" + this.className() + "\",");
        if (this.memberlist != null) {
            stringBuffer.append("new org.omg.CORBA.StructMember[]{");
            Enumeration enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                Member member = (Member)enumeration.nextElement();
                Declarator declarator = member.declarator;
                stringBuffer.append("new org.omg.CORBA.StructMember(\"" + declarator.name() + "\",");
                stringBuffer.append(member.type_spec.typeSpec().getTypeCodeExpression() + ",null)");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        } else {
            stringBuffer.append("new org.omg.CORBA.StructMember[0]");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void printClassComment(String string, PrintWriter printWriter) {
        printWriter.println("/**");
        printWriter.println(" *\tGenerated from IDL definition of " + (this.exc ? "exception " : "struct ") + "\"" + string + "\"");
        printWriter.println(" *\t@author JacORB IDL compiler ");
        printWriter.println(" */\n");
    }

    private void printHolderClass(String string, PrintWriter printWriter) {
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";");
        }
        this.printClassComment(string, printWriter);
        printWriter.println("final public class " + string + "Holder");
        printWriter.println("\timplements org.omg.CORBA.portable.Streamable");
        printWriter.println("{");
        printWriter.println("\tpublic " + this.typeName() + " value;\n");
        printWriter.println("\tpublic " + string + "Holder ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        printWriter.println("\tpublic " + string + "Holder (" + this.typeName() + " initial)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = initial;");
        printWriter.println("\t}");
        printWriter.println("\tpublic org.omg.CORBA.TypeCode _type()");
        printWriter.println("\t{");
        printWriter.println("\t\treturn " + this.typeName() + "Helper.type();");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _read(org.omg.CORBA.portable.InputStream _in)");
        printWriter.println("\t{");
        printWriter.println("\t\tvalue = " + this.typeName() + "Helper.read(_in);");
        printWriter.println("\t}");
        printWriter.println("\tpublic void _write(org.omg.CORBA.portable.OutputStream _out)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + this.typeName() + "Helper.write(_out,value);");
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printHelperClass(String string, PrintWriter printWriter) {
        Declarator declarator;
        Member member;
        Enumeration enumeration;
        if (!this.pack_name.equals("")) {
            printWriter.println("package " + this.pack_name + ";\n");
        }
        this.printClassComment(string, printWriter);
        printWriter.println("public class " + string + "Helper");
        printWriter.println("{");
        printWriter.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        String string2 = this.typeName();
        printWriter.println("\tpublic " + string + "Helper ()");
        printWriter.println("\t{");
        printWriter.println("\t}");
        TypeSpec.printHelperClassMethods(string, printWriter, string2);
        this.printIdMethod(printWriter);
        printWriter.println("\tpublic static " + string2 + " read(org.omg.CORBA.portable.InputStream in)");
        printWriter.println("\t{");
        printWriter.println("\t\t" + string2 + " result = new " + string2 + "();");
        if (this.exc) {
            printWriter.println("\t\tif(!in.read_string().equals(id())) throw new org.omg.CORBA.MARSHAL(\"wrong id\");");
        }
        if (this.memberlist != null) {
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                member = (Member)enumeration.nextElement();
                declarator = member.declarator;
                printWriter.println("\t\t" + member.type_spec.typeSpec().printReadStatement("result." + declarator.name(), "in"));
            }
        }
        printWriter.println("\t\treturn result;");
        printWriter.println("\t}");
        printWriter.println("\tpublic static void write(org.omg.CORBA.portable.OutputStream out, " + string2 + " s)");
        printWriter.println("\t{");
        if (this.exc) {
            printWriter.println("\t\tout.write_string(id());");
        }
        if (this.memberlist != null) {
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                member = (Member)enumeration.nextElement();
                declarator = member.declarator;
                printWriter.println("\t\t" + member.type_spec.typeSpec().printWriteStatement("s." + declarator.name(), "out"));
            }
        }
        printWriter.println("\t}");
        printWriter.println("}");
    }

    private void printStructClass(String string, PrintWriter printWriter) {
        String string2 = string;
        if (!this.pack_name.equals("")) {
            string2 = this.pack_name + "." + string;
            printWriter.println("package " + this.pack_name + ";");
        }
        this.printClassComment(string, printWriter);
        printWriter.println("public final class " + string);
        if (this.exc) {
            printWriter.println("\textends org.omg.CORBA.UserException");
        } else {
            printWriter.println("\timplements org.omg.CORBA.portable.IDLEntity");
        }
        printWriter.println("{");
        if (this.exc) {
            printWriter.println("\tpublic " + string + "()");
            printWriter.println("\t{");
            printWriter.println("\t\tsuper(" + string2 + "Helper.id());");
            printWriter.println("\t}");
            printWriter.println();
            if (this.memberlist == null) {
                printWriter.println("\tpublic " + string + "(String value)");
                printWriter.println("\t{");
                printWriter.println("\t\tsuper(value);");
                printWriter.println("\t}");
            }
        } else {
            printWriter.println("\tpublic " + string + "(){}");
        }
        if (this.memberlist != null) {
            Declarator declarator;
            IdlSymbol idlSymbol;
            Enumeration enumeration;
            Enumeration enumeration2;
            Enumeration enumeration3 = this.memberlist.v.elements();
            while (enumeration3.hasMoreElements()) {
                ((Member)enumeration3.nextElement()).member_print(printWriter, "\tpublic ");
                printWriter.println();
            }
            if (this.exc) {
                printWriter.print("\tpublic " + string + "(");
                printWriter.print("java.lang.String _reason,");
                enumeration2 = this.memberlist.v.elements();
                while (enumeration2.hasMoreElements()) {
                    enumeration = (Member)enumeration2.nextElement();
                    idlSymbol = ((Member)((Object)enumeration)).declarator;
                    printWriter.print(((Member)((Object)enumeration)).type_spec.toString() + " " + ((Declarator)idlSymbol).toString());
                    if (!enumeration2.hasMoreElements()) continue;
                    printWriter.print(", ");
                }
                printWriter.println(")");
                printWriter.println("\t{");
                printWriter.println("\t\tsuper(" + string2 + "Helper.id()+\"\"+_reason );");
                enumeration = this.memberlist.v.elements();
                while (enumeration.hasMoreElements()) {
                    idlSymbol = (Member)enumeration.nextElement();
                    declarator = ((Member)idlSymbol).declarator;
                    printWriter.print("\t\tthis.");
                    printWriter.print(declarator.name());
                    printWriter.print(" = ");
                    printWriter.println(declarator.name() + ";");
                }
                printWriter.println("\t}");
            }
            printWriter.print("\tpublic " + string + "(");
            enumeration2 = this.memberlist.v.elements();
            while (enumeration2.hasMoreElements()) {
                enumeration = (Member)enumeration2.nextElement();
                idlSymbol = ((Member)((Object)enumeration)).declarator;
                printWriter.print(((Member)((Object)enumeration)).type_spec.toString() + " " + ((Declarator)idlSymbol).toString());
                if (!enumeration2.hasMoreElements()) continue;
                printWriter.print(", ");
            }
            printWriter.println(")");
            printWriter.println("\t{");
            enumeration = this.memberlist.v.elements();
            while (enumeration.hasMoreElements()) {
                idlSymbol = (Member)enumeration.nextElement();
                declarator = ((Member)idlSymbol).declarator;
                printWriter.print("\t\tthis.");
                printWriter.print(declarator.name());
                printWriter.print(" = ");
                printWriter.println(declarator.name() + ";");
            }
            printWriter.println("\t}");
        }
        printWriter.println("}");
    }

    public void print(PrintWriter printWriter) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.written) {
            return;
        }
        this.written = true;
        try {
            String string = this.className();
            String string2 = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File file = new File(string2);
            if (!file.exists() && !file.mkdirs()) {
                parser.fatal_error("Unable to create " + string2, null);
            }
            String string3 = string + ".java";
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printStructClass(string, printWriter2);
            printWriter2.close();
            string3 = string + "Holder.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHolderClass(string, printWriter2);
            printWriter2.close();
            string3 = string + "Helper.java";
            printWriter2 = new PrintWriter(new FileWriter(new File(file, string3)));
            this.printHelperClass(string, printWriter2);
            printWriter2.close();
            this.written = true;
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }
}

