/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java_cup.runtime.char_token;
import java_cup.runtime.float_token;
import java_cup.runtime.int_token;
import java_cup.runtime.long_token;
import java_cup.runtime.token;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.Module;
import org.jacorb.idl.PositionInfo;
import org.jacorb.idl.fixed_token;
import org.jacorb.idl.parser;
import org.jacorb.idl.str_token;

public class lexer {
    protected static int next_char;
    protected static int next_char2;
    protected static final int EOF_CHAR = -1;
    protected static Hashtable keywords;
    protected static Hashtable keywords_lower_case;
    protected static Hashtable java_keywords;
    protected static Hashtable char_symbols;
    protected static Hashtable defines;
    protected static boolean conditionalCompilation;
    private static Stack ifStack;
    private static Stack tokenStack;
    protected static int current_line;
    protected static StringBuffer line;
    protected static int current_position;
    protected static boolean in_string;
    protected static boolean wide;
    static int error_count;
    public static int warning_count;
    public static String currentPragmaPrefix;

    public static void reset() {
        current_position = 1;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
        line = new StringBuffer();
        ifStack.removeAllElements();
        tokenStack.removeAllElements();
        defines.clear();
    }

    public static void init() throws IOException {
        defines.put("JACORB_IDL_1_4", "");
        keywords.put("abstract", new Integer(2));
        keywords.put("any", new Integer(3));
        keywords.put("attribute", new Integer(4));
        keywords.put("boolean", new Integer(5));
        keywords.put("case", new Integer(6));
        keywords.put("char", new Integer(7));
        keywords.put("const", new Integer(8));
        keywords.put("context", new Integer(9));
        keywords.put("custom", new Integer(10));
        keywords.put("default", new Integer(11));
        keywords.put("double", new Integer(12));
        keywords.put("enum", new Integer(13));
        keywords.put("exception", new Integer(14));
        keywords.put("factory", new Integer(15));
        keywords.put("FALSE", new Integer(16));
        keywords.put("fixed", new Integer(17));
        keywords.put("float", new Integer(18));
        keywords.put("in", new Integer(19));
        keywords.put("inout", new Integer(20));
        keywords.put("interface", new Integer(21));
        keywords.put("local", new Integer(22));
        keywords.put("long", new Integer(23));
        keywords.put("module", new Integer(24));
        keywords.put("native", new Integer(25));
        keywords.put("Object", new Integer(26));
        keywords.put("octet", new Integer(27));
        keywords.put("oneway", new Integer(28));
        keywords.put("out", new Integer(29));
        keywords.put("private", new Integer(30));
        keywords.put("public", new Integer(31));
        keywords.put("pseudo", new Integer(32));
        keywords.put("raises", new Integer(33));
        keywords.put("readonly", new Integer(34));
        keywords.put("sequence", new Integer(35));
        keywords.put("short", new Integer(36));
        keywords.put("string", new Integer(37));
        keywords.put("struct", new Integer(38));
        keywords.put("supports", new Integer(39));
        keywords.put("switch", new Integer(40));
        keywords.put("TRUE", new Integer(41));
        keywords.put("truncatable", new Integer(42));
        keywords.put("typedef", new Integer(43));
        keywords.put("unsigned", new Integer(44));
        keywords.put("union", new Integer(45));
        keywords.put("ValueBase", new Integer(46));
        keywords.put("valuetype", new Integer(47));
        keywords.put("void", new Integer(48));
        keywords.put("wchar", new Integer(49));
        keywords.put("wstring", new Integer(50));
        keywords.put("::", new Integer(76));
        keywords.put("<<", new Integer(78));
        keywords.put(">>", new Integer(77));
        keywords.put("L\"", new Integer(79));
        Enumeration e = keywords.keys();
        while (e.hasMoreElements()) {
            String keyword = (String)e.nextElement();
            String keyword_lower_case = keyword.toLowerCase();
            keywords_lower_case.put(keyword_lower_case, keyword);
        }
        char_symbols.put(new Integer(59), new Integer(51));
        char_symbols.put(new Integer(44), new Integer(52));
        char_symbols.put(new Integer(42), new Integer(53));
        char_symbols.put(new Integer(46), new Integer(54));
        char_symbols.put(new Integer(58), new Integer(55));
        char_symbols.put(new Integer(61), new Integer(56));
        char_symbols.put(new Integer(43), new Integer(57));
        char_symbols.put(new Integer(45), new Integer(58));
        char_symbols.put(new Integer(123), new Integer(61));
        char_symbols.put(new Integer(125), new Integer(62));
        char_symbols.put(new Integer(40), new Integer(59));
        char_symbols.put(new Integer(41), new Integer(60));
        char_symbols.put(new Integer(91), new Integer(63));
        char_symbols.put(new Integer(93), new Integer(64));
        char_symbols.put(new Integer(60), new Integer(65));
        char_symbols.put(new Integer(62), new Integer(66));
        char_symbols.put(new Integer(39), new Integer(67));
        char_symbols.put(new Integer(34), new Integer(68));
        char_symbols.put(new Integer(92), new Integer(69));
        char_symbols.put(new Integer(94), new Integer(71));
        char_symbols.put(new Integer(38), new Integer(72));
        char_symbols.put(new Integer(47), new Integer(73));
        char_symbols.put(new Integer(37), new Integer(74));
        char_symbols.put(new Integer(126), new Integer(75));
        char_symbols.put(new Integer(124), new Integer(70));
        java_keywords.put("abstract", "");
        java_keywords.put("boolean", "");
        java_keywords.put("break", "");
        java_keywords.put("byte", "");
        java_keywords.put("case", "");
        java_keywords.put("catch", "");
        java_keywords.put("char", "");
        java_keywords.put("class", "");
        java_keywords.put("const", "");
        java_keywords.put("continue", "");
        java_keywords.put("default", "");
        java_keywords.put("do", "");
        java_keywords.put("double", "");
        java_keywords.put("else", "");
        java_keywords.put("extends", "");
        java_keywords.put("false", "");
        java_keywords.put("final", "");
        java_keywords.put("finally", "");
        java_keywords.put("for", "");
        java_keywords.put("float", "");
        java_keywords.put("goto", "");
        java_keywords.put("if", "");
        java_keywords.put("implements", "");
        java_keywords.put("import", "");
        java_keywords.put("instanceof", "");
        java_keywords.put("int", "");
        java_keywords.put("interface", "");
        java_keywords.put("long", "");
        java_keywords.put("native", "");
        java_keywords.put("new", "");
        java_keywords.put("null", "");
        java_keywords.put("package", "");
        java_keywords.put("protected", "");
        java_keywords.put("private", "");
        java_keywords.put("public", "");
        java_keywords.put("return", "");
        java_keywords.put("short", "");
        java_keywords.put("static", "");
        java_keywords.put("super", "");
        java_keywords.put("switch", "");
        java_keywords.put("synchronized", "");
        java_keywords.put("true", "");
        java_keywords.put("this", "");
        java_keywords.put("throw", "");
        java_keywords.put("throws", "");
        java_keywords.put("transient", "");
        java_keywords.put("try", "");
        java_keywords.put("volatile", "");
        java_keywords.put("void", "");
        java_keywords.put("while", "");
        java_keywords.put("clone", "");
        java_keywords.put("equals", "");
        java_keywords.put("finalize", "");
        java_keywords.put("getClass", "");
        java_keywords.put("hashCode", "");
        java_keywords.put("notify", "");
        java_keywords.put("notifyAll", "");
        java_keywords.put("toString", "");
        java_keywords.put("wait", "");
        ifStack.push(new Boolean(true));
        try {
            next_char = GlobalInputStream.read();
        }
        catch (Exception e2) {
            parser.fatal_error("Cannot read from file " + GlobalInputStream.currentFile().getAbsolutePath() + ", please check file name.", null);
        }
        next_char2 = next_char == -1 ? -1 : GlobalInputStream.read();
    }

    public static void define(String symbol2, String value) {
        Environment.output(4, "Defining: " + symbol2 + " as " + value);
        defines.put(symbol2, value);
    }

    public static void undefine(String symbol2) {
        Environment.output(4, "Un-defining: " + symbol2);
        defines.remove(symbol2);
    }

    public static String defined(String symbol2) {
        return (String)defines.get(symbol2);
    }

    public static int currentLine() {
        return current_line;
    }

    public static PositionInfo getPosition() {
        return new PositionInfo(current_line, current_position, currentPragmaPrefix, line.toString());
    }

    public static void restorePosition(PositionInfo p) {
        current_line = p.line_no;
        currentPragmaPrefix = p.pragma_prefix;
        current_position = 0;
    }

    protected static void advance() throws IOException {
        int old_char = next_char;
        next_char = next_char2;
        next_char2 = GlobalInputStream.read();
        line.append((char)old_char);
        ++current_position;
        if (old_char == 10) {
            ++current_line;
            current_position = 1;
            line = new StringBuffer();
        }
    }

    public static void emit_error(String message) {
        System.err.println(GlobalInputStream.currentFile().getAbsolutePath() + ", line: " + current_line + "(" + current_position + "): " + message);
        System.err.println("\t" + line.toString());
        ++error_count;
    }

    public static void emit_error(String message, str_token t) {
        if (t == null) {
            lexer.emit_error(message);
        } else {
            System.err.println("Error in " + t.fileName + ", line:" + t.line_no + "(" + t.char_pos + "): " + message);
            System.err.println("\t" + t.line_val);
            ++error_count;
        }
    }

    public static void emit_warn(String message) {
        System.err.println("Warning: " + message + " at " + current_line + "(" + current_position + "): \"" + line.toString() + "\"");
        ++warning_count;
    }

    public static void emit_warn(String message, str_token t) {
        if (t == null) {
            lexer.emit_warn(message);
        } else {
            System.err.println("Warning at " + t.fileName + ", line:" + t.line_no + "(" + t.char_pos + "): " + message);
            System.err.println("\t" + t.line_val);
            ++warning_count;
        }
    }

    protected static boolean id_start_char(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95;
    }

    protected static boolean id_char(int ch) {
        return lexer.id_start_char(ch) || ch == 95 || ch >= 48 && ch <= 57;
    }

    protected static int find_single_char(int ch) {
        Integer result = (Integer)char_symbols.get(new Integer((char)ch));
        if (result == null) {
            return -1;
        }
        return result;
    }

    protected static void swallow_comment() throws IOException {
        if (next_char2 == 42) {
            lexer.advance();
            lexer.advance();
            while (true) {
                if (next_char == -1) {
                    lexer.emit_error("Specification file ends inside a comment", null);
                    return;
                }
                if (next_char == 42 && next_char2 == 47) {
                    lexer.advance();
                    lexer.advance();
                    return;
                }
                lexer.advance();
            }
        }
        if (next_char2 == 47) {
            lexer.advance();
            lexer.advance();
            while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
                lexer.advance();
            }
            return;
        }
        lexer.emit_error("Malformed comment in specification -- ignored", null);
        lexer.advance();
    }

    protected static void preprocess() throws IOException {
        if (next_char == -1) {
            lexer.emit_error("Specification file ends inside a preprocessor directive", null);
            return;
        }
        if (next_char != 35) {
            lexer.emit_error("expected #, got " + (char)next_char + " instead!", null);
        } else {
            lexer.advance();
        }
        while (32 == next_char || 9 == next_char) {
            lexer.advance();
        }
        String dir = lexer.get_string();
        if (dir.equals("include")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.advance();
            boolean useIncludePath = next_char == 60;
            lexer.advance();
            String fname = lexer.get_string();
            if (useIncludePath && next_char != 62) {
                lexer.emit_error("Syntax error in #include directive, expecting '>'");
            } else if (!useIncludePath && next_char != 34) {
                lexer.emit_error("Syntax error in #include directive, expecting \"");
            }
            while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
                lexer.advance();
            }
            GlobalInputStream.include(fname, (char)next_char2, useIncludePath);
            current_line = 0;
            lexer.advance();
            lexer.advance();
            return;
        }
        if (dir.equals("define")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String name = lexer.get_string();
            StringBuffer text = new StringBuffer();
            if (next_char == 32) {
                lexer.advance();
            }
            while (next_char != 10) {
                if (next_char == 92) {
                    lexer.advance();
                    lexer.advance();
                }
                text.append((char)next_char);
                lexer.advance();
            }
            lexer.define(name, text.toString());
        } else if (dir.equals("error")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.advance();
            String name = lexer.get_string();
            lexer.emit_error(name);
        } else if (dir.equals("undef")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String name = lexer.get_string();
            lexer.undefine(name);
        } else if (dir.equals("if")) {
            boolean brackets;
            String defineStr;
            ifStack.push(new Boolean(conditionalCompilation));
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            boolean straightDefined = true;
            if (33 == next_char) {
                lexer.advance();
                straightDefined = false;
            }
            if (!(defineStr = lexer.get_string_no_paren()).equals("defined")) {
                lexer.emit_error("Expected \"defined\" following #if: " + dir, null);
                return;
            }
            lexer.swallow_whitespace();
            boolean bl = brackets = 40 == next_char;
            if (brackets) {
                lexer.advance();
                lexer.swallow_whitespace();
            }
            String name = lexer.get_string_no_paren();
            if (brackets) {
                lexer.swallow_whitespace();
                Environment.output(4, "next char: " + next_char);
                if (41 != next_char) {
                    lexer.emit_error("Expected ) terminating #if defined", null);
                    return;
                }
                lexer.advance();
            }
            conditionalCompilation = straightDefined ? lexer.defined(name) != null : lexer.defined(name) == null;
        } else if (dir.equals("ifdef")) {
            ifStack.push(new Boolean(conditionalCompilation));
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String name = lexer.get_string();
            conditionalCompilation = lexer.defined(name) != null;
        } else if (dir.equals("ifndef")) {
            ifStack.push(new Boolean(conditionalCompilation));
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String name = lexer.get_string();
            conditionalCompilation = lexer.defined(name) == null;
        } else if (dir.equals("else")) {
            if (((Boolean)ifStack.peek()).booleanValue()) {
                conditionalCompilation = !conditionalCompilation;
            }
        } else if (dir.equals("endif")) {
            boolean b;
            conditionalCompilation = b = ((Boolean)ifStack.pop()).booleanValue();
        } else if (dir.equals("pragma")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String name = lexer.get_string();
            if (name.equals("prefix")) {
                String prefix;
                lexer.advance();
                currentPragmaPrefix = prefix = lexer.get_string();
            } else if (name.equals("version")) {
                lexer.advance();
                String vname = lexer.get_string();
                lexer.advance();
                String version = lexer.get_string();
                String existingVersion = (String)parser.currentScopeData().versionMap.get(vname);
                if (existingVersion == null) {
                    parser.currentScopeData().versionMap.put(vname, version);
                } else if (!existingVersion.equals(version)) {
                    lexer.emit_warn("Version re-declaration, ignoring: #pragma version " + version, null);
                }
            } else if (name.equals("ID")) {
                lexer.advance();
                String iname = lexer.get_string();
                lexer.advance();
                String string = lexer.get_string();
            } else if (name.equals("inhibit_code_generation")) {
                parser.setInhibitionState(true);
            } else {
                lexer.emit_warn("Unknown pragma, ignoring: #pragma " + name, null);
            }
        } else {
            lexer.emit_error("Unrecognized preprocessor directive " + dir, null);
        }
        while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
            lexer.advance();
        }
    }

    private static final String get_string_no_paren() throws IOException {
        StringBuffer sb = new StringBuffer();
        char c = (char)next_char;
        while (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f' && c != '\uffffffff' && c != '\"' && c != '<' && c != '>' && c != '(' && c != ')') {
            sb.append(c);
            lexer.advance();
            c = (char)next_char;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static final String get_string() throws IOException {
        block3: {
            sb = new StringBuffer("");
            if (lexer.next_char != 34) ** GOTO lbl15
            lexer.advance();
            while (lexer.next_char != 34) {
                if (lexer.next_char == -1) {
                    lexer.emit_error("Unexpected EOF in string");
                }
                sb.append((char)lexer.next_char);
                lexer.advance();
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                sb.append((char)lexer.next_char);
                lexer.advance();
lbl15:
                // 2 sources

                ** while (lexer.next_char != 32 && lexer.next_char != 9 && lexer.next_char != 13 && lexer.next_char != 10 && lexer.next_char != 12 && lexer.next_char != -1 && lexer.next_char != 34 && lexer.next_char != 60 && lexer.next_char != 62)
            }
        }
        return sb.toString();
    }

    protected static token do_symbol() throws IOException {
        StringBuffer result = new StringBuffer();
        Integer keyword_num = null;
        char[] buffer = new char[]{(char)next_char};
        result.append(buffer, 0, 1);
        lexer.advance();
        while (lexer.id_char(next_char)) {
            buffer[0] = (char)next_char;
            result.append(buffer, 0, 1);
            lexer.advance();
        }
        String result_str = result.toString();
        String text = lexer.defined(result_str);
        if (text != null) {
            char[] next = new char[]{(char)next_char, (char)next_char2};
            GlobalInputStream.insert(text + new String(next));
            lexer.advance();
            lexer.advance();
            return null;
        }
        Environment.output(3, "Advancing after symbol " + result_str);
        keyword_num = (Integer)keywords.get(result_str);
        if (keyword_num != null) {
            if (lexer.isScope(result_str)) {
                parser.openScope();
            }
            return new token(keyword_num);
        }
        if ((result_str = lexer.checkIdentifier(result_str)) != null) {
            return new str_token(80, result_str, lexer.getPosition(), GlobalInputStream.currentFile().getName());
        }
        return null;
    }

    private static final boolean isScope(String keyword) {
        return keyword.equals("module") || keyword.equals("interface") || keyword.equals("struct") || keyword.equals("exception") || keyword.equals("union");
    }

    public static String checkIdentifier(String str) {
        Environment.output(3, "checking identifier " + str);
        if (str.charAt(0) == '_') {
            return str.substring(1);
        }
        String colliding_keyword = (String)keywords_lower_case.get(str.toLowerCase());
        if (colliding_keyword != null) {
            lexer.emit_error("Identifier " + str + " collides with keyword " + colliding_keyword + ".");
            return null;
        }
        if (lexer.needsJavaEscape(str)) {
            return "_" + str;
        }
        return str;
    }

    private static final boolean needsJavaEscape(String s) {
        return java_keywords.containsKey(s);
    }

    public static boolean strictJavaEscapeCheck(String s) {
        return !s.equals("Helper") && s.endsWith("Helper") || !s.equals("Holder") && s.endsWith("Holder") || !s.equals("Operations") && s.endsWith("Operations") || !s.equals("Package") && s.endsWith("Package") || !s.equals("POA") && s.endsWith("POA") || !s.equals("POATie") && s.endsWith("POATie");
    }

    public static boolean needsJavaEscape(Module m) {
        String s = m.pack_name;
        Environment.output(4, "checking module name " + s);
        return lexer.strictJavaEscapeCheck(s);
    }

    public static token next_token() throws IOException {
        parser.set_included(GlobalInputStream.includeState());
        token result = lexer.real_next_token();
        return result;
    }

    private static final void swallow_whitespace() throws IOException {
        while (next_char == 32 || next_char == 9 || next_char == 10 || next_char == 12 || next_char == 13) {
            lexer.advance();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected static token real_next_token() throws IOException {
        if (!lexer.tokenStack.empty()) {
            return (token)lexer.tokenStack.pop();
        }
        while (true) {
            block98: {
                block97: {
                    if (lexer.in_string) break block97;
                    lexer.swallow_whitespace();
                    if ((char)lexer.next_char == '#') {
                        lexer.preprocess();
                        continue;
                    }
                    if (lexer.next_char == 47 && (lexer.next_char2 == 42 || lexer.next_char2 == 47)) {
                        lexer.swallow_comment();
                        continue;
                    }
                    if (!lexer.conditionalCompilation) {
                        lexer.advance();
                        if (lexer.next_char != -1) continue;
                        lexer.emit_error("EOF in conditional compilation!", null);
                        return null;
                    }
                    if (lexer.next_char == 58) {
                        if (lexer.next_char2 == 58) {
                            lexer.advance();
                            lexer.advance();
                            return new token(76);
                        }
                        lexer.advance();
                        return new token(55);
                    }
                    if (lexer.next_char == 76 && lexer.next_char2 == 34) {
                        lexer.advance();
                        lexer.advance();
                        lexer.wide = true;
                        lexer.in_string = true;
                        return new token(79);
                    }
                    if (lexer.next_char == 60) {
                        if (lexer.next_char2 == 60) {
                            lexer.advance();
                            lexer.advance();
                            return new token(78);
                        }
                        lexer.advance();
                        return new token(65);
                    }
                    if (lexer.next_char == 62) {
                        if (lexer.next_char2 == 62) {
                            lexer.advance();
                            lexer.advance();
                            return new token(77);
                        }
                        lexer.advance();
                        return new token(66);
                    }
                    if (lexer.next_char == 48) {
                        l_val = 0L;
                        l_val_old = 0L;
                        radix = 8;
                        digit = 0;
                        lexer.advance();
                        if (lexer.next_char == 46) {
                            f_string = new StringBuffer("0.");
                            lexer.advance();
                            while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                                f_string.append((char)lexer.next_char);
                                lexer.advance();
                            }
                            f_val = new Float(f_string.toString()).floatValue();
                            return new float_token(84, f_val);
                        }
                        if (lexer.next_char == 120 || lexer.next_char == 88) {
                            lexer.advance();
                            radix = 16;
                        }
                        val = new StringBuffer("0");
                        digit = Character.digit((char)lexer.next_char, radix);
                        while (digit != -1) {
                            val.append((char)lexer.next_char);
                            lexer.advance();
                            digit = Character.digit((char)lexer.next_char, radix);
                        }
                        str = val.toString();
                        try {
                            return new int_token(82, Integer.parseInt(str, radix));
                        }
                        catch (NumberFormatException ex) {
                            try {
                                return new long_token(83, Long.parseLong(str, radix));
                            }
                            catch (NumberFormatException ex2) {
                                lexer.emit_error("Invalid octal/hex value:  " + str);
                                return null;
                            }
                        }
                    }
                    if (lexer.next_char >= 48 && lexer.next_char <= 57 || lexer.next_char == 46) {
                        value = new StringBuffer();
                        fraction = null;
                        exp = false;
                        while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                            value.append((char)lexer.next_char);
                            lexer.advance();
                        }
                        if (lexer.next_char == 46) {
                            fraction = new StringBuffer();
                            lexer.advance();
                            while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                                fraction.append((char)lexer.next_char);
                                lexer.advance();
                            }
                        }
                        if (lexer.next_char == 101 || lexer.next_char == 69) {
                            if (fraction == null) {
                                fraction = new StringBuffer();
                            }
                            fraction.append('e');
                            lexer.advance();
                            if (lexer.next_char == 45 || lexer.next_char == 43) {
                                fraction.append((char)lexer.next_char);
                                lexer.advance();
                            }
                            while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                                fraction.append((char)lexer.next_char);
                                lexer.advance();
                            }
                            if (fraction.length() == 1) {
                                lexer.emit_error("Empty exponent in float/double.");
                                continue;
                            }
                            return new float_token(84, Float.valueOf(value.toString() + "." + fraction.toString()).floatValue());
                        }
                        if (lexer.next_char == 100 || lexer.next_char == 68) {
                            lexer.advance();
                            if (fraction == null) {
                                fraction = new StringBuffer();
                            }
                            bi = new BigDecimal(value.toString() + "." + fraction.toString());
                            return new fixed_token(85, bi);
                        }
                        if (fraction == null) {
                            tok /* !! */  = null;
                            str = value.toString();
                            try {
                                tok /* !! */  = new int_token(82, Integer.parseInt(str));
                            }
                            catch (NumberFormatException ex) {
                                try {
                                    tok /* !! */  = new long_token(83, Long.parseLong(str));
                                }
                                catch (NumberFormatException ex2) {
                                    lexer.emit_error("Invalid long value:  " + str);
                                }
                            }
                            return tok /* !! */ ;
                        }
                        try {
                            f = Float.valueOf(value.toString() + "." + fraction.toString()).floatValue();
                            return new float_token(84, f);
                        }
                        catch (NumberFormatException nf) {
                            lexer.emit_error("Unexpected symbol:  " + value.toString() + "." + fraction.toString());
                        }
                    }
                    sym_num = lexer.find_single_char(lexer.next_char);
                    if ((char)lexer.next_char == '\"') {
                        lexer.in_string = true;
                        lexer.advance();
                        return new token(68);
                    }
                    if ((char)lexer.next_char == '\'') {
                        lexer.advance();
                        t = null;
                        if (lexer.next_char == 92) {
                            lexer.advance();
                            if (lexer.isDigit((char)lexer.next_char)) {
                                octal1 = '0';
                                octal2 = '0';
                                octal3 = (char)lexer.next_char;
                                if (lexer.isDigit((char)lexer.next_char2)) {
                                    lexer.advance();
                                    octal2 = octal3;
                                    octal3 = (char)lexer.next_char;
                                    if (lexer.isDigit((char)lexer.next_char2)) {
                                        lexer.advance();
                                        octal1 = octal2;
                                        octal2 = octal3;
                                        octal3 = (char)lexer.next_char;
                                    }
                                }
                                t = new char_token(81, (char)Integer.parseInt(new String(new char[]{octal1, octal2, octal3}), 8));
                            } else if ((char)lexer.next_char == 'x') {
                                lexer.advance();
                                hex1 = '0';
                                hex2 = (char)lexer.next_char;
                                if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                    lexer.advance();
                                    hex1 = hex2;
                                    hex2 = (char)lexer.next_char;
                                } else if ((char)lexer.next_char2 != '\'') {
                                    lexer.emit_error("Illegal hex character");
                                    return null;
                                }
                                t = new char_token(81, (char)Integer.parseInt(new String(new char[]{hex1, hex2}), 16));
                            } else if ((char)lexer.next_char == 'u') {
                                if (!lexer.wide) {
                                    lexer.emit_error("Unicode characters are only legal with wide character");
                                    return null;
                                }
                                lexer.advance();
                                uni1 = '0';
                                uni2 = '0';
                                uni3 = '0';
                                uni4 = (char)lexer.next_char;
                                if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                    lexer.advance();
                                    uni3 = uni4;
                                    uni4 = (char)lexer.next_char;
                                    if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                        lexer.advance();
                                        uni2 = uni3;
                                        uni3 = uni4;
                                        uni4 = (char)lexer.next_char;
                                        if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                            lexer.advance();
                                            uni1 = uni2;
                                            uni2 = uni3;
                                            uni3 = uni4;
                                            uni4 = (char)lexer.next_char;
                                        } else if ((char)lexer.next_char2 != '\'') {
                                            lexer.emit_error("Illegal unicode character");
                                            return null;
                                        }
                                    } else if ((char)lexer.next_char2 != '\'') {
                                        lexer.emit_error("Illegal unicode character");
                                        return null;
                                    }
                                } else if ((char)lexer.next_char2 != '\'') {
                                    lexer.emit_error("Illegal unicode character");
                                    return null;
                                }
                                t = new char_token(81, (char)Integer.parseInt(new String(new char[]{uni1, uni2, uni3, uni4}), 16));
                            } else {
                                switch (lexer.next_char) {
                                    case 110: {
                                        t = new char_token(81, '\n');
                                        break;
                                    }
                                    case 116: {
                                        t = new char_token(81, '\t');
                                        break;
                                    }
                                    case 118: {
                                        t = new char_token(81, '\u000b');
                                        break;
                                    }
                                    case 98: {
                                        t = new char_token(81, '\b');
                                        break;
                                    }
                                    case 114: {
                                        t = new char_token(81, '\r');
                                        break;
                                    }
                                    case 102: {
                                        t = new char_token(81, '\f');
                                        break;
                                    }
                                    case 97: {
                                        t = new char_token(81, '\u0007');
                                        break;
                                    }
                                    case 92: {
                                        t = new char_token(81, '\\');
                                        break;
                                    }
                                    case 63: {
                                        t = new char_token(81, '?');
                                        break;
                                    }
                                    case 48: {
                                        t = new char_token(81, '\u0000');
                                        break;
                                    }
                                    case 39: {
                                        t = new char_token(81, '\'');
                                        break;
                                    }
                                    case 34: {
                                        t = new char_token(81, '\"');
                                        break;
                                    }
                                    default: {
                                        lexer.emit_error("Invalid escape symbol '");
                                        return null;
                                    }
                                }
                            }
                        } else {
                            t = new char_token(81, (char)lexer.next_char);
                        }
                        lexer.advance();
                        if ((char)lexer.next_char != '\'') {
                            lexer.emit_error("Expecting closing '");
                            return null;
                        }
                        lexer.tokenStack.push(new token(67));
                        lexer.tokenStack.push(t);
                        lexer.advance();
                        lexer.wide = false;
                        return new token(67);
                    }
                    if (sym_num != -1) {
                        lexer.advance();
                        return new token(sym_num);
                    }
                    if (lexer.id_start_char(lexer.next_char)) {
                        t = lexer.do_symbol();
                        if (t == null) continue;
                        return t;
                    }
                    if (lexer.next_char == -1) {
                        return new token(0);
                    }
                    break block98;
                }
                if ((char)lexer.next_char == '\"') {
                    lexer.in_string = false;
                    lexer.advance();
                    return new token(68);
                }
                result = new StringBuffer();
                previous = ' ';
                do {
                    block100: {
                        block99: {
                            if (lexer.next_char != 92) break block99;
                            switch (lexer.next_char2) {
                                case 97: {
                                    result.append("\\007");
                                    previous = 'a';
                                    lexer.advance();
                                    break;
                                }
                                case 118: {
                                    result.append("\\013");
                                    previous = 'v';
                                    lexer.advance();
                                    break;
                                }
                                case 63: {
                                    result.append("?");
                                    previous = '?';
                                    lexer.advance();
                                    break;
                                }
                                case 120: {
                                    lexer.advance();
                                    lexer.advance();
                                    octal = Integer.toOctalString(Integer.parseInt(new String(new char[]{(char)lexer.next_char, (char)lexer.next_char2}), 16));
                                    if (octal.length() != 3) {
                                        if (octal.length() == 1) {
                                            octal = "0" + octal;
                                        }
                                        octal = "0" + octal;
                                    }
                                    result.append("\\" + octal);
                                    previous = (char)lexer.next_char2;
                                    lexer.advance();
                                    break;
                                }
                                case 117: {
                                    if (!lexer.wide) {
                                        lexer.emit_error("Unicode characters are only legal with wide strings");
                                        return null;
                                    }
                                    result.append((char)lexer.next_char);
                                    result.append((char)lexer.next_char2);
                                    lexer.advance();
                                    lexer.advance();
                                    uni1 = (char)lexer.next_char;
                                    uni2 = '0';
                                    uni3 = '0';
                                    uni4 = '0';
                                    if (!lexer.isHexLetterOrDigit((char)lexer.next_char2)) ** GOTO lbl347
                                    lexer.advance();
                                    uni2 = (char)lexer.next_char;
                                    if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                        lexer.advance();
                                        uni3 = (char)lexer.next_char;
                                        if (!lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                            lexer.emit_error("Illegal unicode character");
                                            return null;
                                        }
                                    } else {
                                        lexer.emit_error("Illegal unicode character");
                                        return null;
lbl347:
                                        // 1 sources

                                        lexer.emit_error("Illegal unicode character");
                                        return null;
                                    }
                                    lexer.advance();
                                    uni4 = (char)lexer.next_char;
                                    previous = uni4;
                                    result.append(uni1);
                                    result.append(uni2);
                                    result.append(uni3);
                                    result.append(uni4);
                                    break;
                                }
                                default: {
                                    previous = (char)lexer.next_char;
                                    result.append((char)lexer.next_char);
                                    break;
                                }
                            }
                            break block100;
                        }
                        previous = (char)lexer.next_char;
                        result.append((char)lexer.next_char);
                    }
                    lexer.advance();
                } while ((char)lexer.next_char != '\"' || previous == 92);
                lexer.wide = false;
                s = result.toString();
                return new str_token(80, s, lexer.getPosition(), GlobalInputStream.currentFile().getName());
            }
            lexer.emit_warn("Unrecognized character '" + new Character((char)lexer.next_char) + "'(" + lexer.next_char + ") -- ignored");
            lexer.advance();
        }
    }

    private static final boolean isDigit(char c) {
        boolean result = false;
        if (c >= '0' && c <= '9') {
            result = true;
        }
        return result;
    }

    private static final boolean isHexLetterOrDigit(char c) {
        boolean result = false;
        if (c >= '0') {
            if (c <= '9') {
                result = true;
            } else if (c >= 'A') {
                if (c <= 'F') {
                    result = true;
                }
                if (c >= 'a' && c <= 'f') {
                    result = true;
                }
            }
        }
        return result;
    }

    static {
        keywords = new Hashtable();
        keywords_lower_case = new Hashtable();
        java_keywords = new Hashtable();
        char_symbols = new Hashtable(25);
        defines = new Hashtable();
        conditionalCompilation = true;
        ifStack = new Stack();
        tokenStack = new Stack();
        current_line = 1;
        line = new StringBuffer();
        current_position = 1;
        in_string = false;
        wide = false;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
    }
}

