/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IllegalRedefinition;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.ValueBody;
import org.jacorb.idl.ValueInheritanceSpec;
import org.jacorb.idl.parser;

class ValueAbsDecl
extends Value {
    ValueBody body = null;
    ValueInheritanceSpec inheritanceSpec;

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? new String(s + "." + this.pack_name) : s;
        if (this.body != null) {
            this.body.setPackage(s);
        }
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setPackage(s);
        }
    }

    public void setInheritanceSpec(ValueInheritanceSpec spec) {
        this.inheritanceSpec = spec;
    }

    public ValueInheritanceSpec setInheritanceSpec() {
        return this.inheritanceSpec;
    }

    public TypeDeclaration declaration() {
        return this;
    }

    public String typeName() {
        return this.full_name();
    }

    public Object clone() {
        throw new RuntimeException("Don't clone me, i am an interface!");
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            System.err.println("was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public boolean basic() {
        return true;
    }

    public String holderName() {
        return this.javaName() + "Holder";
    }

    public String toString() {
        String n = this.typeName();
        if (!n.startsWith("org.omg")) {
            return this.omgPrefix() + n;
        }
        return n;
    }

    public void set_included(boolean i) {
        this.included = i;
    }

    public void parse() {
        boolean justAnotherOne;
        block10: {
            justAnotherOne = false;
            this.escapeName();
            ConstrTypeSpec ctspec = new ConstrTypeSpec(IdlSymbol.new_num());
            try {
                ScopedName.definePseudoScope(this.full_name());
                ctspec.c_type_spec = this;
                NameTable.define(this.full_name(), "type");
                TypeMap.typedef(this.full_name(), ctspec);
            }
            catch (IllegalRedefinition ill) {
                parser.fatal_error("Illegal Redefinition of  " + ill.oldDef + " in nested scope as " + ill.newDef, this.token);
            }
            catch (NameAlreadyDefined nad) {
                if (this.body != null) {
                    justAnotherOne = true;
                }
                if (this.full_name().equals("org.omg.CORBA.TypeCode") || this.body == null) break block10;
                TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
            }
        }
        if (this.body != null) {
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                Environment.output(4, "Checking inheritanceSpec of " + this.full_name());
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ConstrTypeSpec ts;
                    ScopedName name = (ScopedName)e.nextElement();
                    TypeSpec resolvedTSpec = name.resolvedTypeSpec();
                    if (!(resolvedTSpec instanceof ConstrTypeSpec)) {
                        parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec, this.token);
                    }
                    if ((ts = (ConstrTypeSpec)resolvedTSpec).declaration() instanceof Interface || ts.declaration() instanceof ValueAbsDecl) continue;
                    parser.fatal_error("Illegal inheritance spec: " + this.inheritanceSpec, this.token);
                }
                this.body.set_ancestors(this.inheritanceSpec);
            }
            this.body.parse();
            NameTable.parsed_interfaces.put(this.full_name(), "");
        } else if (!justAnotherOne) {
            parser.set_pending(this.full_name());
        }
    }

    ValueBody getBody() {
        if (parser.get_pending(this.full_name()) != null) {
            parser.fatal_error(this.full_name() + " is forward declared and still pending!", this.token);
        } else if (this.body == null) {
            if ((ValueAbsDecl)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec != this) {
                this.body = ((ValueAbsDecl)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec).getBody();
            }
            if (this.body == null) {
                parser.fatal_error(this.full_name() + " still has an empty body!", this.token);
            }
        }
        return this.body;
    }

    public String getTypeCodeExpression() {
        return "org.omg.CORBA.ORB.init().create_value_tc(\"" + this.id() + "\", \"" + this.name + "\", org.omg.CORBA.VM_ABSTRACT.value " + ", null, null )";
    }

    public String printReadExpression(String streamname) {
        return "null /* no read expression for abstract value */";
    }

    public String printReadStatement(String var_name, String streamname) {
        return "throw new org.omg.CORBA.NO_IMPLEMENT();";
    }

    public String printWriteStatement(String var_name, String streamname) {
        return "throw new org.omg.CORBA.NO_IMPLEMENT();";
    }

    private final void printClassComment(String className, PrintWriter ps) {
        ps.println("/**");
        ps.println(" *\tGenerated from IDL definition of abstract value type \"" + className + "\"");
        ps.println(" *\t@author JacORB IDL compiler ");
        ps.println(" */\n");
    }

    public void print(PrintWriter unused) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.body != null) {
            try {
                Enumeration e;
                String path = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                PrintWriter ps = new PrintWriter(new FileWriter(new File(dir, this.name + ".java")));
                if (!this.pack_name.equals("")) {
                    ps.println("package " + this.pack_name + ";\n");
                }
                this.printClassComment(this.name, ps);
                if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                    e = this.inheritanceSpec.v.elements();
                    while (e.hasMoreElements()) {
                        ScopedName sn = (ScopedName)e.nextElement();
                        if (sn.resolvedName().indexOf(46) >= 0) continue;
                        ps.println("import " + sn + "Operations;");
                    }
                }
                this.printImport(ps);
                ps.println("public interface " + this.name);
                ps.print("\textends org.omg.CORBA.portable.ValueBase ");
                if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                    e = this.inheritanceSpec.v.elements();
                    while (e.hasMoreElements()) {
                        ps.print(", " + (ScopedName)e.nextElement());
                    }
                }
                ps.println("\n{");
                if (this.body != null) {
                    this.body.printOperationSignatures(ps);
                }
                ps.println("}");
                ps.close();
            }
            catch (IOException i) {
                System.err.println("File IO error");
                i.printStackTrace();
            }
        }
    }

    public ValueAbsDecl(int num) {
        super(num);
        this.pack_name = "";
    }
}

