/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.util.Hashtable;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.ObjectTypeSpec;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeCodeTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

class TypeMap {
    static Hashtable typemap = new Hashtable(5000);

    public static void init() {
        typemap.clear();
        typemap.put("org.omg.CORBA.Object", new ObjectTypeSpec(IdlSymbol.new_num()));
        typemap.put("org.omg.CORBA.TypeCode", new TypeCodeTypeSpec(IdlSymbol.new_num()));
        typemap.put("CORBA.Object", new ObjectTypeSpec(IdlSymbol.new_num()));
        typemap.put("CORBA.TypeCode", new TypeCodeTypeSpec(IdlSymbol.new_num()));
    }

    public static TypeSpec map(String name) {
        return (TypeSpec)typemap.get(name);
    }

    public static void typedef(String name, TypeSpec type) throws NameAlreadyDefined {
        Environment.output(3, "Typedef'ing " + name + " , hash: " + type.hashCode());
        if (!typemap.containsKey(name)) {
            if (type.typeSpec() instanceof ScopedName) {
                if (((ScopedName)type.typeSpec()).resolvedTypeSpec() != null) {
                    typemap.put(name, ((ScopedName)type.typeSpec()).resolvedTypeSpec());
                } else {
                    typemap.put(name, type.typeSpec());
                }
            } else {
                typemap.put(name, type.typeSpec());
            }
        }
    }

    public static void replaceForwardDeclaration(String name, TypeSpec type) {
        if (typemap.containsKey(name)) {
            typemap.remove(name);
            try {
                TypeMap.typedef(name, type);
            }
            catch (NameAlreadyDefined nad) {
                nad.printStackTrace();
                parser.fatal_error("TypeMap.replaceForwardDeclaration, serious error!", null);
            }
        } else {
            throw new RuntimeException("Could not find forward declaration!");
        }
    }

    TypeMap() {
    }
}

