/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ArrayDeclarator;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeDeclarator;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.parser;

class TypeDef
extends TypeDeclaration {
    public TypeDeclarator type_declarator;
    private Vector typeSpecs = new Vector();

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? new String(s + "." + this.pack_name) : s;
        this.type_declarator.setPackage(s);
    }

    public void set_included(boolean i) {
        this.included = i;
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            System.err.println("was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        this.type_declarator.setEnclosingSymbol(s);
    }

    public void parse() {
        Enumeration e = this.type_declarator.declarators.v.elements();
        while (e.hasMoreElements()) {
            Declarator d = (Declarator)e.nextElement();
            d.escapeName();
            try {
                AliasTypeSpec alias = new AliasTypeSpec(this.type_declarator.type_spec());
                if (d.d instanceof ArrayDeclarator) {
                    alias = new AliasTypeSpec(new ArrayTypeSpec(IdlSymbol.new_num(), alias.originalType(), (ArrayDeclarator)d.d, this.pack_name));
                    alias.parse();
                } else if (!e.hasMoreElements()) {
                    alias.parse();
                }
                alias.set_name(d.name());
                alias.setPackage(this.pack_name);
                alias.setEnclosingSymbol(this.enclosing_symbol);
                alias.set_token(d.d.get_token());
                alias.set_included(this.included);
                this.typeSpecs.addElement(alias);
                NameTable.define(d.full_name(), "type");
                TypeMap.typedef(d.full_name(), alias);
            }
            catch (NameAlreadyDefined n) {
                parser.error("TypeDef'd name " + d.name() + " already defined. ", d.token);
            }
        }
    }

    public void print(PrintWriter ps) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        Enumeration e = this.typeSpecs.elements();
        while (e.hasMoreElements()) {
            ((AliasTypeSpec)e.nextElement()).print(ps);
        }
    }

    public TypeDef(int num) {
        super(num);
        this.pack_name = "";
    }
}

