/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class ShortType
extends IntType {
    public String typeName() {
        return "short";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        if (this.unsigned) {
            return 4;
        }
        return 2;
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.ShortHolder";
    }

    public String printReadExpression(String ps) {
        if (this.unsigned) {
            return ps + ".read_ushort()";
        }
        return ps + ".read_short()";
    }

    public String printReadStatement(String var_name, String ps) {
        if (this.unsigned) {
            return var_name + "=" + ps + ".read_ushort();";
        }
        return var_name + "=" + ps + ".read_short();";
    }

    public String printWriteStatement(String var_name, String ps) {
        if (this.unsigned) {
            return ps + ".write_ushort(" + var_name + ");";
        }
        return ps + ".write_short(" + var_name + ");";
    }

    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ushort";
        }
        return "insert_short";
    }

    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ushort";
        }
        return "extract_short";
    }

    public ShortType(int num) {
        super(num);
    }
}

