/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.idl.AttrDecl;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definition;
import org.jacorb.idl.Environment;
import org.jacorb.idl.ExceptionHolderTypeSpec;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.InterfaceBody;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.OpDecl;
import org.jacorb.idl.ParamDecl;
import org.jacorb.idl.ReplyHandlerTypeSpec;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SimpleDeclarator;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VoidTypeSpec;
import org.jacorb.idl.parser;

public class ReplyHandler
extends Interface {
    private final void createInheritanceSpec(SymbolList source) {
        this.inheritanceSpec = new SymbolList(IdlSymbol.new_num());
        if (source.v.isEmpty()) {
            ScopedName n = new ScopedName(IdlSymbol.new_num());
            n.pack_name = "org.omg.Messaging";
            n.typeName = "ReplyHandler";
            this.inheritanceSpec.v.add(n);
        } else {
            Iterator i = ((AbstractList)source.v).iterator();
            while (i.hasNext()) {
                ScopedName n1 = (ScopedName)i.next();
                ScopedName n2 = new ScopedName(IdlSymbol.new_num());
                n2.pack_name = n1.pack_name;
                n2.typeName = "AMI_" + n1.name + "Handler";
                this.inheritanceSpec.v.add(n2);
            }
        }
    }

    private final void createOperations(Interface parent) {
        Iterator i = ((AbstractList)parent.body.v).iterator();
        while (i.hasNext()) {
            Declaration d = ((Definition)i.next()).get_declaration();
            if (d instanceof OpDecl) {
                this.createOperationsFor((OpDecl)d);
                continue;
            }
            if (!(d instanceof AttrDecl)) continue;
            this.createOperationsFor((AttrDecl)d);
        }
    }

    private final void createOperationsFor(OpDecl d) {
        ArrayList<ParamDecl> paramDecls = new ArrayList<ParamDecl>();
        if (!(d.opTypeSpec.type_spec instanceof VoidTypeSpec)) {
            paramDecls.add(new ParamDecl(1, d.opTypeSpec, "ami_return_val"));
        }
        Iterator i = ((AbstractList)d.paramDecls).iterator();
        while (i.hasNext()) {
            ParamDecl p = (ParamDecl)i.next();
            if (p.paramAttribute == 1) continue;
            paramDecls.add(new ParamDecl(1, p.paramTypeSpec, p.simple_declarator));
        }
        this.body.addDefinition(new OpDecl(this, d.name, paramDecls));
        this.body.addDefinition(new OpDecl(this, d.name + "_excep", this.excepParameterList()));
    }

    private final void createOperationsFor(AttrDecl d) {
        Iterator i = ((AbstractList)d.declarators.v).iterator();
        while (i.hasNext()) {
            SimpleDeclarator decl = (SimpleDeclarator)i.next();
            this.body.addDefinition(new OpDecl(this, "get_" + decl.name, this.parameterList(d.param_type_spec, "ami_return_val")));
            this.body.addDefinition(new OpDecl(this, "get_" + decl.name + "_excep", this.excepParameterList()));
            if (d.readOnly) continue;
            this.body.addDefinition(new OpDecl(this, "set_" + decl.name, new ArrayList()));
            this.body.addDefinition(new OpDecl(this, "set_" + decl.name + "_excep", this.excepParameterList()));
        }
    }

    private final List parameterList(TypeSpec type, String name) {
        ArrayList<ParamDecl> result = new ArrayList<ParamDecl>();
        result.add(new ParamDecl(1, type, name));
        return result;
    }

    private final List excepParameterList() {
        return this.parameterList(new ExceptionHolderTypeSpec(IdlSymbol.new_num()), "excep_holder");
    }

    public String id() {
        return "IDL:" + this.full_name().replace('.', '/') + ":1.0";
    }

    public void parse() {
        if (!NameTable.defined("org.omg.Messaging.ReplyHandler")) {
            try {
                NameTable.define("org.omg.Messaging.ReplyHandler", "type");
                TypeMap.typedef("org.omg.Messaging.ReplyHandler", new ReplyHandlerTypeSpec(IdlSymbol.new_num()));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        ConstrTypeSpec ctspec = new ConstrTypeSpec(this);
        try {
            NameTable.define(this.full_name(), "interface");
            TypeMap.typedef(this.full_name(), ctspec);
        }
        catch (NameAlreadyDefined e) {
            Environment.output(4, e);
            parser.error("Interface " + this.typeName() + " already defined", this.token);
        }
        this.body.parse();
    }

    public void print(PrintWriter ps) {
        this.printInterface();
        this.printOperations();
        this.printStub();
        this.printHelper();
        this.printImplSkeleton();
        this.printTieSkeleton();
    }

    public ReplyHandler(Interface parent) {
        super(IdlSymbol.new_num());
        this.name = "AMI_" + parent.name + "Handler";
        this.pack_name = parent.pack_name;
        this.createInheritanceSpec(parent.inheritanceSpec);
        this.body = new InterfaceBody(IdlSymbol.new_num());
        this.body.set_name(this.name);
        this.body.my_interface = this;
        this.body.setEnclosingSymbol(this);
        this.body.inheritance_spec = this.inheritanceSpec;
        this.createOperations(parent);
    }
}

