/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IllegalRedefinition;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

class NameTable {
    private static Hashtable h = new Hashtable(10000);
    private static Hashtable shadows = new Hashtable();
    private static Hashtable ancestors = new Hashtable();
    private static Hashtable operationSources = new Hashtable();
    private static String s = "";
    public static Hashtable parsed_interfaces = new Hashtable();

    public static void init() {
        h.clear();
        operationSources.clear();
        shadows.clear();
        ancestors.clear();
        operationSources.clear();
        parsed_interfaces.clear();
        h.put("char", "type");
        h.put("boolean", "type");
        h.put("long", "type");
        h.put("long", "type");
        h.put("short", "type");
        h.put("int", "type");
        h.put("float", "type");
        h.put("double", "type");
        h.put("byte", "type");
        h.put("void", "type");
        h.put("org.omg.CORBA.Any", "type");
        h.put("org.omg.CORBA.Object", "interface");
    }

    private static final void checkScopingRules(String name, String kind) throws NameAlreadyDefined {
        Environment.output(1, "NameTable.checkScopingRules:  " + name + " kind: " + kind);
        if (kind.equals("argument")) {
            return;
        }
        StringTokenizer strtok = new StringTokenizer(name.toUpperCase(), ".");
        String[] scopes = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            scopes[i] = strtok.nextToken();
            ++i;
        }
        Environment.output(1, "NameTable.checkScopingRules2:  " + name + " kind: " + kind);
        if (scopes.length > 1 && scopes[scopes.length - 2].equals(scopes[scopes.length - 1])) {
            throw new IllegalRedefinition(name);
        }
    }

    public static void define(String name, String kind) throws NameAlreadyDefined {
        Environment.output(3, "NameTable.define2: putting " + name + " kind " + kind + " hash: " + name.hashCode());
        if (h.containsKey(name) || h.containsKey(name.toUpperCase())) {
            if (kind.equals("module")) {
                return;
            }
            if (!shadows.containsKey(name) || kind.equals("operation") || kind.equals("interface")) {
                throw new NameAlreadyDefined(name);
            }
            shadows.remove(name);
            h.remove(name);
        }
        if (parser.strict_names) {
            NameTable.checkScopingRules(name, kind);
        }
        h.put(name, kind);
        h.put(name.toUpperCase(), "dummy");
        if (kind.equals("operation")) {
            operationSources.put(name, name.substring(0, name.lastIndexOf(".")));
        }
    }

    private static final void defineInheritedOperation(String name, String inheritedFrom) throws NameAlreadyDefined {
        if (h.containsKey(name)) {
            String source = null;
            String opName = name.indexOf(".") < 0 ? name : name.substring(name.lastIndexOf(".") + 1);
            String presentOpName = name;
            while ((source = (String)operationSources.get(presentOpName)) != null) {
                if (presentOpName.equals(source + "." + opName)) break;
                presentOpName = source + "." + opName;
            }
            Environment.output(3, "NameTable source of " + name + " is " + presentOpName);
            String otherOpName = inheritedFrom + "." + opName;
            while ((source = (String)operationSources.get(otherOpName)) != null) {
                if (otherOpName.equals(source + "." + opName)) break;
                otherOpName = source + "." + opName;
            }
            Environment.output(3, "NameTable other source of " + name + " is " + otherOpName);
            if (otherOpName.equals(presentOpName)) {
                return;
            }
            throw new NameAlreadyDefined(name);
        }
        h.put(name, "operation");
        operationSources.put(name, inheritedFrom);
    }

    private static final void defineShadows(Hashtable shadowEntries) throws NameAlreadyDefined {
        String firstViolation = null;
        Enumeration e = shadowEntries.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String kind = (String)shadowEntries.get(name);
            if (h.containsKey(name)) {
                firstViolation = name;
                continue;
            }
            h.put(name, kind);
            Environment.output(4, "Put shadow " + name);
            shadows.put(name, "");
            if (!kind.equals("operation")) continue;
            operationSources.put(name, name.substring(0, name.lastIndexOf(".")));
        }
        if (firstViolation != null) {
            throw new NameAlreadyDefined(firstViolation);
        }
    }

    public static synchronized void inheritFrom(String name, SymbolList ancestors) throws NameAlreadyDefined {
        Hashtable<String, String> shadowNames = new Hashtable<String, String>();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String s = null;
            if (key.indexOf(46) <= 0) continue;
            s = key.substring(0, key.lastIndexOf(46));
            Enumeration i = ancestors.v.elements();
            while (i.hasMoreElements()) {
                String anc = ((ScopedName)i.nextElement()).resolvedName();
                if (!s.equals(anc)) continue;
                String kind = (String)h.get(key);
                Environment.output(4, "NameTable.inheritFrom ancestor " + anc + " : key " + key + " kind " + kind);
                String shadowKey = name + key.substring(key.lastIndexOf(46));
                shadowNames.put(shadowKey, kind);
                if (kind.startsWith("type")) {
                    Environment.output(4, "- NameTable.inherit type from:  " + key);
                    TypeSpec t = TypeMap.map(anc + key.substring(key.lastIndexOf(46)));
                    if (t != null) {
                        TypeMap.typedef(name + key.substring(key.lastIndexOf(46)), t);
                    }
                    shadowNames.put(name + key.substring(key.lastIndexOf(46)), kind);
                } else if (kind.equals("operation")) {
                    Environment.output(4, "- NameTable.inherit operation from:  " + key);
                    NameTable.defineInheritedOperation(name + key.substring(key.lastIndexOf(46)), anc);
                }
                if (NameTable.defined(key)) continue;
                throw new RuntimeException("CompilerError!");
            }
        }
        try {
            NameTable.defineShadows(shadowNames);
        }
        catch (NameAlreadyDefined nad) {
            Environment.output(4, nad);
        }
    }

    public static boolean defined(String name) {
        return h.containsKey(name);
    }

    public static boolean defined(String name, String kind) {
        if (!h.containsKey(name)) {
            return false;
        }
        String k = (String)h.get(name);
        return k.compareTo(kind) == 0;
    }

    static boolean baseType(String _s) {
        return _s.equals("int") || _s.equals("short") || _s.equals("long") || _s.equals("float") || _s.equals("boolean") || _s.equals("double") || _s.equals("byte") || _s.equals("char") || _s.equals("void") || _s.equals("org.omg.CORBA.Object") || _s.equals("org.omg.CORBA.Any") || _s.equals("<anon>");
    }

    public static void print(PrintWriter ps) {
    }

    NameTable() {
    }
}

