/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Definitions;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

class Module
extends Declaration
implements Scope {
    public Definitions spec;
    private ScopeData scopeData;
    private String unreplacedName = null;

    public void setScopeData(ScopeData data) {
        this.scopeData = data;
    }

    public ScopeData getScopeData() {
        return this.scopeData;
    }

    public void setPackage(String s) {
        if (this.unreplacedName == null) {
            this.unreplacedName = s;
        }
        s = parser.pack_replace(s);
        if (this.pack_name.length() > 0) {
            this.pack_name = s + "." + this.pack_name;
            this.spec.setPackage(s);
        } else {
            this.pack_name = s;
            if (lexer.needsJavaEscape(this)) {
                this.pack_name = "_" + s;
            }
            this.name = this.pack_name;
            this.spec.setPackage(this.pack_name);
        }
    }

    String full_name() {
        return this.pack_name;
    }

    public void set_included(boolean i) {
        this.included = i;
        this.spec.set_included(i);
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        this.spec.setEnclosingSymbol(this);
    }

    public void parse() {
        try {
            NameTable.define(this.full_name(), "module");
        }
        catch (NameAlreadyDefined nad) {
            Environment.output(4, nad);
            parser.error("Module name " + this.full_name() + " already defined", this.token);
        }
        this.spec.parse();
    }

    public void print(PrintWriter ps) {
        if (parser.generateIR) {
            try {
                String path = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                PrintWriter moduleWriter = new PrintWriter(new FileWriter(new File(dir, "_" + this.name + "Module.java")));
                moduleWriter.println("package " + this.pack_name + ";\n");
                moduleWriter.println("/** \n * IR module information, generated by the JacORB IDL compiler \n */");
                moduleWriter.println("public class _" + this.name + "Module {}");
                moduleWriter.close();
            }
            catch (IOException io) {
                Environment.output(2, io);
            }
        }
        this.spec.print(ps);
    }

    public String originalModuleName() {
        return this.unreplacedName;
    }

    public Module(int num) {
        super(num);
        this.pack_name = "";
    }
}

