/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.Operation;
import org.jacorb.idl.TypeSpec;

class Method
implements Operation {
    private TypeSpec resultType;
    private TypeSpec parameterType;
    private String name;
    private boolean pseudo;

    public String name() {
        return this.name;
    }

    public String opName() {
        if (this.resultType != null) {
            return "_get_" + this.name;
        }
        return "_set_" + this.name;
    }

    public String signature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + "(");
        if (this.parameterType != null) {
            sb.append(this.parameterType.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public void printSignature(PrintWriter ps) {
        this.printSignature(ps, this.pseudo);
    }

    public void printSignature(PrintWriter ps, boolean printModifiers) {
        ps.print("\t");
        if (printModifiers) {
            ps.print("public abstract ");
        }
        if (this.resultType != null) {
            ps.print(this.resultType.toString());
            ps.println(" " + this.name + "();");
        } else {
            ps.print("void " + this.name + "(");
            ps.print(this.parameterType.toString());
            ps.println(" arg);");
        }
    }

    public void printMethod(PrintWriter ps, String classname, boolean is_local) {
        ps.print("\tpublic ");
        if (this.resultType != null) {
            ps.print(this.resultType.toString());
            ps.println(" " + this.name + "()");
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            if (!is_local) {
                ps.println("\t\tif(! this._is_local())");
                ps.println("\t\t{");
                ps.println("\t\t\torg.omg.CORBA.portable.InputStream _is = null;");
                ps.println("\t\t\ttry");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request(\"_get_" + this.name + "\",true);");
                ps.println("\t\t\t\t_is = _invoke(_os);");
                TypeSpec ts = this.resultType.typeSpec();
                ps.println("\t\t\t\treturn " + ts.printReadExpression("_is") + ";");
                ps.println("\t\t\t}");
                ps.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
                ps.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\tString _id = _ax.getId();");
                ps.println("\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
                ps.println("\t\t\t}");
                ps.println("\t\t\tfinally");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\tthis._releaseReply(_is);");
                ps.println("\t\t\t}");
                ps.println("\t\t}\n");
                ps.println("\t\telse");
                ps.println("\t\t{");
            }
            ps.println("\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"_get_" + this.name + "\", _opsClass);");
            ps.println("\t\tif( _so == null )");
            ps.println("\t\t\tthrow new org.omg.CORBA.UNKNOWN(\"local invocations not supported!\");");
            ps.println("\t\t" + classname + "Operations _localServant = (" + classname + "Operations)_so.servant;");
            ps.println("\t\t\t" + this.resultType + " _result;");
            ps.println("\t\ttry");
            ps.println("\t\t{");
            ps.println("\t\t\t_result = _localServant." + this.name + "();");
            ps.println("\t\t}");
            ps.println("\t\tfinally");
            ps.println("\t\t{");
            ps.println("\t\t\t_servant_postinvoke(_so);");
            ps.println("\t\t}");
            ps.println("\t\treturn _result;");
            ps.println("\t\t}");
            if (!is_local) {
                ps.println("\t\t}\n");
            }
            ps.println("\t}\n");
        } else {
            ps.print("void " + this.name + "(" + this.parameterType.toString());
            ps.println(" a)");
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            if (!is_local) {
                ps.println("\t\tif(! this._is_local())");
                ps.println("\t\t{");
                ps.println("\t\t\torg.omg.CORBA.portable.InputStream _is = null;");
                ps.println("\t\t\ttry");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request(\"_set_" + this.name + "\",true);");
                ps.println("\t\t\t\t" + this.parameterType.typeSpec().printWriteStatement("a", "_os"));
                ps.println("\t\t\t\t_is = _invoke(_os);");
                ps.println("\t\t\t\treturn;");
                ps.println("\t\t\t}");
                ps.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
                ps.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\tString _id = _ax.getId();");
                ps.println("\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
                ps.println("\t\t\t}");
                ps.println("\t\t\tfinally");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\tthis._releaseReply(_is);");
                ps.println("\t\t\t}");
                ps.println("\t\t}\n");
                ps.println("\t\telse");
                ps.println("\t\t{");
            }
            ps.println("\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"_set_" + this.name + "\", _opsClass);");
            ps.println("\t\t\tif( _so == null )");
            ps.println("\t\t\t\tthrow new org.omg.CORBA.UNKNOWN(\"local invocations not supported!\");");
            ps.println("\t\t\t" + classname + "Operations _localServant = (" + classname + "Operations)_so.servant;");
            ps.println("\t\t\t\ttry");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\t_localServant." + this.name + "(a);");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tfinally");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\t_servant_postinvoke(_so);");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\treturn;");
            ps.println("\t\t\t}");
            if (!is_local) {
                ps.println("\t\t}\n");
            }
            ps.println("\t}\n");
        }
    }

    public void print_sendc_Method(PrintWriter ps, String classname) {
        ps.print("\tpublic void sendc_");
        if (this.resultType != null) {
            ps.print("get_" + this.name);
            ps.println("(AMI_" + classname + "Handler ami_handler)");
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request(\"_get_" + this.name + "\",true);");
            ps.println("\t\t\t\t((org.jacorb.orb.Delegate)_get_delegate()).invoke(this, _os, ami_handler);");
            ps.println("\t\t\t\treturn;");
            ps.println("\t\t\t}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\tString _id = _ax.getId();");
            ps.println("\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
            ps.println("\t}\n");
        } else {
            ps.print("set_" + this.name);
            ps.print("(AMI_" + classname + "Handler ami_handler, ");
            ps.println(this.parameterType.toString() + " attr_" + this.name + ")");
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request(\"_set_" + this.name + "\",true);");
            ps.println("\t\t\t\t" + this.parameterType.typeSpec().printWriteStatement("attr_" + this.name, "_os"));
            ps.println("\t\t\t\t((org.jacorb.orb.Delegate)_get_delegate()).invoke(this, _os, ami_handler);");
            ps.println("\t\t\t\treturn;");
            ps.println("\t\t\t}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\tString _id = _ax.getId();");
            ps.println("\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
            ps.println("\t}\n");
        }
    }

    public void printDelegatedMethod(PrintWriter ps) {
        ps.print("\tpublic ");
        if (this.resultType != null) {
            ps.print(this.resultType.toString());
            ps.println(" " + this.name + "()");
            ps.println("\t{");
            ps.println("\t\treturn _delegate." + this.name + "();");
            ps.println("\t}\n");
        } else {
            ps.print("void " + this.name + "(" + this.parameterType.toString());
            ps.println(" a)");
            ps.println("\t{");
            ps.println("\t\t_delegate." + this.name + "(a);");
            ps.println("\t}\n");
        }
    }

    public void printInvocation(PrintWriter ps) {
        ps.println("\t\t\t_out = handler.createReply();");
        ps.print("\t\t\t");
        if (this.resultType != null) {
            ps.println(this.resultType.typeSpec().printWriteStatement(this.name + "()", "_out"));
        } else {
            ps.println(this.name + "(" + this.parameterType.printReadExpression("_input") + ");");
        }
    }

    public Method(TypeSpec res, TypeSpec params, String name, boolean pseudo) {
        this.resultType = res;
        this.parameterType = params;
        this.name = name;
        this.pseudo = pseudo;
    }
}

