/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ArrayDeclarator;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SequenceType;
import org.jacorb.idl.StringType;
import org.jacorb.idl.StructType;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.parser;

class Member
extends Declaration {
    TypeSpec type_spec;
    public SymbolList declarators;
    public Vector extendVector;
    public TypeDeclaration containingType;
    public Declarator declarator;

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? new String(s + "." + this.pack_name) : s;
        this.type_spec.setPackage(s);
        this.declarators.setPackage(s);
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        this.enclosing_symbol = s;
        this.type_spec.setEnclosingSymbol(s);
        Enumeration e = this.declarators.v.elements();
        while (e.hasMoreElements()) {
            ((Declarator)e.nextElement()).setEnclosingSymbol(s);
        }
    }

    public void setContainingType(TypeDeclaration t) {
        this.containingType = t;
    }

    public void setExtendVector(Vector v) {
        this.extendVector = v;
    }

    public Member extractMember(Declarator d) {
        Member result = new Member(IdlSymbol.new_num());
        result.declarator = d;
        return result;
    }

    public void parse() {
        boolean clone_and_parse = true;
        if (this.extendVector == null) {
            throw new RuntimeException("Compiler Error: extendVector not set!");
        }
        if (this.type_spec.typeSpec() instanceof ScopedName) {
            this.token = this.type_spec.typeSpec().get_token();
            String name = this.type_spec.typeSpec().toString();
            this.type_spec = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec();
            this.enclosing_symbol.addImportedName(name, this.type_spec);
            if (this.type_spec instanceof AliasTypeSpec) {
                SequenceType sequenceTS;
                AliasTypeSpec aliasTS = (AliasTypeSpec)this.type_spec;
                if (aliasTS.originalType instanceof SequenceType && (sequenceTS = (SequenceType)aliasTS.originalType).elementTypeSpec().typeName().equals(this.containingType.typeName())) {
                    sequenceTS.setRecursive();
                }
            }
            clone_and_parse = false;
            if (this.type_spec instanceof ConstrTypeSpec && ((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec instanceof StructType && ((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec.typeName().equals(this.containingType.typeName())) {
                parser.fatal_error("Illegal type recursion (use sequence<" + this.containingType.typeName() + "> instead)", this.token);
            }
        } else if (this.type_spec.typeSpec() instanceof SequenceType) {
            TypeSpec ts = ((SequenceType)this.type_spec.typeSpec()).elementTypeSpec().typeSpec();
            SequenceType seqTs = (SequenceType)this.type_spec.typeSpec();
            while (ts instanceof SequenceType) {
                seqTs = (SequenceType)ts;
                ts = ((SequenceType)ts.typeSpec()).elementTypeSpec().typeSpec();
            }
            if (ScopedName.isRecursionScope(ts.typeName())) {
                seqTs.setRecursive();
            }
        } else if (this.type_spec instanceof ConstrTypeSpec) {
            this.type_spec.parse();
        }
        String tokName = null;
        if (this.token != null && this.token.line_val != null && (tokName = this.token.line_val.trim()).length() == 0) {
            tokName = null;
        }
        Enumeration e = this.declarators.v.elements();
        while (e.hasMoreElements()) {
            Declarator d = (Declarator)e.nextElement();
            String dName = d.name();
            if (tokName != null && dName.equalsIgnoreCase(tokName)) {
                parser.fatal_error("Declarator " + dName + " already defined in scope.", this.token);
            }
            Member m = this.extractMember(d);
            TypeSpec ts = this.type_spec.typeSpec();
            if (clone_and_parse || d.d instanceof ArrayDeclarator) {
                if (d.d instanceof ArrayDeclarator) {
                    ts = new ArrayTypeSpec(IdlSymbol.new_num(), ts, (ArrayDeclarator)d.d, this.pack_name);
                    ts.parse();
                } else if (!(ts instanceof BaseType)) {
                    if (!((ts = (TypeSpec)ts.clone()) instanceof ConstrTypeSpec)) {
                        ts.set_name(d.name());
                    }
                    if (!e.hasMoreElements()) {
                        ts.parse();
                    }
                }
            }
            if (!(d.d instanceof ArrayDeclarator)) {
                try {
                    NameTable.define(this.containingType + "." + d.name(), "declarator");
                }
                catch (NameAlreadyDefined nad) {
                    parser.fatal_error("Declarator " + d.name() + " already defined in scope.", this.token);
                }
            }
            m.type_spec = ts;
            m.pack_name = this.pack_name;
            m.name = this.name;
            this.extendVector.addElement(m);
        }
        this.declarators = null;
    }

    public void print(PrintWriter ps) {
        this.member_print(ps, "\tpublic ");
    }

    public void member_print(PrintWriter ps, String prefix) {
        if (this.type_spec.typeSpec() instanceof ConstrTypeSpec && !(((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec.declaration() instanceof Interface) && !(((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec.declaration() instanceof Value) || this.type_spec.typeSpec() instanceof SequenceType || this.type_spec.typeSpec() instanceof ArrayTypeSpec) {
            this.type_spec.print(ps);
        }
        if (this.type_spec.typeSpec() instanceof StringType) {
            ps.print(prefix + this.type_spec.toString() + " " + this.declarator.toString() + " = \"\";");
        } else {
            ps.print(prefix + this.type_spec.toString() + " " + this.declarator.toString() + ";");
        }
    }

    public TypeSpec typeSpec() {
        return this.type_spec.typeSpec();
    }

    public Member(int num) {
        super(num);
    }
}

