/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.TypeSpec;

class LongLongType
extends IntType {
    public Object clone() {
        return new LongLongType(IdlSymbol.new_num());
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public String typeName() {
        return "long";
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        if (this.unsigned) {
            return 24;
        }
        return 23;
    }

    public String toString() {
        return this.typeName();
    }

    public String holderName() {
        return "org.omg.CORBA.LongHolder";
    }

    public String printReadExpression(String strname) {
        if (this.unsigned) {
            return strname + ".read_ulonglong()";
        }
        return strname + ".read_longlong()";
    }

    public String printReadStatement(String var_name, String strname) {
        if (this.unsigned) {
            return var_name + "=" + strname + ".read_ulonglong();";
        }
        return var_name + "=" + strname + ".read_longlong();";
    }

    public String printWriteStatement(String var_name, String strname) {
        if (this.unsigned) {
            return strname + ".write_ulonglong(" + var_name + ");";
        }
        return strname + ".write_longlong(" + var_name + ");";
    }

    public String printInsertExpression() {
        if (this.unsigned) {
            return "insert_ulonglong";
        }
        return "insert_longlong";
    }

    public String printExtractExpression() {
        if (this.unsigned) {
            return "extract_ulonglong";
        }
        return "extract_longlong";
    }

    public LongLongType(int num) {
        super(num);
    }
}

