/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java_cup.runtime.float_token;
import java_cup.runtime.long_token;
import java_cup.runtime.token;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.Environment;
import org.jacorb.idl.FixedPointConstType;
import org.jacorb.idl.FloatPtType;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.LongType;
import org.jacorb.idl.ShortType;
import org.jacorb.idl.StringType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.fixed_token;
import org.jacorb.idl.parser;

class Literal
extends IdlSymbol {
    public String string;
    public boolean wide;
    public token token;
    private ConstDecl declared_in;

    public void setDeclaration(ConstDecl declared_in) {
        this.declared_in = declared_in;
    }

    public void parse() {
        if (this.declared_in != null) {
            TypeSpec ts = this.declared_in.const_type.symbol.typeSpec();
            Environment.output(2, "Literal " + ts.getClass().getName() + " " + (this.token != null ? this.token.getClass().getName() : "<no token>"));
            if (ts instanceof FloatPtType && !(this.token instanceof float_token)) {
                parser.error("Expecting float/double constant!");
            } else if (ts instanceof FixedPointConstType && !(this.token instanceof fixed_token)) {
                parser.error("Expecting fixed point constant (perhaps a missing \"d\")!");
            } else if (ts instanceof StringType) {
                if (this.wide && !((StringType)ts).isWide()) {
                    parser.error("Illegal assignment of wide string constant to string!");
                }
            } else if ((ts instanceof LongType || ts instanceof ShortType) && this.token instanceof long_token) {
                parser.error("Illegal assignment from long long");
            }
        }
    }

    public String toString() {
        return Literal.escapeBackslash(this.string);
    }

    public void print(PrintWriter ps) {
        ps.print(this.string);
    }

    public static String escapeBackslash(String name) {
        StringBuffer result = new StringBuffer();
        char[] chrs = name.toCharArray();
        if (chrs[0] == '\"') {
            return name;
        }
        int i = 0;
        while (i < chrs.length) {
            switch (chrs[i]) {
                case '\n': {
                    result.append('\\');
                    result.append('n');
                    break;
                }
                case '\t': {
                    result.append('\\');
                    result.append('t');
                    break;
                }
                case '\u000b': {
                    result.append('\\');
                    result.append("013");
                    break;
                }
                case '\b': {
                    result.append('\\');
                    result.append('b');
                    break;
                }
                case '\r': {
                    result.append('\\');
                    result.append('r');
                    break;
                }
                case '\f': {
                    result.append('\\');
                    result.append('f');
                    break;
                }
                case '\u0007': {
                    result.append('\\');
                    result.append("007");
                    break;
                }
                case '\\': {
                    result.append('\\');
                    result.append('\\');
                    break;
                }
                case '\u0000': {
                    result.append('\\');
                    result.append('0');
                    break;
                }
                case '\'': {
                    if (i == 1) {
                        result.append('\\');
                        result.append('\'');
                        break;
                    }
                    result.append(chrs[i]);
                    break;
                }
                case '\"': {
                    if (i == 1) {
                        result.append('\\');
                        result.append('\"');
                        break;
                    }
                    result.append(chrs[i]);
                    break;
                }
                default: {
                    result.append(chrs[i]);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public Literal(int num) {
        super(num);
    }
}

