/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class JacIDL
extends MatchingTask {
    private File _destdir;
    private File _srcdir;
    private Path _includepath;
    private String _packageprefix;
    private int _debuglevel;
    private boolean _generateir;
    private boolean _generateincluded;
    private boolean _parseonly;
    private boolean _noskel;
    private boolean _nostub;
    private boolean _sloppyforward;
    private boolean _sloppynames;
    private boolean _includestate;
    private boolean _nofinal;
    private boolean _ami_callback;
    private List _defines = new ArrayList();
    private List _undefines = new ArrayList();
    private File[] _compileList = new File[0];

    public void setDestdir(File dir) {
        this._destdir = dir;
    }

    public void setSrcdir(File dir) {
        this._srcdir = dir;
    }

    public void setIncludepath(Path path) {
        this._includepath = path;
    }

    public void setPackageprefix(String prefix) {
        this._packageprefix = prefix;
    }

    public void setDebuglevel(int level) {
        this._debuglevel = level;
    }

    public void setGenerateir(boolean flag) {
        this._generateir = flag;
    }

    public void setAll(boolean flag) {
        this._generateincluded = flag;
    }

    public void setParseonly(boolean flag) {
        this._parseonly = flag;
    }

    public void setNoskel(boolean flag) {
        this._noskel = flag;
    }

    public void setNostub(boolean flag) {
        this._nostub = flag;
    }

    public void setSloppyforward(boolean flag) {
        this._sloppyforward = flag;
    }

    public void setSloppynames(boolean flag) {
        this._sloppynames = flag;
    }

    public void setNofinal(boolean flag) {
        this._nofinal = flag;
    }

    public void setAmi_callback(boolean flag) {
        this._ami_callback = flag;
    }

    public void addDefine(Environment.Variable def) {
        this._defines.add(def);
    }

    public void addUndefine(Environment.Variable def) {
        this._undefines.add(def);
    }

    public void execute() throws BuildException {
        parser myparser = null;
        parser.init();
        if (!this._destdir.exists()) {
            this._destdir.mkdirs();
        }
        parser.out_dir = this._destdir.getPath();
        parser.generateIncluded = this._generateincluded;
        parser.generateIR = this._generateir;
        parser.parse_only = this._parseonly;
        parser.generate_skeletons = !this._noskel;
        parser.generate_stubs = !this._nostub;
        parser.sloppy = this._sloppyforward;
        parser.strict_names = !this._sloppynames;
        parser.setGenerateFinalCode(!this._nofinal);
        parser.generate_ami_callback = this._ami_callback;
        if (this._includepath != null) {
            String[] includeList = this._includepath.list();
            int i = 0;
            while (i < includeList.length) {
                File incDir = ((ProjectComponent)this).project.resolveFile(includeList[i]);
                if (!incDir.exists()) {
                    throw new BuildException("include directory \"" + incDir.getPath() + "\" does not exist !", ((Task)this).location);
                }
                ++i;
            }
            GlobalInputStream.setIncludePath(this._includepath.toString());
        }
        if (this._packageprefix != null && this._packageprefix.length() > 0) {
            parser.package_prefix = this._packageprefix;
        }
        this.resetFileLists();
        DirectoryScanner ds = this.getDirectoryScanner(this._srcdir);
        String[] files = ds.getIncludedFiles();
        this.scanFiles(files);
        try {
            if (this._compileList != null) {
                int i = 0;
                while (i < this._compileList.length) {
                    String fileName = this._compileList[i].getPath();
                    this.log("processing idl file: " + fileName);
                    Environment.output(4, fileName);
                    GlobalInputStream.init();
                    GlobalInputStream.setInput(fileName);
                    lexer.reset();
                    NameTable.init();
                    ConstDecl.init();
                    TypeMap.init();
                    this.setupDefines();
                    myparser = new parser();
                    myparser.parse();
                    ++i;
                }
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void resetFileLists() {
        this._compileList = new File[0];
    }

    protected void scanFiles(String[] files) throws BuildException {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.idl");
        m.setTo("*.java");
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        File[] newfiles = sfs.restrictAsFiles(files, this._srcdir, this._destdir, (FileNameMapper)m);
        this._compileList = new File[newfiles.length];
        int i = 0;
        while (i < newfiles.length) {
            this.log("scan file: " + newfiles[i].getPath());
            File file = newfiles[i];
            if (!file.exists()) {
                throw new BuildException("The input file \"" + file.getPath() + "\" does not exist !");
            }
            this._compileList[i] = file;
            ++i;
        }
    }

    public File[] getFileList() {
        return this._compileList;
    }

    private static final boolean fileExists(String filename) {
        if (filename == null || filename.length() == 0) {
            return false;
        }
        File file = new File(filename);
        return file.exists() && file.isFile();
    }

    private static final boolean dirExists(File dir) {
        return dir.exists() && dir.isDirectory();
    }

    private final void setupDefines() {
        Environment.Variable prop;
        int i = 0;
        while (i < this._defines.size()) {
            prop = (Environment.Variable)this._defines.get(i);
            String value = prop.getValue();
            if (value == null) {
                value = "1";
            }
            lexer.define(prop.getKey(), value);
            ++i;
        }
        i = 0;
        while (i < this._undefines.size()) {
            prop = (Environment.Variable)this._undefines.get(i);
            lexer.undefine(prop.getKey());
            ++i;
        }
    }

    public JacIDL() {
        parser.command_line = null;
        parser.import_list = new Vector();
        parser.pack_replace = new Hashtable();
        parser.scopes = new Stack();
        parser.include_state = false;
        this._destdir = new File(".");
        this._srcdir = new File(".");
        this._packageprefix = null;
        this._parseonly = false;
        this._generateir = false;
        this._noskel = false;
        this._nostub = false;
        this._generateincluded = false;
        this._nofinal = false;
        this._ami_callback = false;
        this._debuglevel = 0;
    }
}

