/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java_cup.runtime.symbol;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.Environment;
import org.jacorb.idl.Module;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.Scope;
import org.jacorb.idl.ScopeData;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;
import org.jacorb.idl.str_token;

class IdlSymbol
extends symbol
implements Serializable {
    private static int num = 10000;
    protected static final char fileSeparator = System.getProperty("file.separator").charAt(0);
    public String pack_name = "";
    String name = "";
    protected boolean is_pseudo = false;
    protected boolean included = false;
    protected boolean inhibitionFlag = false;
    str_token token;
    protected String _id;
    private String _version;
    protected IdlSymbol enclosing_symbol;
    protected String omg_package_prefix = "";
    private Hashtable imports = new Hashtable();
    String typeName;

    public void set_included(boolean i) {
        this.included = i;
    }

    public boolean is_included() {
        return this.included;
    }

    public void set_pseudo() {
        this.is_pseudo = true;
    }

    public boolean is_pseudo() {
        return this.is_pseudo;
    }

    public void set_token(str_token i) {
        this.token = i;
        if (this.token != null) {
            if (this.token.pragma_prefix.equals("omg.org")) {
                this.omg_package_prefix = "org.omg.";
            }
            this.set_name(this.token.str_val);
        }
    }

    public str_token get_token() {
        return this.token;
    }

    public String name() {
        return this.name;
    }

    public void escapeName() {
        if (!this.name.startsWith("_") && !this.pack_name.startsWith("org.omg") && lexer.strictJavaEscapeCheck(this.name)) {
            this.name = "_" + this.name;
        }
    }

    public boolean isEscaped() {
        return this.name().startsWith("_");
    }

    public String deEscapeName() {
        String tmp = this.name();
        if (tmp.startsWith("_")) {
            tmp = tmp.substring(1);
        }
        return tmp;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        Environment.output(5, "Symbol " + this.name + " of type " + this.getClass().getName() + " enclosed by symbol " + s.getClass().getName());
        this.enclosing_symbol = s;
    }

    public IdlSymbol getEnclosingSymbol() {
        return this.enclosing_symbol;
    }

    public static int new_num() {
        return num++;
    }

    public void set_name(String n) {
        this.name = n;
    }

    String full_name() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            return this.pack_name + "." + this.name;
        }
        return this.name;
    }

    String javaName() {
        if (this.name.length() == 0) {
            return null;
        }
        if (this.pack_name.length() > 0) {
            if (!this.pack_name.startsWith("org.omg")) {
                return this.omg_package_prefix + this.pack_name + "." + this.name;
            }
            return this.pack_name + "." + this.name;
        }
        return this.name;
    }

    public String omgPrefix() {
        return this.omg_package_prefix;
    }

    public void parse() throws ParseException {
    }

    public void print(PrintWriter ps) {
        throw new RuntimeException("--abstract--!");
    }

    public void printImport(PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            Enumeration e = this.imports.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                ps.println("import " + name + ";");
            }
            ps.println();
        }
    }

    public void addImportedAlias(String alias) {
        Environment.output(2, "addImportedAlias " + alias);
        if (alias.indexOf(46) < 0 && !BaseType.isBasicName(alias)) {
            this.imports.put(alias + "Helper", "");
        }
    }

    public void addImportedName(String name) {
        if (name != null && name.indexOf(46) < 0 && !BaseType.isBasicName(name)) {
            this.addImportedName(name, null);
        }
    }

    public void addImportedName(String name, TypeSpec type) {
        if (name != null && name.indexOf(46) < 0 && !BaseType.isBasicName(name)) {
            Environment.output(2, "addImportedName " + name);
            if (type == null || !BaseType.isBasicName(type.toString())) {
                this.imports.put(name, "");
            }
            this.imports.put(name + "Helper", "");
        }
    }

    public void addImportedNameHolder(String name) {
        if (name.indexOf(46) < 0 && !BaseType.isBasicName(name)) {
            Environment.output(2, "addImportedNameHolder " + name);
            this.imports.put(name, "");
        }
    }

    public void setPrintPhaseNames() {
        if (this.pack_name.length() > 0) {
            this.typeName = ScopedName.unPseudoName(this.pack_name + "." + this.name);
            if (!this.typeName.startsWith("org.omg")) {
                this.typeName = this.omg_package_prefix + this.typeName;
            }
            this.pack_name = this.typeName.substring(0, this.typeName.lastIndexOf("."));
        } else {
            this.typeName = ScopedName.unPseudoName(this.name);
        }
        Environment.output(2, "setPrintPhaseNames: pack_name " + this.pack_name + ", name " + this.name + " typename " + this.typeName);
    }

    public void printIdMethod(PrintWriter ps) {
        ps.println("\tpublic static String id()");
        ps.println("\t{");
        ps.println("\t\treturn \"" + this.id() + "\";");
        ps.println("\t}");
    }

    String id() {
        Environment.output(2, "Id for name " + this.name);
        IdlSymbol enc = this.enclosing_symbol;
        StringBuffer sb = new StringBuffer();
        if (this._id == null) {
            while (enc != null) {
                str_token t = enc.get_token();
                if (t == null) {
                    enc = enc.getEnclosingSymbol();
                    continue;
                }
                if (this.token == null || !t.pragma_prefix.equals(this.token.pragma_prefix)) break;
                String enclosingName = enc.name;
                if (enc instanceof Module) {
                    String enclosingModuleName = ((Module)enc).originalModuleName();
                    if (!enclosingModuleName.startsWith("org")) {
                        enclosingName = ((Module)enc).originalModuleName();
                    }
                    if (enc.isEscaped()) {
                        enclosingName = enclosingName.substring(1);
                    }
                }
                sb.insert(0, enclosingName + "/");
                enc = enc.getEnclosingSymbol();
            }
            if (this.isEscaped()) {
                sb.append(this.name.substring(1));
            } else {
                sb.append(this.name);
            }
            this._id = this.token != null && this.token.pragma_prefix.length() > 0 ? "IDL:" + this.token.pragma_prefix + "/" + sb.toString().replace('.', '/') + ":" + this.version() : "IDL:" + sb.toString().replace('.', '/') + ":" + this.version();
        }
        Environment.output(2, "Id for name " + this.name + " is " + this._id);
        return this._id;
    }

    private final String version() {
        IdlSymbol enc = this;
        if (this._version == null) {
            String tmp;
            block9: {
                while (true) {
                    Hashtable h;
                    if (enc != null && !(enc instanceof Scope)) {
                        enc = enc.getEnclosingSymbol();
                        continue;
                    }
                    if (enc == null) break;
                    ScopeData sd = ((Scope)((Object)enc)).getScopeData();
                    if (sd == null) {
                        parser.fatal_error("ScopeDate null for " + this.name + " " + this.getClass().getName(), null);
                    }
                    if ((tmp = (String)(h = sd.versionMap).get(this.name)) != null) {
                        this._version = tmp;
                        break block9;
                    }
                    enc = enc.getEnclosingSymbol();
                }
                this._version = "1.0";
            }
            if (enc != null) {
                enc = enc.getEnclosingSymbol();
            }
            while (true) {
                if (enc != null && !(enc instanceof Scope)) {
                    enc = enc.getEnclosingSymbol();
                    continue;
                }
                if (enc == null) break;
                Hashtable h = ((Scope)((Object)enc)).getScopeData().versionMap;
                tmp = (String)h.get(this.name);
                if (tmp != null) {
                    lexer.emit_error("Version for " + this.name + " already declared!", enc.get_token());
                    break;
                }
                enc = enc.getEnclosingSymbol();
            }
        }
        return this._version;
    }

    protected boolean generateIncluded() {
        return parser.generateIncluded() && !this.inhibitionFlag;
    }

    public IdlSymbol(int num) {
        super(num);
        this.inhibitionFlag = parser.getInhibitionState();
    }
}

