/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.StringTokenizer;
import org.jacorb.idl.Environment;
import org.jacorb.idl.PositionInfo;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class GlobalInputStream {
    private static InputStream stream;
    private static Stack lookahead_stack;
    private static boolean included;
    private static StringBuffer expandedText;
    private static int pos;
    private static boolean eof;
    private static File currentFile;
    private static String[] path_names;
    static Stack positions;

    public static void init() {
        lookahead_stack = new Stack();
        included = false;
        expandedText = new StringBuffer();
        pos = 0;
        eof = false;
        currentFile = null;
        positions = new Stack();
    }

    public static void setInput(String fname) throws IOException {
        currentFile = new File(fname);
        stream = new FileInputStream(currentFile);
    }

    public static boolean includeState() {
        return included;
    }

    public static void insert(String str) {
        expandedText.insert(pos, str);
    }

    public static void include(String fname, char lookahead, boolean useIncludePath) throws FileNotFoundException {
        included = true;
        PositionInfo position = lexer.getPosition();
        position.file = GlobalInputStream.currentFile();
        position.stream = stream;
        stream = GlobalInputStream.find(fname, useIncludePath);
        positions.push(position);
        lookahead_stack.push(new Character(lookahead));
        Environment.output(2, "Including " + fname);
    }

    public static void setIncludePath(String path) {
        StringTokenizer strtok = new StringTokenizer(path, File.pathSeparator);
        if (path_names == null) {
            path_names = new String[strtok.countTokens()];
            boolean bl = false;
        } else {
            int i = path_names.length;
            String[] _path_names = new String[strtok.countTokens() + path_names.length];
            int j = 0;
            while (j < path_names.length) {
                _path_names[j] = path_names[j];
                ++j;
            }
            path_names = _path_names;
        }
        while (strtok.hasMoreTokens()) {
            GlobalInputStream.path_names[i++] = strtok.nextToken();
        }
    }

    private static final FileInputStream find(String fname, boolean useIncludePath) throws FileNotFoundException {
        if (!useIncludePath) {
            if (fname.indexOf(File.separator) != 0) {
                String dir = null;
                try {
                    dir = currentFile.getCanonicalPath();
                    if (dir.indexOf(File.separator) > -1) {
                        dir = dir.substring(0, dir.lastIndexOf(File.separator));
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                Environment.output(3, "opening " + dir + File.separator + fname);
                currentFile = new File(dir + File.separator + fname);
            } else {
                currentFile = new File(fname);
            }
            try {
                return new FileInputStream(currentFile);
            }
            catch (IOException iof) {
                return GlobalInputStream.find(fname, true);
            }
        }
        if (path_names == null) {
            parser.fatal_error("File " + fname + " not found in include path", null);
        } else {
            int i = 0;
            while (i < path_names.length) {
                try {
                    Environment.output(3, "opening " + path_names[i] + File.separator + fname);
                    currentFile = new File(path_names[i] + File.separator + fname);
                    return new FileInputStream(currentFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ++i;
                }
            }
        }
        parser.fatal_error("File " + fname + " not found in include path", null);
        return null;
    }

    public static File currentFile() {
        return currentFile;
    }

    public static InputStream currentStream() {
        return stream;
    }

    public static int read() throws IOException {
        int ch = 0;
        if (eof) {
            return -1;
        }
        if (expandedText.length() > 0) {
            if (pos < expandedText.length()) {
                ch = expandedText.charAt(pos++);
            }
            if (pos == expandedText.length()) {
                expandedText = new StringBuffer();
                pos = 0;
            }
        } else {
            ch = stream.read();
            if (ch == -1) {
                if (included) {
                    stream.close();
                    parser.setInhibitionState(false);
                    PositionInfo positionInfo = (PositionInfo)positions.pop();
                    stream = positionInfo.stream;
                    currentFile = positionInfo.file;
                    ch = ((Character)lookahead_stack.pop()).charValue();
                    included = !positions.empty();
                    Environment.output(3, "returning to " + currentFile + " included: " + included);
                    lexer.restorePosition(positionInfo);
                } else {
                    eof = true;
                }
            }
        }
        return ch;
    }
}

