/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

public final class Environment {
    private static int _verbosity = 0;

    public static final int verbosityLevel() {
        return _verbosity;
    }

    public static final void verbosityLevel(int level) {
        _verbosity = level;
    }

    public static final void printTrace(int msg_level) {
        if (msg_level > _verbosity) {
            try {
                throw new RuntimeException();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final void output(int msg_level, String msg) {
        if (msg_level > _verbosity) {
            return;
        }
        System.out.println("   [ " + msg + " ]");
    }

    public static final void output(int msg_level, String name, byte[] bs) {
        Environment.output(msg_level, name, bs, bs.length);
    }

    public static final void output(int msg_level, String name, byte[] bs, int len) {
        if (msg_level > _verbosity) {
            return;
        }
        System.out.print("\nHexdump [" + name + "] len=" + len + "," + bs.length);
        String chars = "";
        int i = 0;
        while (i < len) {
            if (i % 16 == 0) {
                System.out.println(chars);
                chars = "";
            }
            chars = chars + Environment.toAscii(bs[i]);
            System.out.print(Environment.toHex(bs[i]));
            if (3 == i % 4) {
                chars = chars + " ";
                System.out.print(" ");
            }
            ++i;
        }
        System.out.println(chars);
    }

    public static final String toHex(byte b) {
        int n1 = (b & 0xFF) / 16;
        int n2 = (b & 0xFF) % 16;
        char c1 = (char)(n1 > 9 ? 65 + (n1 - 10) : 48 + n1);
        char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
        return "" + c1 + c2 + " ";
    }

    public static final char toAscii(byte b) {
        if (b > 31 && b < 127) {
            return (char)b;
        }
        return '.';
    }

    public static final void output(int msg_level, Throwable e) {
        if (msg_level > _verbosity) {
            return;
        }
        System.out.println("############################ StackTrace ############################");
        e.printStackTrace(System.out);
        System.out.println("####################################################################");
    }

    public static final void doAssert(int msg_level, boolean expression, String msg) {
        if (msg_level <= _verbosity && !expression) {
            throw new RuntimeException("AssertionViolation: " + msg);
        }
    }

    public static final void doAssert(boolean expression, String msg) {
        Environment.doAssert(1, expression, msg);
    }
}

