/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.FixedPointType;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SequenceType;
import org.jacorb.idl.StringType;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;
import org.jacorb.idl.parser;

public class AliasTypeSpec
extends TypeSpec {
    public TypeSpec originalType = null;
    private boolean written = false;

    public Object clone() {
        AliasTypeSpec alias = new AliasTypeSpec((TypeSpec)this.type_spec.clone());
        alias.name = this.name;
        alias.pack_name = this.pack_name;
        return alias;
    }

    public String full_name() {
        if (this.pack_name.length() > 0) {
            String s = ScopedName.unPseudoName(this.pack_name + "." + this.name);
            if (!s.startsWith("org.omg")) {
                return this.omg_package_prefix + s;
            }
            return s;
        }
        return ScopedName.unPseudoName(this.name);
    }

    public String typeName() {
        return this.originalType.typeName();
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public TypeSpec originalType() {
        return this.originalType;
    }

    public void setPackage(String s) {
        this.pack_name = this.pack_name.length() > 0 ? new String(s + "." + this.pack_name) : s;
        this.pack_name = parser.pack_replace(this.pack_name);
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public boolean basic() {
        return false;
    }

    public void parse() {
        if (this.originalType instanceof TemplateTypeSpec) {
            ((TemplateTypeSpec)this.originalType).markTypeDefd();
        }
        if (this.originalType instanceof ConstrTypeSpec || this.originalType instanceof FixedPointType || this.originalType instanceof SequenceType || this.originalType instanceof ArrayTypeSpec) {
            this.originalType.parse();
            if (this.originalType.typeName().indexOf(46) < 0) {
                String tName = null;
                tName = this.originalType instanceof VectorType ? this.originalType.typeName().substring(0, this.originalType.typeName().indexOf(91)) : this.originalType.typeName();
                this.addImportedName(tName);
            }
        }
        if (this.originalType instanceof ScopedName) {
            this.originalType = ((ScopedName)this.originalType).resolvedTypeSpec();
            if (this.originalType instanceof AliasTypeSpec) {
                this.addImportedAlias(this.originalType.full_name());
            } else {
                this.addImportedName(this.originalType.typeName());
            }
        }
    }

    public String toString() {
        return this.originalType.toString();
    }

    public String getTypeCodeExpression() {
        return this.full_name() + "Helper.type()";
    }

    public String className() {
        String cName;
        String fullName = this.full_name();
        if (fullName.indexOf(46) > 0) {
            this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
            String string = fullName.substring(fullName.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            cName = fullName;
        }
        return cName;
    }

    public void print(PrintWriter ps) {
        this.setPrintPhaseNames();
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.written) {
            return;
        }
        this.written = true;
        try {
            if (!(this.originalType.typeSpec() instanceof TemplateTypeSpec)) {
                this.originalType.print(ps);
            }
            String className = this.className();
            String path = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File dir = new File(path);
            if (!dir.exists() && !dir.mkdirs()) {
                parser.fatal_error("Unable to create " + path, null);
            }
            String fname = null;
            PrintWriter decl_ps = null;
            if (this.originalType instanceof TemplateTypeSpec && !(this.originalType instanceof StringType)) {
                fname = className + "Holder.java";
                decl_ps = new PrintWriter(new FileWriter(new File(dir, fname)));
                this.printHolderClass(className, decl_ps);
                decl_ps.close();
            }
            fname = className + "Helper.java";
            decl_ps = new PrintWriter(new FileWriter(new File(dir, fname)));
            this.printHelperClass(className, decl_ps);
            decl_ps.close();
            this.written = true;
        }
        catch (IOException i) {
            System.err.println("File IO error");
            i.printStackTrace();
        }
    }

    public String printReadStatement(String varname, String streamname) {
        if (this.doUnwind()) {
            return this.originalType.printReadStatement(varname, streamname);
        }
        return varname + " = " + this.full_name() + "Helper.read(" + streamname + ");";
    }

    public String printReadExpression(String streamname) {
        if (this.doUnwind()) {
            return this.originalType.printReadExpression(streamname);
        }
        return this.full_name() + "Helper.read(" + streamname + ")";
    }

    public String printWriteStatement(String var_name, String streamname) {
        if (this.doUnwind()) {
            return this.originalType.printWriteStatement(var_name, streamname);
        }
        return this.full_name() + "Helper.write(" + streamname + "," + var_name + ");";
    }

    private final void printClassComment(String className, PrintWriter ps) {
        ps.println("/**");
        ps.println(" *\tGenerated from IDL definition of alias \"" + className + "\"");
        ps.println(" *\t@author JacORB IDL compiler ");
        ps.println(" */\n");
    }

    private final boolean doUnwind() {
        return this.originalType.basic() && (!(this.originalType instanceof TemplateTypeSpec) || this.originalType instanceof StringType) || this.originalType instanceof AliasTypeSpec || this.originalType instanceof ConstrTypeSpec || this.originalType instanceof AnyType;
    }

    public String holderName() {
        if (this.doUnwind()) {
            return this.originalType.holderName();
        }
        return this.full_name() + "Holder";
    }

    private final void printHolderClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment(className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + this.originalType.typeName() + " value;\n");
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + this.originalType.typeName() + " initial)");
        ps.println("\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + className + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + className + "Helper.read (in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream out)");
        ps.println("\t{");
        ps.println("\t\t" + className + "Helper.write (out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private final void printHelperClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        this.printImport(ps);
        this.printClassComment(className, ps);
        ps.println("public" + parser.getFinalString() + " class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = null;\n");
        String type = this.originalType.typeName();
        ps.println("\tpublic static void insert (org.omg.CORBA.Any any, " + type + " s)");
        ps.println("\t{");
        ps.println("\t\tany.type (type ());");
        ps.println("\t\twrite (any.create_output_stream (), s);");
        ps.println("\t}\n");
        ps.println("\tpublic static " + type + " extract (final org.omg.CORBA.Any any)");
        ps.println("\t{");
        ps.println("\t\treturn read (any.create_input_stream ());");
        ps.println("\t}\n");
        ps.println("\tpublic static org.omg.CORBA.TypeCode type ()");
        ps.println("\t{");
        ps.println("\t\tif( _type == null )");
        ps.println("\t\t{");
        ps.println("\t\t\t_type = org.omg.CORBA.ORB.init().create_alias_tc(" + this.full_name() + "Helper.id(), \"" + this.name + "\"," + this.originalType.typeSpec().getTypeCodeExpression() + " );");
        ps.println("\t\t}");
        ps.println("\t\treturn _type;");
        ps.println("\t}\n");
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\t" + type + " _result;");
        ps.println("\t\t" + this.originalType.printReadStatement("_result", "_in"));
        ps.println("\t\treturn _result;");
        ps.println("\t}\n");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream _out, " + type + " _s)");
        ps.println("\t{");
        ps.println("\t\t" + this.originalType.printWriteStatement("_s", "_out"));
        ps.println("\t}");
        ps.println("}");
    }

    public AliasTypeSpec(TypeSpec ts) {
        super(IdlSymbol.new_num());
        this.originalType = ts;
    }
}

