/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java_cup.runtime.char_token;
import java_cup.runtime.float_token;
import java_cup.runtime.int_token;
import java_cup.runtime.token;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.Module;
import org.jacorb.idl.PositionInfo;
import org.jacorb.idl.fixed_token;
import org.jacorb.idl.parser;
import org.jacorb.idl.str_token;

public class lexer {
    protected static int next_char;
    protected static int next_char2;
    protected static final int EOF_CHAR = -1;
    protected static Hashtable keywords;
    protected static Hashtable keywords_lower_case;
    protected static Hashtable java_keywords;
    protected static Hashtable char_symbols;
    protected static Hashtable defines;
    protected static boolean conditionalCompilation;
    private static Stack ifStack;
    private static Stack tokenStack;
    protected static int current_line;
    protected static StringBuffer line;
    protected static int current_position;
    protected static boolean in_string;
    public static int error_count;
    public static int warning_count;
    public static String currentPragmaPrefix;

    public static void reset() {
        current_position = 1;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
        line = new StringBuffer();
        ifStack.removeAllElements();
        tokenStack.removeAllElements();
        defines.clear();
    }

    public static void init() throws IOException {
        defines.put("JACORB_IDL_1_3", "");
        keywords.put("abstract", new Integer(2));
        keywords.put("any", new Integer(3));
        keywords.put("attribute", new Integer(4));
        keywords.put("boolean", new Integer(5));
        keywords.put("case", new Integer(6));
        keywords.put("char", new Integer(7));
        keywords.put("const", new Integer(8));
        keywords.put("context", new Integer(9));
        keywords.put("custom", new Integer(10));
        keywords.put("default", new Integer(11));
        keywords.put("double", new Integer(12));
        keywords.put("enum", new Integer(13));
        keywords.put("exception", new Integer(14));
        keywords.put("factory", new Integer(15));
        keywords.put("FALSE", new Integer(16));
        keywords.put("fixed", new Integer(17));
        keywords.put("float", new Integer(18));
        keywords.put("in", new Integer(19));
        keywords.put("inout", new Integer(20));
        keywords.put("interface", new Integer(21));
        keywords.put("long", new Integer(22));
        keywords.put("module", new Integer(23));
        keywords.put("native", new Integer(24));
        keywords.put("Object", new Integer(25));
        keywords.put("octet", new Integer(26));
        keywords.put("oneway", new Integer(27));
        keywords.put("out", new Integer(28));
        keywords.put("private", new Integer(29));
        keywords.put("public", new Integer(30));
        keywords.put("pseudo", new Integer(31));
        keywords.put("raises", new Integer(32));
        keywords.put("readonly", new Integer(33));
        keywords.put("sequence", new Integer(34));
        keywords.put("short", new Integer(35));
        keywords.put("string", new Integer(36));
        keywords.put("struct", new Integer(37));
        keywords.put("supports", new Integer(38));
        keywords.put("switch", new Integer(39));
        keywords.put("TRUE", new Integer(40));
        keywords.put("truncatable", new Integer(41));
        keywords.put("typedef", new Integer(42));
        keywords.put("unsigned", new Integer(43));
        keywords.put("union", new Integer(44));
        keywords.put("ValueBase", new Integer(45));
        keywords.put("valuetype", new Integer(46));
        keywords.put("void", new Integer(47));
        keywords.put("wchar", new Integer(48));
        keywords.put("wstring", new Integer(49));
        keywords.put("int", new Integer(81));
        keywords.put("::", new Integer(75));
        keywords.put("<<", new Integer(77));
        keywords.put(">>", new Integer(76));
        keywords.put("L\"", new Integer(78));
        Enumeration enumeration = keywords.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.toLowerCase();
            keywords_lower_case.put(string2, string);
        }
        char_symbols.put(new Integer(59), new Integer(50));
        char_symbols.put(new Integer(44), new Integer(51));
        char_symbols.put(new Integer(42), new Integer(52));
        char_symbols.put(new Integer(46), new Integer(53));
        char_symbols.put(new Integer(58), new Integer(54));
        char_symbols.put(new Integer(61), new Integer(55));
        char_symbols.put(new Integer(43), new Integer(56));
        char_symbols.put(new Integer(45), new Integer(57));
        char_symbols.put(new Integer(123), new Integer(60));
        char_symbols.put(new Integer(125), new Integer(61));
        char_symbols.put(new Integer(40), new Integer(58));
        char_symbols.put(new Integer(41), new Integer(59));
        char_symbols.put(new Integer(91), new Integer(62));
        char_symbols.put(new Integer(93), new Integer(63));
        char_symbols.put(new Integer(60), new Integer(64));
        char_symbols.put(new Integer(62), new Integer(65));
        char_symbols.put(new Integer(39), new Integer(66));
        char_symbols.put(new Integer(34), new Integer(67));
        char_symbols.put(new Integer(92), new Integer(68));
        char_symbols.put(new Integer(94), new Integer(70));
        char_symbols.put(new Integer(38), new Integer(71));
        char_symbols.put(new Integer(47), new Integer(72));
        char_symbols.put(new Integer(37), new Integer(73));
        char_symbols.put(new Integer(126), new Integer(74));
        char_symbols.put(new Integer(124), new Integer(69));
        java_keywords.put("abstract", "");
        java_keywords.put("boolean", "");
        java_keywords.put("break", "");
        java_keywords.put("byte", "");
        java_keywords.put("case", "");
        java_keywords.put("catch", "");
        java_keywords.put("char", "");
        java_keywords.put("class", "");
        java_keywords.put("const", "");
        java_keywords.put("continue", "");
        java_keywords.put("default", "");
        java_keywords.put("do", "");
        java_keywords.put("double", "");
        java_keywords.put("else", "");
        java_keywords.put("extends", "");
        java_keywords.put("false", "");
        java_keywords.put("final", "");
        java_keywords.put("finally", "");
        java_keywords.put("for", "");
        java_keywords.put("float", "");
        java_keywords.put("goto", "");
        java_keywords.put("if", "");
        java_keywords.put("implements", "");
        java_keywords.put("import", "");
        java_keywords.put("instanceof", "");
        java_keywords.put("int", "");
        java_keywords.put("interface", "");
        java_keywords.put("long", "");
        java_keywords.put("native", "");
        java_keywords.put("new", "");
        java_keywords.put("null", "");
        java_keywords.put("package", "");
        java_keywords.put("protected", "");
        java_keywords.put("private", "");
        java_keywords.put("public", "");
        java_keywords.put("return", "");
        java_keywords.put("short", "");
        java_keywords.put("static", "");
        java_keywords.put("super", "");
        java_keywords.put("switch", "");
        java_keywords.put("synchronized", "");
        java_keywords.put("true", "");
        java_keywords.put("this", "");
        java_keywords.put("throw", "");
        java_keywords.put("throws", "");
        java_keywords.put("transient", "");
        java_keywords.put("try", "");
        java_keywords.put("volatile", "");
        java_keywords.put("void", "");
        java_keywords.put("while", "");
        java_keywords.put("clone", "");
        java_keywords.put("equals", "");
        java_keywords.put("finalize", "");
        java_keywords.put("getClass", "");
        java_keywords.put("hashCode", "");
        java_keywords.put("notify", "");
        java_keywords.put("toString", "");
        java_keywords.put("wait", "");
        ifStack.push(new Boolean(true));
        try {
            next_char = GlobalInputStream.read();
        }
        catch (Exception exception) {
            parser.fatal_error("Cannot read from file " + GlobalInputStream.currentFile().getAbsolutePath() + ", please check file name.", null);
        }
        next_char2 = next_char == -1 ? -1 : GlobalInputStream.read();
    }

    public static void define(String string, String string2) {
        Environment.output(4, "Defining: " + string + " as " + string2);
        defines.put(string, string2);
    }

    public static void undefine(String string) {
        Environment.output(4, "Un-defining: " + string);
        defines.remove(string);
    }

    public static String defined(String string) {
        return (String)defines.get(string);
    }

    public static int currentLine() {
        return current_line;
    }

    public static PositionInfo getPosition() {
        return new PositionInfo(current_line, current_position, currentPragmaPrefix, line.toString());
    }

    public static void restorePosition(PositionInfo positionInfo) {
        current_line = positionInfo.line_no;
        currentPragmaPrefix = positionInfo.pragma_prefix;
        current_position = 0;
    }

    protected static void advance() throws IOException {
        int n = next_char;
        next_char = next_char2;
        next_char2 = GlobalInputStream.read();
        line.append((char)n);
        ++current_position;
        if (n == 10) {
            ++current_line;
            current_position = 1;
            line = new StringBuffer();
        }
    }

    public static void emit_error(String string) {
        System.err.println(GlobalInputStream.currentFile().getAbsolutePath() + ", line: " + current_line + "(" + current_position + "): " + string);
        System.err.println("\t" + line.toString());
        ++error_count;
    }

    public static void emit_error(String string, str_token str_token2) {
        if (str_token2 == null) {
            lexer.emit_error(string);
        } else {
            System.err.println("Error in " + str_token2.fileName + ", line:" + str_token2.line_no + "(" + str_token2.char_pos + "): " + string);
            System.err.println("\t" + str_token2.line_val);
        }
        ++error_count;
    }

    public static void emit_warn(String string) {
        System.err.println("Warning: " + string + " at " + current_line + "(" + current_position + "): \"" + line.toString() + "\"");
        ++warning_count;
    }

    public static void emit_warn(String string, str_token str_token2) {
        if (str_token2 == null) {
            lexer.emit_warn(string);
        } else {
            System.err.println("Warning at " + str_token2.fileName + ", line:" + str_token2.line_no + "(" + str_token2.char_pos + "): " + string);
            System.err.println("\t" + str_token2.line_val);
        }
        ++error_count;
    }

    protected static boolean id_start_char(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95;
    }

    protected static boolean id_char(int n) {
        return lexer.id_start_char(n) || n == 95 || n >= 48 && n <= 57;
    }

    protected static int find_single_char(int n) {
        Integer n2 = (Integer)char_symbols.get(new Integer((char)n));
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    protected static void swallow_comment() throws IOException {
        if (next_char2 == 42) {
            lexer.advance();
            lexer.advance();
            while (true) {
                if (next_char == -1) {
                    lexer.emit_error("Specification file ends inside a comment", null);
                    return;
                }
                if (next_char == 42 && next_char2 == 47) {
                    lexer.advance();
                    lexer.advance();
                    return;
                }
                lexer.advance();
            }
        }
        if (next_char2 == 47) {
            lexer.advance();
            lexer.advance();
            while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
                lexer.advance();
            }
            return;
        }
        lexer.emit_error("Malformed comment in specification -- ignored", null);
        lexer.advance();
    }

    protected static void preprocess() throws IOException {
        CharSequence charSequence;
        if (next_char == -1) {
            lexer.emit_error("Specification file ends inside a preprocessor directive", null);
            return;
        }
        if (next_char != 35) {
            lexer.emit_error("expected #, got " + (char)next_char + " instead!", null);
        } else {
            lexer.advance();
        }
        while (32 == next_char || 9 == next_char) {
            lexer.advance();
        }
        String string = lexer.get_string();
        if (string.equals("include")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.advance();
            boolean bl = next_char == 60;
            lexer.advance();
            String string2 = lexer.get_string();
            if (bl && next_char != 62) {
                lexer.emit_error("Syntax error in #include directive, expecting '>'");
            } else if (!bl && next_char != 34) {
                lexer.emit_error("Syntax error in #include directive, expecting \"");
            }
            while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
                lexer.advance();
            }
            GlobalInputStream.include(string2, (char)next_char2, bl);
            current_line = 0;
            lexer.advance();
            lexer.advance();
            return;
        }
        if (string.equals("define")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String string3 = lexer.get_string();
            charSequence = new StringBuffer();
            if (next_char == 32) {
                lexer.advance();
            }
            while (next_char != 10) {
                if (next_char == 92) {
                    lexer.advance();
                    lexer.advance();
                }
                ((StringBuffer)charSequence).append((char)next_char);
                lexer.advance();
            }
            lexer.define(string3, ((StringBuffer)charSequence).toString());
        } else if (string.equals("error")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.advance();
            String string4 = lexer.get_string();
            lexer.emit_error(string4);
        } else if (string.equals("undef")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String string5 = lexer.get_string();
            lexer.undefine(string5);
        } else if (string.equals("if")) {
            boolean bl;
            ifStack.push(new Boolean(conditionalCompilation));
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            boolean bl2 = true;
            if (33 == next_char) {
                lexer.advance();
                bl2 = false;
            }
            if (!((String)(charSequence = lexer.get_string_no_paren())).equals("defined")) {
                lexer.emit_error("Expected \"defined\" following #if: " + string, null);
                return;
            }
            lexer.swallow_whitespace();
            boolean bl3 = bl = 40 == next_char;
            if (bl) {
                lexer.advance();
                lexer.swallow_whitespace();
            }
            String string6 = lexer.get_string_no_paren();
            if (bl) {
                lexer.swallow_whitespace();
                Environment.output(4, "next char: " + next_char);
                if (41 != next_char) {
                    lexer.emit_error("Expected ) terminating #if defined", null);
                    return;
                }
                lexer.advance();
            }
            conditionalCompilation = bl2 ? null != lexer.defined(string6) : null == lexer.defined(string6);
        } else if (string.equals("ifdef")) {
            ifStack.push(new Boolean(conditionalCompilation));
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String string7 = lexer.get_string();
            conditionalCompilation = lexer.defined(string7) != null;
        } else if (string.equals("ifndef")) {
            ifStack.push(new Boolean(conditionalCompilation));
            if (!conditionalCompilation) {
                return;
            }
            lexer.swallow_whitespace();
            String string8 = lexer.get_string();
            conditionalCompilation = lexer.defined(string8) == null;
        } else if (string.equals("else")) {
            if (((Boolean)ifStack.peek()).booleanValue()) {
                conditionalCompilation = !conditionalCompilation;
            }
        } else if (string.equals("endif")) {
            boolean bl;
            conditionalCompilation = bl = ((Boolean)ifStack.pop()).booleanValue();
        } else if (string.equals("pragma")) {
            if (!conditionalCompilation) {
                return;
            }
            lexer.advance();
            String string9 = lexer.get_string();
            if (string9.equals("prefix")) {
                lexer.advance();
                charSequence = lexer.get_string();
                currentPragmaPrefix = charSequence;
            } else if (string9.equals("version")) {
                lexer.advance();
                charSequence = lexer.get_string();
                lexer.advance();
                String string10 = lexer.get_string();
                parser.currentScopeData().versionMap.put(charSequence, string10);
            } else if (string9.equals("ID")) {
                lexer.advance();
                charSequence = lexer.get_string();
                lexer.advance();
                String string11 = lexer.get_string();
            } else if (string9.equals("local")) {
                parser.setLocalityContraint();
            } else if (string9.equals("inhibit_code_generation")) {
                parser.setInhibitionState(true);
            } else {
                lexer.emit_warn("Unknown pragma, ignoring: #pragma " + string9, null);
            }
        } else {
            lexer.emit_error("Unrecognized preprocessor directive " + string, null);
        }
        while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
            lexer.advance();
        }
    }

    private static String get_string_no_paren() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = (char)next_char;
        while (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f' && c != '\uffffffff' && c != '\"' && c != '<' && c != '>' && c != '(' && c != ')') {
            stringBuffer.append(c);
            lexer.advance();
            c = (char)next_char;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String get_string() throws IOException {
        block3: {
            var0 = new StringBuffer("");
            if (lexer.next_char != 34) ** GOTO lbl15
            lexer.advance();
            while (lexer.next_char != 34) {
                if (lexer.next_char == -1) {
                    lexer.emit_error("Unexpected EOF in string");
                }
                var0.append((char)lexer.next_char);
                lexer.advance();
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var0.append((char)lexer.next_char);
                lexer.advance();
lbl15:
                // 2 sources

                ** while (lexer.next_char != 32 && lexer.next_char != 9 && lexer.next_char != 13 && lexer.next_char != 10 && lexer.next_char != 12 && lexer.next_char != -1 && lexer.next_char != 34 && lexer.next_char != 60 && lexer.next_char != 62)
            }
        }
        return var0.toString();
    }

    protected static token do_symbol() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Integer n = null;
        char[] cArray = new char[]{(char)next_char};
        stringBuffer.append(cArray, 0, 1);
        lexer.advance();
        while (lexer.id_char(next_char)) {
            cArray[0] = (char)next_char;
            stringBuffer.append(cArray, 0, 1);
            lexer.advance();
        }
        String string = stringBuffer.toString();
        String string2 = lexer.defined(string);
        if (string2 != null) {
            char[] cArray2 = new char[]{(char)next_char, (char)next_char2};
            GlobalInputStream.insert(string2 + new String(cArray2));
            lexer.advance();
            lexer.advance();
            return null;
        }
        n = (Integer)keywords.get(string);
        if (n != null) {
            if (lexer.isScope(string)) {
                parser.openScope();
            }
            return new token(n);
        }
        if (null != (string = lexer.checkIdentifier(string))) {
            return new str_token(79, string, lexer.getPosition(), GlobalInputStream.currentFile().getName());
        }
        return null;
    }

    private static boolean isScope(String string) {
        return string.equals("module") || string.equals("interface") || string.equals("struct") || string.equals("exception") || string.equals("union");
    }

    public static String checkIdentifier(String string) {
        if (string.charAt(0) == '_') {
            return string.substring(1);
        }
        String string2 = (String)keywords_lower_case.get(string.toLowerCase());
        if (string2 != null) {
            lexer.emit_error("Identifier " + string + " collides with keyword " + string2 + ".");
            return null;
        }
        if (lexer.needsJavaEscape(string)) {
            return "_" + string;
        }
        return string;
    }

    private static boolean needsJavaEscape(String string) {
        return java_keywords.containsKey(string);
    }

    public static boolean strictJavaEscapeCheck(String string) {
        return !string.equals("Helper") && string.endsWith("Helper") || !string.equals("Holder") && string.endsWith("Holder") || !string.equals("Operations") && string.endsWith("Operations") || !string.equals("Package") && string.endsWith("Package") || !string.equals("POA") && string.endsWith("POA") || !string.equals("POATie") && string.endsWith("POATie");
    }

    public static boolean needsJavaEscape(Module module) {
        String string = module.pack_name;
        Environment.output(4, "checking module name " + string);
        return lexer.strictJavaEscapeCheck(string);
    }

    public static token next_token() throws IOException {
        parser.set_included(GlobalInputStream.includeState());
        token token2 = lexer.real_next_token();
        return token2;
    }

    private static void swallow_whitespace() throws IOException {
        while (next_char == 32 || next_char == 9 || next_char == 10 || next_char == 12 || next_char == 13) {
            lexer.advance();
        }
    }

    protected static token real_next_token() throws IOException {
        if (!tokenStack.empty()) {
            return (token)tokenStack.pop();
        }
        while (true) {
            CharSequence charSequence;
            Object object;
            if (!in_string) {
                int n;
                lexer.swallow_whitespace();
                if ((char)next_char == '#') {
                    lexer.preprocess();
                    continue;
                }
                if (next_char == 47 && (next_char2 == 42 || next_char2 == 47)) {
                    lexer.swallow_comment();
                    continue;
                }
                if (!conditionalCompilation) {
                    lexer.advance();
                    if (next_char != -1) continue;
                    lexer.emit_error("EOF in conditional compilation!", null);
                    return null;
                }
                if (next_char == 58) {
                    if (next_char2 == 58) {
                        lexer.advance();
                        lexer.advance();
                        return new token(75);
                    }
                    lexer.advance();
                    return new token(54);
                }
                if (next_char == 76 && next_char2 == 34) {
                    lexer.advance();
                    lexer.advance();
                    in_string = true;
                    return new token(78);
                }
                if (next_char == 48) {
                    int n2 = 0;
                    int n3 = 8;
                    n = 0;
                    lexer.advance();
                    if (next_char == 46) {
                        StringBuffer stringBuffer = new StringBuffer("0.");
                        lexer.advance();
                        while (next_char >= 48 && next_char <= 57) {
                            stringBuffer.append((char)next_char);
                            lexer.advance();
                        }
                        float f = new Float(stringBuffer.toString()).floatValue();
                        return new float_token(84, f);
                    }
                    if (next_char == 120 || next_char == 88) {
                        lexer.advance();
                        n3 = 16;
                    }
                    n = Character.digit((char)next_char, n3);
                    while (n != -1) {
                        n2 = n2 * n3 + n;
                        lexer.advance();
                        n = Character.digit((char)next_char, n3);
                    }
                    return new int_token(82, n2);
                }
                if (next_char >= 48 && next_char <= 57 || next_char == 46) {
                    object = new StringBuffer();
                    charSequence = null;
                    n = 0;
                    while (next_char >= 48 && next_char <= 57) {
                        ((StringBuffer)object).append((char)next_char);
                        lexer.advance();
                    }
                    if (next_char == 46) {
                        charSequence = new StringBuffer();
                        lexer.advance();
                        while (next_char >= 48 && next_char <= 57) {
                            ((StringBuffer)charSequence).append((char)next_char);
                            lexer.advance();
                        }
                    }
                    if (next_char == 101 || next_char == 69) {
                        if (charSequence == null) {
                            charSequence = new StringBuffer();
                        }
                        ((StringBuffer)charSequence).append('e');
                        lexer.advance();
                        if (next_char == 45 || next_char == 43) {
                            ((StringBuffer)charSequence).append((char)next_char);
                            lexer.advance();
                        }
                        while (next_char >= 48 && next_char <= 57) {
                            ((StringBuffer)charSequence).append((char)next_char);
                            lexer.advance();
                        }
                        if (((StringBuffer)charSequence).length() == 1) {
                            lexer.emit_error("Empty exponent in float/double.");
                            continue;
                        }
                        return new float_token(84, Float.valueOf(((StringBuffer)object).toString() + "." + ((StringBuffer)charSequence).toString()).floatValue());
                    }
                    if (next_char == 100 || next_char == 68) {
                        lexer.advance();
                        if (charSequence == null) {
                            charSequence = new StringBuffer();
                        }
                        BigDecimal bigDecimal = new BigDecimal(((StringBuffer)object).toString() + "." + ((StringBuffer)charSequence).toString());
                        return new fixed_token(85, bigDecimal);
                    }
                    if (charSequence == null) {
                        return new int_token(82, Integer.parseInt(((StringBuffer)object).toString()));
                    }
                    try {
                        float f = Float.valueOf(((StringBuffer)object).toString() + "." + ((StringBuffer)charSequence).toString()).floatValue();
                        return new float_token(84, f);
                    }
                    catch (NumberFormatException numberFormatException) {
                        lexer.emit_error("Unexpected symbol:  " + ((StringBuffer)object).toString() + "." + ((StringBuffer)charSequence).toString());
                    }
                }
                int n4 = lexer.find_single_char(next_char);
                if ((char)next_char == '\"') {
                    in_string = true;
                    lexer.advance();
                    return new token(67);
                }
                if ((char)next_char == '\'') {
                    lexer.advance();
                    object = new char_token(80, (char)next_char);
                    lexer.advance();
                    if ((char)next_char == '\'') {
                        tokenStack.push(new token(66));
                        tokenStack.push(object);
                        lexer.advance();
                    } else {
                        lexer.emit_error("Expecting closing '");
                    }
                    return new token(66);
                }
                if (n4 != -1) {
                    lexer.advance();
                    return new token(n4);
                }
                if (lexer.id_start_char(next_char)) {
                    object = lexer.do_symbol();
                    if (object == null) continue;
                    return object;
                }
                if (next_char == -1) {
                    return new token(0);
                }
            } else {
                if ((char)next_char == '\"') {
                    in_string = false;
                    lexer.advance();
                    return new token(67);
                }
                object = new StringBuffer();
                while ((char)next_char != '\"') {
                    ((StringBuffer)object).append((char)next_char);
                    lexer.advance();
                }
                charSequence = ((StringBuffer)object).toString();
                return new str_token(79, (String)charSequence, lexer.getPosition(), GlobalInputStream.currentFile().getName());
            }
            lexer.emit_warn("Unrecognized character '" + new Character((char)next_char) + "'(" + next_char + ") -- ignored");
            lexer.advance();
        }
    }

    static {
        keywords = new Hashtable();
        keywords_lower_case = new Hashtable();
        java_keywords = new Hashtable();
        char_symbols = new Hashtable(25);
        defines = new Hashtable();
        conditionalCompilation = true;
        ifStack = new Stack();
        tokenStack = new Stack();
        current_line = 1;
        line = new StringBuffer();
        current_position = 1;
        in_string = false;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
    }
}

