/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.ConstType;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Environment;
import org.jacorb.idl.FixedPointConstType;
import org.jacorb.idl.FixedPointType;
import org.jacorb.idl.FloatType;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.OctetType;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.ShortType;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

class ConstDecl
extends Declaration {
    private static Hashtable values = new Hashtable();
    private static Hashtable declarations = new Hashtable();
    private ScopedName t = new ScopedName(IdlSymbol.new_num());
    private int pos_int_const = 0;
    private boolean int_const_set = false;
    public ConstExpr const_expr;
    public ConstType const_type;

    public ConstDecl(int n) {
        super(n);
    }

    public static void init() {
        values.clear();
        declarations.clear();
    }

    public static String namedValue(ScopedName scopedName) {
        String string = scopedName.resolvedName();
        if (values.containsKey(string)) {
            return (String)values.get(string);
        }
        System.out.println(string + " not a defined constant");
        return string;
    }

    public void setPackage(String string) {
        string = parser.pack_replace(string);
        super.setPackage(string);
        this.const_type.setPackage(string);
        this.const_expr.setPackage(string);
        this.t.typeName = this.name;
        this.t.setPackage(string);
    }

    public void parse() {
        this.const_expr.setDeclaration(this);
        try {
            NameTable.define(this.full_name(), "constant");
        }
        catch (NameAlreadyDefined nameAlreadyDefined) {
            parser.error("Constant " + this.full_name() + " already defined", this.token);
        }
        this.const_type.parse();
        this.const_expr.parse();
        this.t.typeName = this.name;
        values.put(this.t.resolvedName() + (this.contained() ? "" : ".value"), this.const_expr.value());
        declarations.put(this.t.resolvedName(), this);
    }

    static ConstDecl getDeclaration(String string) {
        return (ConstDecl)declarations.get(string);
    }

    int pos_int_const() {
        if (!this.int_const_set) {
            this.pos_int_const = this.const_expr.pos_int_const();
            this.int_const_set = true;
        }
        return this.pos_int_const;
    }

    public void printContained(PrintWriter printWriter) {
        TypeSpec typeSpec = this.const_type.symbol.typeSpec();
        if (typeSpec instanceof AliasTypeSpec) {
            typeSpec = ((AliasTypeSpec)typeSpec).originalType();
        }
        printWriter.print("\t" + this.const_type + " " + this.name + " = ");
        if (typeSpec instanceof IntType && ((IntType)typeSpec).type_spec instanceof ShortType) {
            printWriter.print("(short)(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
        } else if (typeSpec instanceof FloatType) {
            printWriter.print("(float)(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
        } else if (typeSpec instanceof FixedPointConstType) {
            printWriter.print("new java.math.BigDecimal(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
        } else if (typeSpec instanceof OctetType) {
            printWriter.print("(byte)(");
            this.const_expr.print(printWriter);
            printWriter.println(");");
        } else {
            this.const_expr.print(printWriter);
            printWriter.println(";");
        }
    }

    boolean contained() {
        boolean bl = false;
        IdlSymbol idlSymbol = this.getEnclosingSymbol();
        while (idlSymbol != null) {
            if (idlSymbol instanceof Interface) {
                bl = true;
                break;
            }
            idlSymbol = idlSymbol.getEnclosingSymbol();
        }
        Environment.output(4, "ConstDecl.contained()? " + this.full_name() + " returns " + bl);
        return bl;
    }

    public void print(PrintWriter printWriter) {
        if (this.contained() || this.included && !this.generateIncluded()) {
            return;
        }
        try {
            String string;
            String string2 = ScopedName.unPseudoName(this.full_name());
            if (string2.indexOf(46) > 0) {
                this.pack_name = string2.substring(0, string2.lastIndexOf(46));
                string = string2.substring(string2.lastIndexOf(46) + 1);
            } else {
                this.pack_name = "";
                string = string2;
            }
            String string3 = parser.out_dir + IdlSymbol.fileSeparator + this.pack_name.replace('.', IdlSymbol.fileSeparator);
            File file = new File(string3);
            if (!file.exists() && !file.mkdirs()) {
                parser.fatal_error("Unable to create " + string3, null);
            }
            String string4 = string + ".java";
            PrintWriter printWriter2 = new PrintWriter(new FileWriter(new File(file, string4)));
            Environment.output(4, "ConstDecl.print " + string4);
            if (!this.pack_name.equals("")) {
                printWriter2.println("package " + this.pack_name + ";");
            }
            printWriter2.println("/**");
            printWriter2.println(" * Automatically generated from IDL const definition ");
            printWriter2.println(" * @author JacORB IDL compiler ");
            printWriter2.println(" */\n");
            printWriter2.println("public interface " + string);
            printWriter2.println("{");
            TypeSpec typeSpec = this.const_type.symbol.typeSpec();
            if (typeSpec instanceof AliasTypeSpec) {
                typeSpec = ((AliasTypeSpec)typeSpec).originalType();
            }
            printWriter2.print("\t" + this.const_type.toString() + " value = ");
            Environment.output(2, "ConstDecl, ts " + this.const_type.toString() + " " + typeSpec.getClass());
            if (typeSpec instanceof ShortType) {
                printWriter2.print("(short)(" + this.const_expr.toString() + ");");
            } else if (typeSpec instanceof FloatType) {
                printWriter2.println("(float)(" + this.const_expr.toString() + ");");
            } else if (typeSpec instanceof OctetType) {
                printWriter2.println("(byte)(" + this.const_expr.toString() + ");");
            } else if (typeSpec instanceof FixedPointConstType || typeSpec instanceof FixedPointType) {
                printWriter2.println("new java.math.BigDecimal(" + this.const_expr.toString() + ");");
            } else {
                printWriter2.println(this.const_expr.toString() + ";");
            }
            printWriter2.println("}");
            printWriter2.close();
        }
        catch (IOException iOException) {
            System.err.println("File IO error");
            iOException.printStackTrace();
        }
    }
}

